{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Strings/Search2.pas              [x] Protected mode

  How to handle tStrings - a more advanced example with substring
  searching using chained strings.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTRING;


var A : pString; S : pToken; Location : word;

begin
     { Create a text string and some substrings. Dynamically
       allocate instances. }
     New (A, Initialize ('Why are things this way? I would prefer them to be different.'));

     New (S, Initialize ('be'));
     { Connect more tokens (substrings)! }
     S^.Connect (New (pToken, Initialize ('are')));
     { Last string does not have to connect, we can even make
       it a tString! }
     S^.Connect (New (pString, Initialize ('to')));

     { Search for substrings in different ways: }

     WriteLn; Location := A^.Size;
     Write ('Found substrings at: ');

     { SYNTAX: SearchBackward (Substring(s), Start, var Match); }
     while A^.SearchBackward (S, Location, Location) do begin
           Write (Location, ' '); Dec (Location); end;

     WriteLn; Location := 0;
     Write ('Found substrings at: ');

     { SYNTAX: SearchBackward (Substring(s), Start, var Match); }
     while A^.SearchForward (S, Location, Location) do begin
           Write (Location, ' '); Inc (Location); end;

     WriteLn;

     WriteLn ('Substrings occurr ', A^.Occurrence (S), ' times in the string.');

     { Release memory for strings }
     A^.Free; S^.Free;
end.