{$IFNDEF VER60}
{$A+,B+,F-,G+,I-,O+,P+,Q-,R-,S-,T-,V-,X+,Y-}
{$ELSE}
{$A+,B+,F-,G+,I-,O+,R-,S-,V-,X+}
{$ENDIF}
{This acceleration unit is at the moment the best implemented and
 most compatible one. That's because I have myself a S3 Trio64 ;) }
unit gr_s3;

interface
uses gr_vars;

  function   detect_s3 : boolean;
  procedure  bitblit_s3(x1,y1,x2,y2,dstx,dsty : integer);
  procedure  setfillstyle_s3(pattern : word;color : word);
  procedure  bar_s3(x1,y1,x2,y2 : integer);
  procedure  line_s3(x1,y1,x2,y2 : integer);
  {line putting works, but after a while, it becomes very slow - it seems
   to me like a software/hardware bug.. btw it is on my P100 slower than the
   software line putting (if it runs fast ;)}
{  procedure  setwritemode_s3(mode : byte);}
  procedure  cleardevice_s3;
  procedure fillpoly_s3(numpoints : word;var polypoints);
  {only testal - I have no real documentation about it :( }
  procedure scroll_s3(ypos : word);
  var
  setbank_s3 : procedure(bank : word);
{  getbank_s3 : function: word;}
  decbank_s3 : procedure;
  incbank_s3 : procedure;
  setbank2_s3 : procedure(bank : word);

  procedure s3_setcoloretc(foregroundcolor, foregroundmix,
                           backgrcolor,backgrmix,
                           readmask,writemask : word);

  procedure FAST_WRITE_BUFFER_ON;
  procedure enableext_s3;

implementation
const
  (* Std-Register *)
  REG_INDEX = $3d4;
  REG_DATA  = $3d5;
  (* Zeichen-Befehle und Maskenbits *)
  CMD_X = $20;     (* cmd bitcodes *)
  CMD_MAJY = $40;
  CMD_Y = $80;
  CMD_LINE     = $2000;
  CMD_RECTFILL = $4000;
{  CMD_POLYFILL = $8000;}
  CMD_POLYFILL = $3000;
  CMD_BITBLT   = $C000;
  CMD_PATTFILL = $E000;
  (* s3 registers *)
  S3_SUBSYS_STAT = $42e8;
  S3_SUBSYS_CNTL = $42e8;
  S3_ADVFUNC_CNTL = $4ae8;
  S3_CUR_Y = $82e8;
  S3_CUR_X = $86e8;
  S3_DESTY_AXSTP = $8ae8;
  S3_DESTX_DIASTP = $8ee8;
  S3_ERR_TERM = $92e8;
  S3_MAJ_AXIS_PCNT = $96e8;
  S3_GP_STAT = $9ae8;
  S3_CMD = $9ae8;
  S3_SHORT_STROKE = $9ee8;
  S3_BKGD_COLOR = $a2e8;
  S3_FRGD_COLOR = $a6e8;
  S3_WRT_MASK = $aae8;
  S3_RD_MASK = $aee8;
  S3_COLOR_CMP = $b2e8;
  S3_BKGD_MIX = $b6e8;
  S3_FRGD_MIX = $bae8;
  S3_RD_REG_DT = $bee8;
  S3_MIN_AXIS_PCNT = $bee8; (* index 0 *)
  S3_SCISSORS = $bee8; (* index 1..4 = T,L,B,R *)
  S3_PIX_CNTL = $bee8; (* index a *)
  S3_MULT_MISC = $bee8; (* index e *)
  S3_READ_SEL = $bee8; (* index f *)
  S3_PIX_TRANS = $e2e8;
  S3_PIX_TRANS_EXT = $e2ea;
  (* Mix-Register-Befehle fuer BKGD_MIX und FRGD_MIX *)
  MIX_NOTCURRENT = 0;   (* inverser Wert von aktueller Farbe *)
  MIX_ZERO = 1;         (* alles auf 0 setzen *)
  MIX_ONE  = 2;         (* alles auf 1 setzen *)
  MIX_CURRENT = 3;      (* aktueller Wert *)
  MIX_NOTNEW = 4;       (* Inverser Wert von neuer Farbe *)
  MIX_CURXORNEW = 5;    (* aktuelle XOR mit neuer Farbe *)
  MIX_NOTCURXORNEW = 6; (* inverses von aktueller mit XOR der neuen Farbe *)
  MIX_NEW = 7;          (* Neue Farbe *)
  MIX_NOTCURORNOTNEW = 8; (* inv. aktuelle ODER invers neue Farbe *)
  MIX_CURORNOTNEW = 9;  (* aktuelle Farbe ODER invers neue Farbe *)
  MIX_NOTCURORNEW = $a; (* inv. aktuelle Farbe ODER neue Farbe *)
  MIX_CURORNEW = $b;    (* aktuelle Farbe ODER neue Farbe *)
  MIX_CURANDNEW = $c;   (* UND-Verknuepfung aktuelle und neue Farbe *)
  MIX_NOTCURANDNEW = $d;  (* inv. aktuelle UND neue Farbe *)
  MIX_CURANDNOTNEW = $e;(* aktuelle UND inverse neue Farbe *)
  MIX_NOTCURANDNOTNEW = $f; (* inv. aktuelle UND inverse neue Farbe *)
  (* Farb-Quelle *)
  CLRSRC_BACK = 0;  (* Quelle ist das Hintergrund-Farbregister *)
  CLRSRC_FORE = $20;(* Quelle ist das Vordergrund-Farbregister *)
  CLRSRC_CPU = $40; (* Quelle ist das CPU-Register *)
  CLRSRC_VID = $60; (* Quelle ist der Video-Speicher *)
var
  vision : boolean;

procedure Read3D4;assembler;
asm
  mov   dx,3d4h
  out   dx,al
  mov   ah,al
  inc   dx
  in    al,dx
  xchg  ah,al
  dec   dx
end;

procedure Write3D4;assembler;
asm
  mov   dx,3d4h
  out   dx,al
  xchg  ah,al
  inc   dx
  out   dx,al
  xchg  ah,al
  dec   dx
end;

function RegBit(PAddr : word;mask : byte): Boolean;
var old : byte;
begin
  RegBit := true;
  old := port[PAddr];                                { save register    }
  port[PAddr] := old and not mask;                   { reset bits       }
  if port[PAddr] and mask <> 0 then RegBit := false
  else begin
    port[PAddr] := old or mask;                      { set bits         }
    if port[PAddr] and mask <> mask then RegBit := false;
  end;
  port[PAddr] := old;                                { restore register }
end;

procedure getchip;forward;

procedure ExtON;assembler;
asm
  mov   ax,4838h { extensions enable (enable extended registers)}
  call  Write3D4 { write(3d4h, 38h, 48h) }
  mov   ax,0A039h{ extensions enable2    }
  call  Write3D4 { write(3d4h, 39h, a0h) }
end;

procedure ExtOFF;assembler;
asm
  mov   ax,0038h { disable extended registers}
  call  Write3D4 { write(3d4h, 38h, 00h)     }
  mov   ax,0039h { disable2                  }
  call  Write3D4 { write(3d4h, 39h, 00h)     }
end;

function detect_s3 : boolean;
var
  tmp   : byte;
  b     : boolean;
begin
  b := false;
  port[$3D4] := $38;   { Index Lock Register               }
  tmp := port[$3D5];   { save register                     }
  port[$3D5] := $48;   { unlock extended S3-registers      }
  port[$3D4] := $35;   { Index Bank Select Register        }
  if RegBit($3D5,$0F) then begin { Bit 0..3 useable        }
    port[$3D4] := $38; { Index Lock Register               }
    port[$3D5] := 0;   { lock extended S3-registers        }
    port[$3D4] := $35; { Index Bank Select Register        }
    b := not regbit($3D5,$0F);
  end;                 { card is S3, if bits 0..3 are zero }
  port[$3D4] := $38;
  port[$3D5] := tmp;   { restore register                  }
  if b then
    asm
      call  exton
      mov   al,30h
      call  Read3D4
      mov   al,ah
      xor   ah,ah
      mov   card.chipnum,ax
      cmp   al,0E0h
      jnae  @next
        mov   al,2Eh
        call  Read3D4
        mov   byte ptr card.chipnum[1],ah
      @next:
      call  getchip
      call  extoff
  end;
  detect_s3 := b;
end;

{procedure s3_waitfifo(n : byte);assembler;
asm
  mov  ax,256
  mov  cl,n
  shr  ax,cl
  mov  dx,s3_gp_stat
  mov  ah,al
  @lp:
    in   al,dx
    cmp  ah,al
  jna @lp
end;}
procedure s3_waitnorm;far;forward;

const
  s3_waitfifo : procedure = s3_waitnorm;

procedure s3_waitfake;far;
begin
end;

procedure s3_waitnorm;
var
  incer : word;
begin
  incer := 0;
  while (portw[S3_GP_STAT] and 1 <> 0)and(incer < 65535) do inc(incer);
  if incer = 65535 then s3_waitfifo := s3_waitfake;
end;


procedure bitblit_s3(x1,y1,x2,y2,dstx,dsty : integer);
var dx,dy : integer;
    cmd : word;
begin
  if x1 > x2 then swap(x1,x2);
  if y1 > y2 then swap(y1,y2);
  dx := x2 - x1;
  dy := y2 - y1;
  cmd := 0;
  if (dstx < x2) and (dstx > x1) then begin
    x1 := x2;
    dstx := dstx + dx;
  end else begin
    cmd := cmd or CMD_X;
  end;
  if (dsty < y2) and (dsty > y1) then begin
    y1 := y2;
    dsty := dsty + dy;
  end else begin
    cmd := cmd or CMD_Y;
  end;
  s3_waitfifo;
  portw[S3_PIX_CNTL]      := $A000;  (* source = foreground mix *)
  portw[S3_FRGD_MIX]      := CLRSRC_VID or MIX_NEW;  (* code fuer Mischart *)
  portw[S3_CUR_X]         := x1;
  portw[S3_CUR_Y]         := y1;
  portw[S3_DESTX_DIASTP]  := dstx;
  portw[S3_DESTY_AXSTP]   := dsty;
  portw[S3_MAJ_AXIS_PCNT] := dx;
  portw[S3_MIN_AXIS_PCNT] := dy and $fff; (* index 0 *)
  s3_waitfifo;
  portw[S3_CMD]           := cmd or $13 or CMD_BITBLT;
  portw[S3_FRGD_MIX]      := CLRSRC_FORE+MIX_NEW;
  portw[S3_GP_STAT]       := $40F0;{bitmap writing on!}
end;

procedure setwritemode_s3(mode : byte);
begin
  case mode of
    1 : portw[S3_WRT_MASK] := CLRSRC_FORE+MIX_NEW;
    2 : portw[S3_WRT_MASK] := CLRSRC_FORE+MIX_CURXORNEW;
    3 : portw[S3_WRT_MASK] := CLRSRC_FORE+MIX_CURORNEW;
    4 : portw[S3_WRT_MASK] := CLRSRC_FORE+MIX_CURANDNEW;
    5 : portw[S3_WRT_MASK] := CLRSRC_FORE+MIX_CURORNOTNEW;
  end;
  writemode := mode;
end;

procedure s3_setcoloretc(foregroundcolor, foregroundmix,
                         backgrcolor,backgrmix,
                         readmask,writemask : word);
begin
  s3_waitfifo;
  portw[S3_FRGD_COLOR] := foregroundcolor;
  portw[S3_BKGD_COLOR] := backgrcolor;
  portw[S3_WRT_MASK]   := writemask;
  portw[S3_RD_MASK]    := readmask;
  portw[S3_BKGD_MIX]   := backgrmix;
  portw[S3_FRGD_MIX]   := foregroundmix;
  portw[S3_COLOR_CMP]  := 0;
end;

procedure fillpoly_s3(numpoints : word;var polypoints);
{Sorry, cannot get it run - no documentation}
type
  polygon = array[0..8191] of pointtype;
var
  dx,dy,i:integer;
  cmd : word;
  points : polygon absolute polypoints;
begin
  s3_waitfifo;
  portw[S3_FRGD_COLOR] := fillcolor;
  for i := 0 to numpoints-1 do inc(points[i].y,pageadd);

  cmd := CMD_POLYFILL or $13; (* draw + rw + multi pixel *)
  portw[S3_PIX_CNTL] := $A000; (* index a, clear register , fg mix sel *)
  s3_waitfifo;
  portw[S3_CUR_X] := points[0].x;
  portw[S3_CUR_Y] := points[0].y;
  portw[$86EA] := points[1].x;
  portw[$82EA] := points[1].y;
  portw[S3_MAJ_AXIS_PCNT] := points[2].x;
  portw[S3_MIN_AXIS_PCNT] := points[2].y;
  portw[$8EEA] := points[3].x;
  portw[$8AEA] := points[3].y;
  s3_waitfifo;
  portw[S3_CMD] := cmd;
  portw[S3_GP_STAT]       := 1 shl 4;{bitmap writing on!}
end;

procedure putpixel(x,y : integer;color : word);far;assembler;
asm
  db 66h;xor   cx,cx
         mov   bx,x
         mov   cx,bytesperscanline
         cmp   bx,cx
         jnb   @end
         mov   ax,y
  db 66h;mul   cx
         mov   cx,bx
  db 66h;add   ax,cx
         mov   si,ax
  db 66h;shr   ax,16
         cmp   ax,lastbank
         je    @next
         push  ax
         call  setbank2_s3

 @next:  mov   es,[writeptr]
         mov   al,byte ptr color
         cmp   writemode,0
         jne   @doxor
         mov   es:[si],al
         jmp   @end
 @doxor: xor   es:[si],al
 @end:
end;

var
  lastbkcolor,lastcolor : longint;

procedure pattern2screen;
var
  x,y : integer;
begin
  lastbkcolor := bkcolor;
  lastcolor := fillcolor;
  for y := 0 to 7 do
  for x := 0 to 7 do if filloutpattern[fillstylenum,y+1] and (1 shl x) <> 0 then
  putpixel(x,lasty+y,fillcolor) else putpixel(x,lasty+y,bkcolor);
end;

procedure setfillstyle_s3(pattern : word;color : word);
{sets current fillstyle}
begin
  fillcolor := color;
  fillstyle := filloutpattern[pattern];
  fillstylenum := pattern;
  {if pattern > 1 then} pattern2screen;
end;

(*procedure bar_s3(x1,y1,x2,y2 : integer);
var
  dx,dy : integer;
  cmd   : word;
begin
  if x1 > x2 then swap(x1,x2);
  if y1 > y2 then swap(y1,y2);
  if (actviewport.clip)and(((y1 > actviewport.mxy)or(y1 > actviewport.mxy))or
  ((x1 > actviewport.mxx)or(x1 > actviewport.mxx)))
  then exit;
  dx := x2-x1;
  dy := y2-y1;
  if actviewport.clip then begin
    if dy+y1 > actviewport.mxy then dy := actviewport.mxy-y1;
    if dx+x1 > actviewport.mxx then dx := actviewport.mxx-(x1);
  end;
  inc(x1,actviewport.x1);
  inc(x2,actviewport.x1);
  inc(y1,pageadd+actviewport.y1);
  inc(y2,pageadd+actviewport.y1);
  cmd := CMD_Y or cmd_x;
 if fillstylenum < 2 then cmd := cmd or CMD_RECTFILL or $13
 else begin
{   setbank_s3(modeinfoblock.numberofbanks);}
   s3_waitfifo(3);
   portw[S3_MULT_MISC] := $A000;
   portw[S3_FRGD_MIX]  := $67;
   port w[S3_DESTY_AXSTP]  := 0;
   cmd := {cmd or CMD_PATTFILL or $13}$E0B3;
   portw[S3_CUR_X] := 0;
   portw[S3_CUR_Y] := maxy;
 end;
  if bitsperpixel < 24 then begin
    s3_waitfifo(8);
    portw[S3_FRGD_COLOR] := fillcolor;
  end else begin
    s3_waitfifo(4);
    portw[$BEE8] := $E000;
    portw[S3_FRGD_COLOR] := fillcolor;
    portw[$BEE8] := $E010;
    portw[S3_FRGD_COLOR] := fillcolor shr 16;
    s3_waitfifo(7);
  end;
  portw[S3_PIX_CNTL]      := $A000; { index a, clear register , fg mix sel }
  portw[S3_CUR_X]         := x1;
  portw[S3_CUR_Y]         := y1;
  portw[S3_MAJ_AXIS_PCNT] := dx;
  portw[S3_MIN_AXIS_PCNT] := dy and $FFF; { index 0 }
  portw[S3_CMD]           := cmd;
  portw[S3_GP_STAT]       := 1 shl 4;{bitmap writing on!}
end;*)

procedure bar_s3(x1,y1,x2,y2 : integer);
var
  sizex,sizey : integer;
  cmd   : word;
begin
  if y1 > y2 then swap(y1,y2);
  if x1 > x2 then swap(x1,x2);
  inc(x1,actviewport.x1);
  inc(y1,actviewport.y1);
  inc(x2,actviewport.x1);
  inc(y2,actviewport.y1);

  if (y1 > fillviewport.y2) or (y2 < fillviewport.y1) then exit;
  if (x1 > fillviewport.x2) or (x2 < fillviewport.x1) then exit;
  if x1 < fillviewport.x1 then x1 := fillviewport.x1;
  if x2 > fillviewport.x2 then x2 := fillviewport.x2;
  if y1 < fillviewport.y1 then y1 := fillviewport.y1;
  if y2 > fillviewport.y2 then y2 := fillviewport.y2;

  sizex := abs(x2-x1);
  sizey := abs(y2-y1);

  cmd := CMD_Y or cmd_x;

  if (lastbkcolor <> bkcolor)or(lastcolor <> fillcolor) then pattern2screen;
  if fillstylenum < 2 then begin
    if bitsperpixel < 24 then begin
      s3_waitfifo;
      portw[S3_FRGD_COLOR] := fillcolor;
    end else begin
      s3_waitfifo;
      portw[$BEE8] := $E000;
      portw[S3_FRGD_COLOR] := fillcolor;
      portw[$BEE8] := $E010;
      portw[S3_FRGD_COLOR] := fillcolor shr 16;
    end;
    portw[S3_PIX_CNTL]      := $A000; { index a, clear register , fg mix sel }
    portw[S3_CUR_X]         := x1;
    portw[S3_CUR_Y]         := y1+pageadd;
    cmd := cmd or CMD_RECTFILL or $13;
    s3_waitfifo;
  end
  else begin
    s3_waitfifo;
    portw[S3_MULT_MISC] := $A000;
    portw[S3_FRGD_MIX]  := $67;
    portw[S3_DESTY_AXSTP]  := 0;
    cmd := cmd or CMD_PATTFILL or $13;
    portw[S3_CUR_X] := 0;
    portw[S3_CUR_Y] := lasty;
    portw[S3_DESTX_DIASTP]  := x1;
    portw[S3_DESTY_AXSTP]   := y1+pageadd;
    s3_waitfifo;
  end;
  portw[S3_MAJ_AXIS_PCNT] := sizex;
  portw[S3_MIN_AXIS_PCNT] := sizey and $FFF; { index 0 }
  portw[S3_CMD]           := cmd;
  portw[S3_GP_STAT]       := 1 shl 4;{bitmap writing on!}
end;

procedure cleardevice_s3;
var
  oldviewport : viewporttype;
  oldstyle    : word;
begin
  oldviewport := actviewport;
  actviewport.x1 := 0;
  actviewport.y1 := 0;
  actviewport.x2 := mxx;
  actviewport.y2 := mxy;
  actviewport.mxx:= mxx;
  actviewport.mxy:= lasty;
  actviewport.clip := false;
  oldcol    := fillcolor;
  oldstyle  := fillstylenum;
  fillcolor := 0;
  setfillstyle_s3(0,0);
  bar_s3(0,0,mxx,mxy);
  setfillstyle_s3(oldstyle,oldcol);
  actviewport := oldviewport;
end;

procedure line_s3(x1,y1,x2,y2 : integer);
var
 i,dx,dy : integer;
 min,max : integer;
 cmd : word;
begin
  inc(y1,pageadd);
  inc(y2,pageadd);
  if bitsperpixel < 24 then begin
    s3_waitfifo;
    portw[S3_FRGD_COLOR] := currentcolor;
  end else begin
    s3_waitfifo;
    portw[$BEE8] := $E000;
    portw[S3_FRGD_COLOR] := currentcolor;
    portw[$BEE8] := $E010;
    portw[S3_FRGD_COLOR] := currentcolor shr 16;
    s3_waitfifo;
  end;
  dx := abs(x2-x1);
  dy := abs(y2-y1);
  if dx > dy then begin
    max := dx;
    min := dy;
  end else begin
    max := dy;
    min := dx;
  end;
  cmd := 0;
  if y2 > y1 then cmd := cmd or CMD_Y;
  if dy >= dx then cmd := cmd or CMD_MAJY;
  portw[S3_CUR_X] := x1;
  portw[S3_CUR_Y] := y1;
  portw[S3_MAJ_AXIS_PCNT] := max;
  portw[S3_DESTX_DIASTP] := 2 * (min-max);
  portw[S3_DESTY_AXSTP] := 2 * min;
  if (x2 > x1) then begin
    portw[S3_ERR_TERM] := 2 * min - max -1;
    cmd := cmd or CMD_X;
  end else begin
    portw[S3_ERR_TERM] := 2 * min - max;
  end;
  portw[S3_CMD] := cmd or CMD_LINE OR $13;
  portw[S3_GP_STAT] := 1 shl 4;{bitmap writing on!}
end;


procedure scroll_s3(ypos : word);
var
  a    : longint;
  temp : byte;
begin
  a := ypos * longint(bytesperscanline);

  port[$3D4] := $0D;
  port[$3D5] := a shr 2;
  port[$3D4] := $0C;
  port[$3D5] := a shr 10;

  if not vision then begin
    port[$3D4] := $31;
    temp := port[$3D5];
    temp := temp and $CF;
    temp := temp or ((a shr 14) and not $CF);
    port[$3D5] := temp;

    port[$3D4] := $51;
    temp := port[$3D5];
    temp := temp and not 3;
    temp := temp or ((a shr 20) and 3);
    port[$3D5] := temp;
  end else begin
    port[$3D4] := $69;
    port[$3D5] := (a shr 18) and $1F;
  end;
end;

procedure setbank_s3_vision(bank : word);far;assembler;
{set the graphical bank of s3 vision and compatibles}
asm
  cmp   m,0
  je    @end

  mov   ah,byte ptr bank
  cmp   ah,byte ptr lastbank
  je    @end
    mov   dx,3D4h
    mov   al,6Ah
    out   dx,ax
    mov   byte ptr lastbank,ah
  @end:
end;

procedure setbank_s3_std(bank : word);far;assembler;
{set the graphical bank of s3}
asm
  cmp   m,0
  je    @end

  mov   ax,bank
  cmp   ax,lastbank
  je    @end

  mov   lastbank,ax
  mov   ah,al
  mov   dx,3d4h
  mov   al,35h
  mov   bl,ah
  and   ah,$F
  out   dx,ax

  mov   al,51h
  out   dx,al
  inc   dx
  in    al,dx
  and   al,243
  shr   bl,2
  and   bl,1100b
  or    al,bl
  out   dx,al

  @end:
end;


(*function getbank_s3_vision : word;far;assembler;
{get the actual bank for S3 vision and compatibles}
asm
  cmp  m,0
  je   @end
  mov  dx,3D4h
  mov  al,6Ah
  out  dx,al
  inc  dx
  in   al,dx
  xor  ah,ah
  mov  lastbank,ax
  @end:
end;*)

(*function getbank_s3_std : word;far;assembler;
{get the actual bank of S3}
asm
  cmp  m,0
  je   @end

  mov  dx,3d4h
  mov  al,35h
  out  dx,al
  inc  dx
  in   al,dx
  and  al,$F
  mov  ah,al

  mov  al,51h
  out  dx,al
  inc  dx
  in   al,dx
  and  al,1100b
  shl  al,2
  and  ah,al
  mov  al,ah
  xor  ah,ah
  mov  lastbank,ax

  @end:
end;*)

procedure decbank_s3_vision;far;assembler;
{decrease the graphical bank of s3 vision and compatibles}
asm
  push  ax
  push  dx
  mov   ah,byte ptr lastbank
  dec   ah
  mov   dx,3D4h
  mov   al,6Ah
  out   dx,ax
  mov   byte ptr lastbank,ah
  pop   dx
  pop   ax
end;

procedure decbank_s3_std;far;assembler;
{decrease the graphical bank of s3}
asm
  pusha
  mov   dx,3d4h
  mov   al,35h
  mov   ah,byte ptr lastbank
  dec   ah
  mov   byte ptr lastbank,ah
  mov   bl,ah
  and   ah,$F
  out   dx,ax

  mov   al,51h
  out   dx,al
  inc   dx
  in    al,dx
  and   al,243
  shr   bl,2
  and   bl,1100b
  or    al,bl
  out   dx,al
  popa
end;

procedure incbank_s3_vision;far;assembler;
{increase the graphical bank of s3 vision and compatibles}
asm
  push  ax
  push  dx
  mov   ah,byte ptr lastbank
  inc   ah
  mov   dx,3D4h
  mov   al,6Ah
  out   dx,ax
  mov   byte ptr lastbank,ah
  pop   dx
  pop   ax
end;

procedure incbank_s3_std;far;assembler;
{increase the graphical bank of s3}
asm
  pusha
  mov   dx,3d4h
  mov   al,35h
  mov   ah,byte ptr lastbank
  inc   ah
  mov   byte ptr lastbank,ah
  mov   bl,ah
  and   ah,$F
  out   dx,ax

  mov   al,51h
  out   dx,al
  inc   dx
  in    al,dx
  and   al,243
  shr   bl,2
  and   bl,1100b
  or    al,bl
  out   dx,al

  popa
end;

procedure setbank2_s3_vision(bank : word);far;assembler;
{set the actual bank- don't look, if this bank is already setted}
asm
  cmp   m,0
  je    @end

  mov   ah,byte ptr bank
  mov   dx,3D4h
  mov   al,6Ah
  out   dx,ax
  mov   byte ptr lastbank,ah
  @end:
end;

procedure setbank2_s3_std(bank : word);far;assembler;
{set the actual bank- don't look, if this bank is already setted}
asm
  push  cx
  cmp   m,0
  je    @end

  mov   ax,bank
  mov   lastbank,ax

  mov   ah,al
  mov   dx,3d4h
  mov   al,35h
  mov   bl,ah
  and   ah,$F
  out   dx,ax

  mov   al,51h
  out   dx,al
  inc   dx
  in    al,dx
  and   al,243
  shr   bl,2
  and   bl,1100b
  or    al,bl
  out   dx,al

  @end:
  pop   cx
end;


procedure enableext_s3;assembler;
asm
  mov   bl,0ECh
  mov   bh,10h
  mov   cx,000Ah
  call  ExtON   { enable extensions                     }
  mov   al,058h { linear aperture options / bit 2       }
  call  Read3D4 { ah = read(3d4h, 58h)                  }
  and   ah,0ECh { clear bit 0,1 and 4                   }
  call  Write3D4{ write(3d4h, 58h, new AH)              }
  mov   al,59h  { bit 0-1: linear memory address bit 8-9}
  mov   ah,ch
  call  Write3D4{ write(3d4h, 59h, 00h)                 }
  inc   al      { 05Ah : bit 0-7 = linear mem address bit 0-7}
  mov   ah,cl   { in 64k units ???                      }
  call  Write3D4{ write(3d4h, 5Ah, 0Ah)                 }
  mov   al,58h  { linear aperture options               }
  call  Read3D4 { ah = read(3d4h, 58h)                  }
  and   ah,bl   { and ah,ECh -> clear bit 0,1 and 4     }
  or    ah,bh   { or ah,10h (OR or ah,00h) -> set bit 4 }
  or    ah,1 shl 2{enable read ahead cache}
  call  Write3D4{ write(3d4h, 58h, new AH)              }
  mov   al,31h
  call  read3d4
  or    ah,1+8  { Enable Base Address Offset + Access to more than 256 KB}
  call  write3d4
  mov   al,54h
  call  read3d4
  and   ah,not 7
  or    ah,3    {Read Ahead Cache Extra Prefetch Control to 4}
  call  write3d4
  mov   dx,S3_BKGD_MIX
  xor   ax,ax
  out   dx,ax
  mov   dx,S3_FRGD_MIX
  mov   ax,CLRSRC_FORE
  or    ax,MIX_NEW
  out   dx,ax
{  call ExtOFF  { disable extensions                    }
end;

procedure getchip;
var
  s           : string[20];
  upspeedable : boolean;
begin
  vision := false;
  upspeedable := true;
  case lo(card.chipnum) of
      $81 : s := '911';
      $82 : s := '924';
      $90 : s := '928';
 $90..$95 : s := '928';
 $A0..$A8 : s := '801/805';
      $B0 : s := '928PCI';
  $C0,$C1 : begin;s := 'Vision 864';vision := true;end;
  $D0,$D1 : begin;s := 'Vision 964';vision := true;end;
  else case hi(card.chipnum) of{E1h}
        $01 : begin;s := 'VirgeDX/GX 375/385';vision := true;s3_waitfifo := s3_waitfake;upspeedable := false;end;
        $10 : begin;s := 'Trio32 732';vision := true;end;
        $11 : begin;card.speedups.polygon := true;if ((rdinx(seq,$2F)) shr 4) = 5 then s := 'Trio64+ 765' else
              s := 'Trio64 764';vision := true; end;
        $80 : begin;s := 'Vision 866';vision := true; end;
        $90 : begin;s := 'Vision 868';vision := true; end;
$02,$B0,$F0 : begin;s := 'Vision 968';vision := true; end;
        $31 : begin;s := 'Virge 325';vision := true; end;
        $3D : begin;s := 'VirgeVX 988';vision := true; end;
        else s := 'unknown (LO='+makestr(lo(card.chipnum))+';HI='+makestr(hi(card.chipnum))+')';
      end;
  end;
  card.chipname         := s;
  if upspeedable then begin
    card.speedups.bar     := true;
    card.speedups.bitblit := true;
    card.speedups.line    := true;
    card.speedups.cursor  := true;
  end;
  card.speedups.banking := true;
  if vision then begin
    setbank_s3  := setbank_s3_vision;
    setbank2_s3 := setbank2_s3_vision;
    incbank_s3  := incbank_s3_vision;
    decbank_s3  := decbank_s3_vision;
  end else begin
    setbank_s3  := setbank_s3_std;
    setbank2_s3 := setbank2_s3_std;
    incbank_s3  := incbank_s3_std;
    decbank_s3  := decbank_s3_std;
  end;
end;

procedure FAST_WRITE_BUFFER_ON;
begin
  asm
    call  ExtON   { enable extensions                              }
    mov   al,40h  { bit 0: if set enables 8514/A mode              }
    call  Read3D4 {   * 3: (801,805,928) Fast Write Buffer ON *    }
    or    ah,08h  {     6: (801,805,928) Zero Wait State OFF (EISA)}
    call  Write3D4{ set bit 3 to ON                                }
  end;
  extOFF;  { disable extensions                             }
  s3_waitfifo;
  portw[$BEE8]       := $E000;
  portw[S3_WRT_MASK] := 65535;
  portw[S3_RD_MASK]  := 65535;
  if bitsperpixel >= 24 then begin
    portw[$BEE8]       := $E010;
    portw[S3_WRT_MASK] := 65535;
    portw[S3_RD_MASK]  := 65535;
  end;
end;

end.