{$IFNDEF VER60}
{$A+,B+,F-,G+,I-,O+,P+,Q-,R-,S-,T-,V-,X+,Y-}
{$ELSE}
{$A+,B+,F-,G+,I-,O+,R-,S-,V-,X+}
{$ENDIF}
unit gr_vars;
interface
{$IFDEF DPMI}
uses crt,winapi;
{$ELSE}
uses crt;
{$ENDIF}
type

  coltype = record
    r,g,b : byte;
  end;

  PointType = record
    x,y : integer;
  end;

  TextSettingsType = record
    Font      : Word;
    Direction : Word;
    CharSize  : Word;
    Horiz     : Word;
    Vert      : Word;
  end;

  {$IFDEF VER60}
  pchar = ^char;    {for tp 6.0}
  {$ENDIF}
  paltype = array[0..255] of coltype;

  vesainfo = record
    VESASignature: array[0..3] of char;
    VESAVersion : word;
    OEMStringPtr: pchar;
    Capabilities: longint;
    VideoModePtr: Pointer;
    totalmemory : word;
    {beware - this will only be filled if VBE 2 or above is available}
    OemSoftwareRev   : word;
    OemVendorNamePtr : pchar;
    OemProductNamePtr: pchar;
    OemProductRevPtr : pchar;
    reserved    : array[1..222] of byte;
    OemData     : array[1..256] of byte;
  end;

  modeinfo = record
    ModeAttributes     : word;
    WinAAttributes     : byte;
    WinBAttributes     : byte;
    WinGranularity     : word;
    Winsize            : word;
    WinASegment        : word;
    WinBSegment        : word;
    WinFuncPtr         : pointer;
    BytesPerScanLine   : word;
    XResolution        : word;
    YResolution        : word;
    XCharsize          : byte;
    YCharsize          : byte;
    NumberOfPlanes     : byte;
    BitsPerPixel       : byte;
    NumberOfBanks      : byte;
    MemoryModel        : byte;
    BankSize           : byte;
    NumberOfImagePages : byte;
    Reserved1          : byte;
    RedMaskSize        : byte;
    RedFieldPosition   : byte;
    GreenMaskSize      : byte;
    GreenFieldPosition : byte;
    BlueMaskSize       : byte;
    BlueFieldPosition  : byte;
    RsvdMaskSize       : byte;
    RsvdFieldPosition  : byte;
    DirectColorModeInfo: byte;
    {VBE 2 Variables}
    PhysBasePtr        : pointer;
    OffScreenMemOffset : pointer;
    OffScreenMemSize   : word;
    Reserved          : array[1..206] of byte;
  end;

  ViewPortType = record
    x1,y1,x2,y2 : integer;
    mxx,mxy     : word;
    clip        : boolean;
  end;

  FillPatternType = array [1..8] of byte;

  {$IFOPT N+}
  fpu = single;
  {$ELSE}
  fpu = real;
  {$ENDIF}
var
  mxx,mxy,maxx,maxy,m: integer;
  s                : string  ;
  gfx_inited       : boolean ; { True if graphical mode active }
  actviewport,actscreen,fillviewport : viewporttype;{current viewport-settings }
  gresult          : integer ; { contains last error - 0 after call of graphresult }
  winfuncptr       : pointer ; { Bankswitchpointer - used in Realmode}
  bitsperpixel     : byte    ;
  bytesperpixel    : byte    ;
  bytesperscanline : word    ;
  shifter          : byte    ; { Used for setbank }
  writeptr,readptr : word    ; { where the graphical data is written/readen }
  vesainfoblock    : vesainfo;
  modeinfoblock    : modeinfo;
  twowins          : boolean ; { True if 2 bank-windows used }
  card : record
    chipid      : string[20];{ Like 'S3','ATI' if unknown, then 'VESA'}
    chipname    : string[25];{ has included the name of the chip }
    chipnum     : word;   { Chip Version number }
    fastid      : byte;   { Has included the number for constants like S3}
    ioadr       : word;
    speedup     : boolean;{ use normal speedups like setbank, scroll }
    speedupfunc : boolean;{ use full hardware acceleration           }
    speedupmode : byte;
    upspeeded   : boolean;{ filled after initialization - card uses then HW-Acceleration}
    upspeedable : boolean;
    speedups : record     { which acceleration the card does support }
      bar,bitblit,line,cursor,polygon,banking,scale : boolean;
    end;
  end;
  stylecounter     : word;
  getted           : boolean; { True after call of gettext - for puttext }
  load             : word;
  screen           : pointer;
  cpos : record
    x,y : integer;
  end;
  lasty            : word; {last line available in gfxmem}

const
  bitblit_memsize : word = 32000; {Memory to use for soft-bitblit - changeable}
  maxcolors   = 255;
  lastbank    : word = 65535;
  pageadd     : word = 0;
  numofpages  : byte = 0;
  currentcolor: longint = 15;
  fillcolor   : longint = 15;
  bkcolor     : byte = 0;
  writemode   : byte = 0;
  on  = true;
  off = false;

  currentsize : byte = 1;
  font        : byte = 0;
  linestyle   : word = $FFFF;
  linestylenum: word = 0;
  fillstyle   : fillpatterntype = ($FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF);
  fillstylenum: word = 1;
  pr          : boolean = true; {try to wait for cathod-beam after setvisualpage? }

  VESA   = 0;
  S3     = 1;
  TSENG  = 2;
  CIRRUS = 3;
  ATI    = 4;

 filloutpattern : array[0..12] of FillPatternType = (
   ($00,$00,$00,$00,$00,$00,$00,$00),     { Backgroundcolor }
   ($FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF),     { Foregroundcolor }
   ($ff,$ff,$00,$00,$ff,$ff,$00,$00),     { === }
   ($01,$02,$04,$08,$10,$20,$40,$80),     { /// }
   ($07,$0e,$1c,$38,$70,$e0,$c1,$83),     { /// als dicke Linien }
   ($07,$83,$c1,$e0,$70,$38,$1c,$0e),     { \\\ als dicke Linien }
   ($5a,$2d,$96,$4b,$a5,$d2,$69,$b4),     { \ \\ \ }
   ($ff,$88,$88,$88,$ff,$88,$88,$88),     { Kstchen }
   ($18,$24,$42,$81,$81,$42,$24,$18),     { Rauten }
   ($cc,$33,$cc,$33,$cc,$33,$cc,$33),     { "Mauermuster" }
   ($80,$00,$08,$00,$80,$00,$08,$00),     { wide dots }
   ($88,$00,$22,$00,$88,$00,$22,$00),     { close dots }
   (0,0,0,0,0,0,0,0));

 linepattern : array[0..3] of word =
   ($FFFF,$CCCC,$FC78,$F8F8);

type
  chartype = array[0..255] of record
    numofpoints : byte;
    pointpos : array[0..15] of record
      x,y      : byte;
      stopline : boolean;
      reserved : byte;
    end;
  end;
  PaletteType = record
    Size    : Byte;
    Colors  : array[0..MaxColors] of Shortint;
  end;

var
  header : array[0..7] of record
    kennung               : string[11];
    version               : word;
    name                  : string[20];
    charsize,height,width : byte;
    chartype              : byte;{1= Vektor;2= Bitmap;3=8 Bit bitmap}
    colordepth            : byte;
    startchar,endchar     : word;
    distance              : byte;
    memsize               : word;
    reserved              : array[0..16] of byte;
  end;


  fontinfo : array[0..7] of record
    memsize   : word;
    fromdisk  : boolean;
    available : boolean;
  end;
  chars  : array[0..7] of pointer;
  charpoints : ^chartype;

  point  : array[0..499] of word;{radius of a circle cannot be larger than 500 points}
  oldcol : byte;

const
  ATTR = $3C0;
  SEQ  = $3C4;
  GRC  = $3CE;
  coproav : boolean = false;

  textx : word = 0{lefttext};
  texty : word = 2{toptext};
var
  pal : ^paltype;
{$IFDEF DPMI}
{Ripped from BGIDEMO.PAS}
type
 TRealRegs = record
   RealEDI: Longint;
   RealESI: Longint;
   RealEBP: Longint;
   Reserved: Longint;
   RealEBX: Longint;
   RealEDX: Longint;
   RealECX: Longint;
   RealEAX: Longint;
   RealFlags: Word;
   RealES: Word;
   RealDS: Word;
   RealFS: Word;
   RealGS: Word;
   RealIP: Word;
   RealCS: Word;
   RealSP: Word;
   RealSS: Word;
 end;
var
  Segment,Selector : Word;
{$ENDIF}
  procedure puttext;
  procedure gettext;
  function  getlasty : word;
  function  getmaxx : word;
  function  getmaxy : word;
  procedure move2(var input,output;size : word);
  procedure sprite2mem(var input,output;size : word;key : byte);
{  procedure moveQ(var input,output;size : word);}
  procedure move2screen(var input,output;size : word);
  procedure movefromscreen(var input,output;size : word);
  procedure FillDWord(var dest; Times : word;data : byte);
  procedure fillpattern(var output;size : word;value1,value2 : byte;xpos,pattern : byte);
  function  loadfont(name : string;num : byte) : boolean;
  function  closefont(num : byte) : boolean;
  function  loadfontmem(p : pointer;num : byte) : boolean;
  function  makestr(w : longint) : String;
  function  makestrr(r : real;sh,st : byte) : String;

  procedure swap(var i1,i2 : integer);
  function  GetRMSelector(segment : word) : word;
  procedure modinx(pt,inx,mask,nwv:word);
  procedure clrinx(pt,inx,val:word);
  procedure wrinx3(pt,inx:word;val:longint);
  procedure wrinx2(pt,inx,val:word);
  procedure setinx(pt,inx,val:word);
  function  tstrg(pt,msk:word):boolean;
  function  rdinx(pt,inx:word):word;
  procedure wrinx(pt,inx,val:word);       {write VAL to register PT index INX}
  function  testinx2(pt,rg,msk:word):boolean;
  function  testinx(pt,rg:word):boolean;

  procedure getvesainfo;

implementation

procedure gettext;
{get and save the text screen}
begin
 if not getted then begin
   cpos.x := wherex;
   cpos.y := wherey;
   if lastmode = 3+font8x8 then load := 80*50*4 else load := 80*25*2;
   getmem(screen,load);
   move2(ptr(getrmselector($B800),0)^,screen^,load);
   getted := true;
 end;
end;

procedure puttext;
{put the saved text screen}
begin
  if getted then begin
 {   if lastmode = 3+font8x8 then load := 80*50*4 else load := 80*25*2;}
    move2(screen^,ptr(getrmselector($B800),0)^,load);
    gotoxy(cpos.x,cpos.y);
    freemem(screen,load);
    getted := false;
  end;
end;

function getlasty : word;assembler;
{get the last accessable y-line of the card}
asm
  mov  ax,lasty
end;

function getmaxx : word;assembler;
{only for compatibility}
asm
  mov  ax,mxx
end;

function getmaxy : word;assembler;
{only for compatibility}
asm
  mov  ax,mxy
end;

function loadfont(name : string;num : byte) : boolean;
{load font from disk}
var
  f       : file;
  i       : word;
  size    : byte;
  memsize : word;
begin
  loadfont := false;
  assign(f,name);
  filemode := 64;
  {$I-}reset(f,1);{$I+}
  if ioresult <> 0 then begin
    gresult := 8{grFontNotFound};
    exit;
  end;
  blockread(f,header[num],sizeof(header[num]));
  if header[num].kennung = 'GSCharset>>' then begin
    if header[num].chartype = 1 then begin
      new(charpoints);
      for i := header[num].startchar to header[num].endchar do begin
       {if eof(f) then begin;close(f);exit;end;}
        blockread(f,size,1);
        charpoints^[i].numofpoints := size;
        blockread(f,charpoints^[i].pointpos,size*4);
      end;
    end else if header[num].chartype = 2 then begin
      memsize:=(header[num].width*header[num].height*header[num].colordepth)div 8
               *(header[num].endchar-header[num].startchar+1);
      getmem(chars[num],memsize);
      blockread(f,chars[num]^,memsize);{muss noch veraendert werden, um variabel zu sein}
    end else if header[num].chartype = 3 then begin
      memsize:= header[num].memsize;
      getmem(chars[num],memsize);
      blockread(f,chars[num]^,memsize);
    end;
  end else begin
    close(f);
    gresult := 13{grInvalidFont};
    exit;
  end;
  close(f);
  fontinfo[num].fromdisk  := true;
  fontinfo[num].available := true;
  fontinfo[num].memsize   := memsize;
  loadfont := true;
end;

function closefont(num : byte) : boolean;
{unload a font}
begin
  closefont := false;
  if not fontinfo[num].available then exit;
  if fontinfo[num].fromdisk then
  if (header[num].chartype = 2)or(header[num].chartype = 3) then
  freemem(chars[num],fontinfo[num].memsize);
  fontinfo[num].available := false;
  fontinfo[num].fromdisk  := false;
  fontinfo[num].memsize   := 0;
  closefont := true;
end;


function loadfontmem(p : pointer;num : byte) : boolean;
{load font from memory}
var
  i       : word;
  size    : byte;
  ppos    : word;
  memsize : word;
begin
  ppos := 0;
  loadfontmem := false;
  move2(p^,header[num],sizeof(header[num]));
  inc(ppos,sizeof(header[num]));
  if header[num].kennung = 'GSCharset>>' then begin
    if header[num].chartype = 1 then begin
      new(charpoints);
      for i := header[num].startchar to header[num].endchar do begin
        move(ptr(seg(p^),ofs(p^)+ppos)^,size,1);
        inc(ppos);
        charpoints^[i].numofpoints := size;
        move2(ptr(seg(p^),ofs(p^)+ppos)^,charpoints^[i].pointpos,size*4);
        inc(ppos,size*4);
      end;
    end else if header[num].chartype = 2 then
    chars[num] := ptr(seg(p^),ofs(p^)+ppos)
    else if header[num].chartype = 3 then
    chars[num] := ptr(seg(p^),ofs(p^)+ppos);
  end else begin
    gresult := 13{grInvalidFont};
    exit;
  end;
  fontinfo[num].fromdisk  := false;
  fontinfo[num].available := true;
  fontinfo[num].memsize   := memsize;
  loadfontmem := true;
end;

function makestr(w : longint) : string;
{convert integer to string}
var
  c : string;
begin
  str(w,c);
  makestr := c;
end;

function makestrr(r : real;sh,st : byte) : string;
{convert real to string}
var
  c : string;
begin
  str(r:sh:st,c);
  makestrr := c;
end;

(*
procedure moveQ(var input,output;size : word);assembler;
{uses fpu - makes memory movements a bit more faster
(39 MB/s instead of 33 MB/s on my P90 in normal mem but
not to gfx-mem :( )}
asm
 cld
 {$IFOPT E+}
 push ds
 cmp coproav,0
 jne @av
   call move2
 jmp @end
 @av:
 lds  si,input
 les  di,output
 mov  cx,size
 mov  ax,cx
 shr  cx,4
 jz   @not16
 @lp:
   fild qword ptr ds:[si]
   fild qword ptr ds:[si+8]
   fxch
   fistp qword ptr es:[di]
   fistp qword ptr es:[di+8]

   add si,16
   add di,16
   dec cx
 jnz @lp
 @not16:
 mov  cx,ax
 and  cx,1111b
 mov  ax,cx
 shr  cx,2
 db   0F3h,66h,0A5h{rep movsd}
 mov  cx,ax
 and  cx,11b
 jz   @end
 @no4:
 rep  movsb
 @end:
 pop  ds
 {$ELSE}
 call move2
 {$ENDIF}
end;*)

procedure move2(var input,output;size : word);assembler;
{use it instead of the normal move.. size is to set in bytes}
asm
  cld
  mov   dx,ds
  lds   si,input
  les   di,output
  mov   cx,size
  mov   ax,cx
  shr   cx,2
  jz    @not4
  db    0F3h,66h,0A5h{rep movsd}
  @not4:
  mov   cx,ax
  and   cx,11b
  jz    @end
  rep   movsb
  @end:
  mov   ds,dx
end;

procedure move2screen(var input,output;size : word);assembler;
{optimized for 32-Bit address output}
asm
  cld
  mov   dx,ds
  lds   si,input
  les   di,output
  mov   cx,size
  mov   ax,cx
  cmp   cx,8
  jb    @start
  mov   cx,di
  and   cx,11b
  jz    @iszero
  mov   bx,4
  sub   bx,cx
  mov   cx,bx
  rep   movsb
  sub   ax,bx
  @iszero:
  mov   cx,ax
  @start:
  shr   cx,2
  jz    @end
  db    0F3h,66h,0A5h{rep movsd}
  mov   cx,ax
  and   cx,11b
  jz    @end
  rep   movsb
  @end:
  mov   ds,dx
end;

procedure movefromscreen(var input,output;size : word);assembler;
{optimized for 32-Bit address input (PCI-Bus)}
asm
  cld
  mov   dx,ds
  lds   si,input
  les   di,output
  mov   cx,size
  mov   ax,cx
  cmp   cx,8
  jb    @start
  mov   cx,si
  and   cx,11b
  jz    @iszero
  mov   bx,4
  sub   bx,cx
  mov   cx,bx
  rep   movsb
  sub   ax,bx
  @iszero:
  mov   cx,ax
  @start:
    shr   cx,2
    jz    @end
    db    0F3h,66h,0A5h{rep movsd}
    mov   cx,ax
    and   cx,11b
    jz    @end
    rep   movsb
  @end:
  mov   ds,dx
end;


procedure FillDWord(var dest; Times : word;data : byte);assembler;
{Runs like fillchar but with dwords.. you have to set the times
 to fill in bytes. Optimized for maximum screen-output (32-Bit PCI)}
asm
  cld
  mov   al,data
  mov   ah,al
  mov   dx,ax
  db    66h;shl ax,16
  mov   ax,dx
  les   di,dest
  mov   cx,times
  or    cx,cx
  jz    @end
  mov   dx,cx
  cmp   cx,8
  jb    @start
  mov   cx,di
  and   cx,11b
  jz    @iszero
  mov   bx,4
  sub   bx,cx
  mov   cx,bx
  rep   stosb
  sub   dx,bx
  @iszero:
  mov   cx,dx
  @start:
    shr   cx,2
    db    0F3h,66h,0ABh{rep stosd}
    mov   cx,dx
    and   cx,11b
    jz    @end
    mov   al,data
    rep   stosb
  @end:
end;

procedure fillpattern(var output;size : word;value1,value2 : byte;xpos,pattern : byte);assembler;
asm
  mov   cl,xpos
  and   cl,7
  mov   al,1
  shl   al,cl
  les   di,output
  mov   si,size
  or    si,si
  jz    @end
  mov   ah,pattern
  mov   dl,value1
  mov   dh,value2
  @lp:

    test  ah,al
    jz    @usebk
      mov   es:[di],dl
      jmp   @normcol
    @usebk:
      mov   es:[di],dh
    @normcol:
    add   al,al
    jz    @reset
    @cont1:
    inc   di
    dec   si
  jnz   @lp
  jmp   @end
  @reset:
  mov   al,1
  jmp   @cont1
  @end:
end;

procedure sprite2mem(var input,output;size : word;key : byte);assembler;
{key is the transparent color}
asm
  push  ds
  les   di,input
  lds   si,output
  mov   cx,size
  or    cx,cx
  jz    @end
  mov   dx,cx
  or    cx,cx
  shr   cx,1
  jz    @end
  mov   bl,key
  @lp:
    mov   ax,es:[di]
    cmp   al,bl
    je    @black;mov ds:[si],al;@black:
    cmp   ah,bl
    je    @black2;mov ds:[si+1],ah;@black2:

    add   di,2
    add   si,2
    dec   cx
  jnz   @lp
  and   dx,1
  jz    @end
  mov   al,es:[di]
  cmp   al,bl
  je    @black3;mov ds:[si],al;@black3:

  @end:
  pop   ds
end;

procedure swap(var i1,i2 : integer);assembler;
asm
  mov   dx,ds
  les   di,i1
  lds   si,i2
  mov   ax,es:[di]
  mov   bx,ds:[si]
  mov   ds:[si],ax
  mov   es:[di],bx
  mov   ds,dx
end;


function GetRMSelector(segment : word) : word;assembler;
asm
{$ifdef dpmi}
  mov   ax,2
  mov   bx,segment
  int   31h
{$else}
  mov   ax,segment
{$endif}
end;

function rdinx(pt,inx:word):word;       {read register PT index INX}
var x:word;
begin
  if pt = $3C0 then
  begin
    x := port[seq+6];    {Reset Attribute Data/Address Flip-Flop}
    port[$3C0] := inx and $DF;    {Clear bit 5 of index}
    for x := 1 to 10 do;
    rdinx := port[$3C1];    {delay}
    x := port[seq+6];    {Reset Attribute Data/Address Flip-Flop}
    for x := 1 to 10 do;   {delay}
    port[$3C0] := $20;    {Set index bit 5 to keep display alive}
    x := port[seq+6];    {Reset Attribute Data/Address Flip-Flop}
  end
  else begin
    port[pt] := inx;
    rdinx := port[pt+1];
  end;
end;

procedure wrinx(pt,inx,val:word);       {write VAL to register PT index INX}
var x : word;
begin
  if pt = $3C0 then
  begin
    x := port[seq+6];
    port[$3C0] := inx and $DF;
    port[$3C0] := val;
    x := port[seq+6];    {If Attribute Register then reset Flip-Flop}
    port[$3C0] := $20;
    x := port[seq+6];
  end
  else begin
    port[pt] := inx;
    port[pt+1] := val;
  end;
end;

procedure wrinx2(pt,inx,val:word);
begin
  wrinx(pt,inx,lo(val));
  wrinx(pt,inx+1,hi(val));
end;

procedure wrinx3(pt,inx:word;val:longint);
begin
  wrinx(pt,inx,lo(val));
  wrinx(pt,inx+1,hi(val));
  wrinx(pt,inx+2,val shr 16);
end;

procedure wrinx2m(pt,inx,val:word); {Write VAL to the index pair (INX,INX+1)}
begin                               {in motorola (big endian) format}
  wrinx(pt,inx,hi(val));
  wrinx(pt,inx+1,lo(val));
end;

procedure wrinx3m(pt,inx:word;val:longint);
begin
  wrinx(pt,inx+2,lo(val));
  wrinx(pt,inx+1,hi(val));
  wrinx(pt,inx,val shr 16);
end;

procedure modinx(pt,inx,mask,nwv:word);  {In register PT index INX sets
                                          the bits in MASK as in NWV
                                          the other are left unchanged}
var temp:word;
begin
  temp:=(rdinx(pt,inx) and (not mask))+(nwv and mask);
  wrinx(pt,inx,temp);
end;

procedure modreg(reg,mask,nwv:word);  {In register REG sets the bits in
                                       MASK as in NWV other are left unchanged}
var temp:word;
begin
  temp:=(port[reg] and (not mask))+(nwv and mask);
  port[reg] := temp;
end;


procedure setinx(pt,inx,val:word);
var x:word;
begin
  x:=rdinx(pt,inx);
  wrinx(pt,inx,x or val);
end;

procedure clrinx(pt,inx,val:word);
var x:word;
begin
  x:=rdinx(pt,inx);
  wrinx(pt,inx,x and (not val));
end;

function tstrg(pt,msk:word):boolean;
var
  old,nw1,nw2:word;
begin
  old := port[pt];
  port[pt] := old and not msk;
  nw1 := port[pt] and msk;
  port[pt] := old or msk;
  nw2 := port[pt] and msk;
  port[pt] := old;
  tstrg := (nw1 = 0)and(nw2 = msk);
end;

function testinx2(pt,rg,msk:word):boolean;
var
  old,nw1,nw2:word;
begin
  old := rdinx(pt,rg);
  wrinx(pt,rg,old and not msk);
  nw1 := rdinx(pt,rg) and msk;
  wrinx(pt,rg,old or msk);
  nw2 := rdinx(pt,rg) and msk;
  wrinx(pt,rg,old);
  testinx2:=(nw1=0) and (nw2=msk);
end;

function testinx(pt,rg:word):boolean;
begin
  testinx := testinx2(pt,rg,$ff);
end;

var
  oldexitproc : pointer;

procedure newexitproc;far;
begin
  dispose(pal);
  exitproc := oldexitproc;
end;

{$IFDEF DPMI}

procedure GetVesaInfo;
begin
  asm
    push  0000h
    push  0200h
    call  globaldosalloc
    mov   segment,dx
    mov   selector,ax
    mov   di,offset RealModeRegs
    mov   word ptr [DI].TRealRegs.RealSP, 0
    mov   word ptr [DI].TRealRegs.RealSS, 0
    mov   word ptr [DI].TRealRegs.RealEAX, 4F00h
    mov   word ptr [DI].TRealRegs.RealES, dx
    mov   word ptr [DI].TRealRegs.RealEDI, 0
    mov   ax,ds
    mov   es,ax
    mov   ax,0300h
    mov   bx,0010h
    int   31h
  end;
  move2(ptr(selector,0)^,vesainfoblock,512);
  globaldosfree(selector);
end;

{$ELSE}
procedure getvesainfo;assembler;
asm
  mov   ax,4F00h
  mov   di,seg vesainfoblock
  mov   es,di
  mov   di,offset vesainfoblock
  int   10h
end;
{$ENDIF}

procedure sysfont2;external;
{$L SYSFONT2}
procedure littn2;external;
{$L LITTN2}
begin
  new(pal);
  if (not loadfontmem(@LITTN2,2))or(not loadfontmem(@SYSFONT2,0)) then
  begin
    writeln('GRAFX: An error occured while loading standard fonts from memory');
    writeln('Program aborted');
    exit;
  end;
  coproav := test8087 <> 0;
  oldexitproc := exitproc;
  exitproc    := @newexitproc;
end.

