{ VIDDEMO.PAS : Displays textfile on video display monitor page by page

  title   : VIDDEMO
  version : 1.1
  date    : Feb 20, 1997
  author  : J R Ferguson
  language: Borland Pascal v7.0
  usage   : refer procedure Help
  remarks : Demo program for VidLib unit.
}

{$V-}
{$R+}

program VIDDEMO;


uses DefLib, ArgLib, StpLib, ChrLib, VidLib, ConLib;


const
  MAXFNM    = 79;     { Max filespec length (integrated environment) }
  INPBUFSIZ = 4096;   { Input buffer size in bytes }

  { Error codes and messages: }
  ERROK     = 0;
  ERRARG    = 1;
  ERRFNF    = 2;
  ERRREA    = 3;

  ERRMSG    : array[ERRFNF..ERRREA] of StpTyp =
 ('File not found',
  'Read error'
 );

type
  InpBufTyp = array[1..INPBUFSIZ] of char; InpBufPtr = ^InpBufTyp;

var
  ErrCod    : integer;
  InpFnm    : StpTyp;
  Inp       : Text;
  InpBuf    : InpBufPtr;
  InpOpn    : boolean;
  break     : boolean;

{
--- General routines ---
}


procedure Help;
  procedure wr(s: StpTyp);  begin write  (s) end;
  procedure wl(s: StpTyp);  begin writeln(s) end;
begin
wl('VIDDEMO v1.0 - Displays textfile on video display monitor page by page');
wl('Usage  : VIDDEMO filespec');
wl('');
wl('Remarks : Demo program for VidLib unit.');
end;



{
--- Command line parsing routines ---
}



procedure ReadOpt(var arg: StpTyp);
var nextopt: boolean;
begin
  StpDel(arg,1,1);
  repeat
    if StpEmpty(arg) or (StpcRet(arg,1) = '/') then ErrCod:= ERRARG
    else begin
      nextopt:= false;
      while (ErrCod=ERROK) and not nextopt and not StpEmpty(arg) do
      case StpcGet(arg) of
        '?',
        'H': ErrCod:= ERRARG;
        '/': nextopt:= true;
        else ErrCod:= ERRARG;
      end;
    end;
  until (ErrCod <> ERROK) or not nextopt;
end;


procedure ReadArgs;
var i   : ArgInd;
    arg : StpTyp;
begin
  GetArgs; i:= 0;
  while (ErrCod = ERROK) and (i < ArgC) do begin
    Inc(i); StpCpy(arg,ArgV[i]); StpUpp(arg);
    case StpcRet(arg,1) of
      '/' : ReadOpt(arg);
      '<' : ErrCod:= ERRARG;
      '>' : ErrCod:= ERRARG;
      else  StpNCpy(InpFnm,arg,MAXFNM);
    end;
  end;
  if StpEmpty(InpFnm) then ErrCod:= ERRARG;
end;



{
--- Low-level I/O routines ---
}


procedure OpenInp;
begin
  Assign(Inp,InpFnm); new(InpBuf); SetTextBuf(Inp,InpBuf^);
  {$I-} reset(Inp); {$I+}
  if IOresult <> 0 then ErrCod:= ERRFNF else InpOpn:= true;
end;


procedure CloseInp;
begin
  dispose(InpBuf);
  {$I-} Close(Inp); {$I+}
  if IOresult = 0 then InpOpn:= false;
end;


procedure ReadInp(var line: StpTyp);
begin
  {$I-} readln(Inp,line); {$I+}
  if IOresult <> 0 then ErrCod:= ERRREA;
end;



{
--- Main line ---
}


procedure OutInit;
begin
  VidSnow(false);
  VidSetAttr($1F);
  VidClrScr;
end;


procedure OutPage;
var c: char; row,col: byte;
begin
  VidSetAttr($70);
  VidDspStp('CR:'); VidClrEol;
  VidGetPos(row,col);
  SetCur(succ(row),succ(col));
  repeat c:= Key until (c = #13) or (c=#3);
  break:= c=#3;
  if not break then begin
    VidSetAttr($1F);
    VidClrScr;
  end;
end;


procedure OutLine(line: StpTyp);
begin
  StpTrunc(line,80);
  VidDspStp(line);
  VidDspStp(#13#10);
end;


procedure OutTerm;
var c: char; row,col: byte;
begin
  if not break then begin
    VidSetAttr($70);
    VidDspStp('<EOF>'); VidClrEos;
    VidGetPos(row,col);
    SetCur(succ(row),succ(col));
    c:= Key;
  end;
  VidClrScrAttr($07);
  SetCur(1,1);
end;


procedure MainProcess;
var Line: StpTyp; LineCnt: byte;
begin
  OutInit;
  LineCnt:= 0;
  break:= false;
  while (ErrCod = ERROK) and not eof(Inp) and not break do begin
    ReadInp(Line);
    if ErrCod = ERROK then begin
      if LineCnt = 24 then begin OutPage; LineCnt:= 0; end;
      Inc(LineCnt);
      if not break then OutLine(line);
    end;
  end;
  OutTerm;
end;


procedure MainInit;
begin
  ErrCod:= ERROK;
  StpCreate(InpFnm); InpOpn:= false;
  ReadArgs;
  if ErrCod = ERROK then OpenInp;
end;


procedure MainExit;
begin
  if InpOpn then CloseInp;
  if ErrCod <> ERROK then begin
    if (ErrCod=ERRARG) then Help
    else writeln('VIDDEMO: ',ERRMSG[ErrCod]);
  end;
end;


begin { Main program }
  MainInit;
  if ErrCod = ERROK then MainProcess;
  MainExit;
end.
