{ ARGLIB.PAS : Command line argument handling library

  Title   : ARGLIB
  Version : 3.3
  Date    : Nov 08,1996
  Language: Turbo Pascal v4.0+
  Author  : J.R. Ferguson
  Usage   : Unit
}

UNIT ArgLib;

INTERFACE
uses ChrLib, Dos;

const
  MaxCmd   = 127; { Maximum number of characters in a command argument }
  MaxArg   = 10 ; { Maximum number of command arguments recognized }

type
  ArgInd   = 0..MaxArg;
  CmdInd   = 0..MaxCmd;
  CmdStp   = string[MaxCmd];

var
  ArgC     : ArgInd;                  { Actual number of command args }
  ArgV     : array[ArgInd] of CmdStp; { Actual command argument values }


procedure GetArgs;
{ Copy the command arguments into the ArgV array and set the value of ArgC.
  This procedure is executed automatically at program start. }


function NextArg(var arg: CmdStp): boolean;
{ Indicates if there is another command argument. If so, its value is
  copied into the arg parameter, otherwise arg will be made empty.
  Repeated execution of this function will iterate over subsequent command
  arguments.
  Procedure GetArgs must have been executed previously. }



IMPLEMENTATION

var
  ArgI   : ArgInd;

procedure GetArgs;
const
  Null   = #0;
  GetPSP = $62;
  ArgOfs = $0080;
var
  CPU    : Registers;
  arg    : CmdStp; ArgL: CmdInd absolute arg;
  cmd    : CmdStp; CmdL: CmdInd absolute cmd;
  i      : CmdInd;
  c      : char;
  Quote  : char;

  procedure GetCmd(var cmd: CmdStp);
  begin with CPU do begin
    AH:= GetPSP; MsDos(CPU); Move(Mem[BX:ArgOfs],cmd,SizeOf(cmd));
  end end;

  function HasArg: boolean;

    function NxtChr(var c: char): char;
    begin
      if i >= CmdL then c:= Null
      else begin inc(i); c:= cmd[i] end;
      NxtChr:= c;
    end;

  begin { HasArg }
    if ArgC >= MaxArg then HasArg:= false
    else begin
      arg:= '';
      while IsSpace(NxtChr(c)) do ;
      if (c='"') or (c='''') then begin
        Quote:= c;
        if NxtChr(c) = Null then arg:= Quote
        else while (c <> Null) and (c <> Quote) do begin  { quoted arg }
          if ArgL < MaxCmd then arg:= arg + c;
          c:= NxtChr(c);
        end;
      end
      else while (c <> Null) and not IsSpace(c) do begin  { unquoted arg }
        if ArgL < MaxCmd then arg:= arg + c;
        c:= NxtChr(c);
      end;
      HasArg:= ArgL>0
    end;
  end;

begin { GetArgs }
  GetCmd(cmd); if CmdL > MaxCmd then CmdL:= MaxCmd;
  for ArgC:= 1 to MaxArg do ArgV[ArgC]:= '';
  ArgC:= 0; i:= 0; ArgV[0]:= '';
  while HasArg do begin inc(ArgC); ArgV[ArgC]:= arg end;
  ArgI:= 0;
end;


function NextArg(var arg: CmdStp): boolean;
begin
  if ArgI < ArgC then begin
  Inc(ArgI);
    arg:= ArgV[ArgI]; NextArg:= true;
  end
  else begin
    arg:= ''; NextArg:= false;
  end;
end;


BEGIN { Initialization }
  GetArgs
END.
