{ DIRLIB.PAS : File Control Block handling library

  Title   : DIRLIB
  Version : 4.0
  Date    : Nov 09,1996
  Language: Turbo Pascal v4.0 through 7.0 (DOS real or protected mode)
  Author  : J.R. Ferguson
  Usage   : Unit

  Remarks:
  This library uses the old-fashioned File Control Block format to
  store directory information. Therefore it does not support DOS
  directory paths.
}

UNIT DirLib;

INTERFACE
uses DefLib, Dos;

const DirMaxFcb = 36;

type
  DirFcbTyp  = record case integer of               { File Control Block }
                 1:( byt: packed array[0..DirMaxFcb] of byte );
                 2:( kar: packed array[0..DirMaxFcb] of char );
                 3:( drn: byte; {0 = current drive, 1 = A:, 2 = B:, etc. }
                     fnm: packed array[1..8] of char;
                     ext: packed array[1..3] of char; )
               end;

  DirPtr     = ^DirEntry;           { Directory list pointer }
  DirEntry   = record               { Directory list entry }
                 fcb: DirFcbTyp; 
                 nxt: DirPtr 
               end;


procedure DirMakeFcb(fsp: StpTyp; var fcb: DirFcbTyp);
{ Convert file specification fsp to file control block fcb.
  Supports wildcards * and ?, but no subdirectories or paths.

  If fsp is not a valid file specification, an empty fcb is returned.
  This condition can be recognized by the test fcb.fnm[1]=' '.
 
  See also: <DirMakeFsp>
}

procedure DirMakeFsp(fcb: DirFcbTyp; var fsp: StpTyp);
{ Convert file control block fcb to file specification fsp.
  The fsp is returned in a free format string, i.e. the file name and
  extension do not have a fixed length and the drive letter and the 
  extension may be omitted.

  See also: <DirMakeFcb>
}

procedure DirCreate(var dir: DirPtr);
{ Create a new, empty directory list dir.

  See also: <DirScan>, <DirClear>
}

procedure DirClear(var dir: DirPtr);
{ Remove the directory list dir, after removing any fcb entries it
  may contain.

  See also: <DirCreate>, <DirScan>
}

function  DirEmpty(var dir: DirPtr): boolean;
{ Test if directory list dir is empty. }

procedure DirInsert(var dir: DirPtr; fcb: DirFcbTyp);
{ Insert file control block fcb into the alphabetically ordered
  directory list dir, if it is no duplicate. }

procedure DirRetrieve(var dir: DirPtr; var fcb: DirFcbTyp);
{ Retrieve the first control block from directory list dir and
  return it in the parameter fcb. }

procedure DirScan(var dir: DirPtr; mask: DirFcbTyp);
{ Read the disk directory and insert the fcb's matching the given
  fcb mask into directory list, maintaining an alphabetical ordering.
  The mask may contain wildcard characters * and ? in the fnm and ext 
  fields. The drn field must be filled with 0 for the current drive,
  1 for A:, 2 for B:, etcetera. Only the current directory of the
  drive specified in the drn field of the fcb mask is scanned.

  The directory list must have been created using procedure DirCreate
  before procedure DirScan is executed. Procedure DirScan may be executed
  several times using different fcb masks. Matching directory entries are 
  merged maintaining an alphabetic ordering without duplicates.
  
  See also: <DirCreate>, <DirClear>
}


IMPLEMENTATION

procedure DosCall(func: byte; var CPU: Registers);
begin CPU.AH:= func; MsDos(CPU); end;

procedure DirMakeFcb(fsp: StpTyp; var fcb: DirFcbTyp);
const parse= $29; NULL: char=#0;
var   CPU: Registers; tmp: array[1..44] of char;
begin with CPU do begin
  fsp:=fsp+NULL;
  DS:=Seg(fsp[1]); SI:=Ofs(fsp[1]); AL:=0;
  ES:=Seg(tmp); DI:=Ofs(tmp); DosCall(parse,CPU);
  if CPU.AL = $FF then begin
    fcb.drn:= 0;
    FillChar(fcb.fnm,8,' ');
    FillChar(fcb.ext,3,' ');
  end
  else move(tmp,fcb,SizeOf(DirFcbTyp));
end end;

procedure DirMakeFsp(fcb: DirFcbTyp; var fsp: StpTyp);
  procedure AddField(i,n: integer);
  begin with fcb do while (n>0) and (kar[i]<>' ') do begin
    fsp:=fsp+kar[i]; i:=succ(i); n:=pred(n);
  end; end;
begin with fcb do begin { DirMakeFsp }
  if drn=0 then fsp:='' else fsp:=chr(drn+64)+':';
  AddField(1,8);
  if ext[1]<>' ' then begin fsp:=fsp+'.'; AddField(9,3) end;
end; end;

procedure DirCreate(var dir: DirPtr);
begin new(dir); dir^.nxt:=dir; end;

procedure DirClear(var dir: DirPtr);
var fcb: DirFcbTyp;
begin 
  while not DirEmpty(dir) do DirRetrieve(dir,fcb);
  dispose(dir) ;
end;

function DirEmpty(var dir: DirPtr): boolean;
begin DirEmpty:=dir^.nxt=dir end;

procedure DirInsert(var dir: DirPtr; fcb: DirFcbTyp);
var p0,p1: DirPtr;
begin
  dir^.fcb:=fcb; p0:=dir;
  while p0^.nxt^.fcb.kar < fcb.kar do p0:=p0^.nxt;
  if (p0^.nxt^.fcb.kar <> fcb.kar) or (p0^.nxt = dir) then begin
    new(p1); p1^.fcb:=fcb; p1^.nxt:=p0^.nxt;
    p0^.nxt:= p1;
  end;
end;

procedure DirRetrieve(var dir: DirPtr; var fcb: DirFcbTyp);
var p: DirPtr;
begin 
  p:= dir^.nxt; fcb:= p^.fcb; dir^.nxt:= p^.nxt; 
  if p^.nxt <> p then dispose(p);
end;

procedure DirScan(var dir: DirPtr; mask: DirFcbTyp);
const SearchFirst=$11; SearchNext=$12; GetDTA=$2F; SetDTA=$1A;
var Buffer: record case boolean of
              false: (byt: array[0..127] of byte);
              true : (fcb: DirFcbTyp)
            end;
    CPU   : Registers;
    DTA   : record hi,lo: word; end;
begin with CPU do begin
  DosCall(GetDTA,CPU); DTA.hi:=ES; DTA.lo:=BX;
  DS:=Seg(Buffer); DX:=Ofs(Buffer); DosCall(SetDTA,CPU);
  DS:=Seg(mask); DX:=Ofs(mask); DosCall(SearchFirst,CPU);
  while AL<>$FF do begin
    DirInsert(dir,Buffer.fcb);
    DS:=Seg(mask); DX:=Ofs(mask); DosCall(SearchNext,CPU);
  end;
  DS:=DTA.hi; DX:=DTA.lo; DosCall(SetDTA,CPU);
end; end;

END.
