{ SCKLIB.PAS  String Check function library

  Title   : SCKLIB
  Version : 4.0
  Date    : Nov 14,1996
  Author  : J R Ferguson
  Language: Borland Turbo Pascal 4.0 through 7.0 (all targets)
  Usage   : Unit
}

UNIT SckLib;

INTERFACE
uses DefLib, ChrLib;


function StpIsAlpha(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only alphabetic
  characters ('A'..'Z','a'..'z'). }

function StpIsDigit(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only digits ('0'..'9'). }

function StpIsAlnum(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only alfanumeric
  characters ('A'..'Z', 'a'..'z', '0'..'9'). }

function StpIsAscii(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only ASCII characters
  (ordinal value 0..127). }

function StpIsCntrl(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only control-characters
  (ordinal value 0..31 or 127). }

function StpIsPrint(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only printable
  characters (ordinal value 32..126). }

function StpIsGraph(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only (visible) graphic
  characters (ordinal value 33..126). }

function StpIsLower(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only lower case letters
  ('a'..'z'). }

function StpIsUpper(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only upper case letters
  ('A'..'Z'). }

function StpIsPunct(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only puctuation characters
  (printable characters that are not alphanumeric). }

function StpIsSpace(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only 'white space'
  character (space, horizontal tab, vertical tab, carriage return,
  line feed and form feed). Ordinal values 9..12 and 32. }

function StpIsBDigit(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only binary digits
  ('0','1'). }

function StpIsQDigit(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only octal digits
  ('0'..'7'). }

function StpIsXDigit(s: StpTyp): boolean;
{ Returns true if string s is empty or contains only hexadecimal digits
  ('0'..'9', 'A'..'F', 'a'..'f'). }

function StpIsPict(p,s: StpTyp): boolean;
{ Returns true if string matches picture p. This means the following
  conditions must be met:
   1. String p and string s contain the same number of characters.
   2. The characters below have a special meaning in picture p:
        'A' : upper case letter
        'a' : lower case letter
        '9' : decimal digit
        'B' : binary digit
        'H' : hexadecimal digit
        'Q' : octal digit
        'X' : alphanumeric character
        '@' : printable character
      Where one of those characters is found in picture p, the character
      on that position in string s must match this character class.
   3. Where a character other than one of the special characters listed in
      condition 2 is found in pattern p, the character on that position in
      string s must be the same.
  If at least one of these conditions is not met, the function result is
  false. }


IMPLEMENTATION

function StpIsAlpha(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsAlpha(s[i]); end;
  StpIsAlpha:= ok
end;

function StpIsDigit(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsDigit(s[i]) end;
  StpIsDigit:= ok
end;

function StpIsAlnum(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsAlnum(s[i]) end;
  StpIsAlnum:= ok
end;

function StpIsAscii(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsAscii(s[i]) end;
  StpIsAscii:= ok
end;

function StpIsCntrl(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsCntrl(s[i]) end;
  StpIsCntrl:= ok
end;

function StpIsPrint(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsPrint(s[i]) end;
  StpIsPrint:= ok
end;

function StpIsGraph(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsGraph(s[i]) end;
  StpIsGraph:= ok
end;

function StpIsLower(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsLower(s[i]) end;
  StpIsLower:= ok
end;

function StpIsUpper(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsUpper(s[i]) end;
  StpIsUpper:= ok
end;

function StpIsPunct(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsPunct(s[i]) end;
  StpIsPunct:= ok
end;

function StpIsSpace(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsSpace(s[i]) end;
  StpIsSpace:= ok
end;

function StpIsBDigit(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsBDigit(s[i]) end;
  StpIsBDigit:= ok
end;

function StpIsQDigit(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsQDigit(s[i]) end;
  StpIsQDigit:= ok
end;

function StpIsXDigit(s: StpTyp): boolean;
var i: StpInd; l: StpInd absolute s; ok: boolean;
begin
  i:= 0; ok:= true;
  while ok and (i<l) do begin inc(i); ok:= IsXDigit(s[i]) end;
  StpIsXDigit:= ok
end;

function StpIsPict(p,s: StpTyp): boolean;
var i : StpInd;
    lp: StpInd absolute p;
    ls: StpInd absolute s;
    ok: boolean;
begin
  if ls <> lp then StpIsPict:= false
  else begin
    i:= 0; ok:= true;
    while ok and (i<ls) do begin
      inc(i);
      case p[i] of
        'A': ok:= IsUpper(s[i]);
        'a': ok:= IsLower(s[i]);
        '9': ok:= IsDigit(s[i]);
        'X': ok:= IsAlnum(s[i]);
        '@': ok:= IsPrint(s[i]);
        'B': ok:= IsBDigit(s[i]);
        'Q': ok:= IsQDigit(s[i]);
        'H': ok:= IsXDigit(s[i]);
        else ok:= s[i]=p[i];
      end
    end;
    StpIsPict:= ok
  end
end;

END.
