{--------------------------------------------------------------------|
|   TMonTest   | Test for Task_monitor unit.                         |
|--------------'                                                     |
| Author: Gautier.deMontmollin@Maths.UniNe.CH        v. 15 VII 1997  |
|--------------------------------------------------------------------}

{$X+}            
uses Task_monitor, Objects, Drivers, Menus, Views, MsgBox, App;
const cmNewWin = 101;
      cmIdle   = 102;            { issued when TV is Idle }
type
  TMyApp = object(TApplication)
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitStatusLine; virtual;
    procedure Idle; virtual;
  end;

procedure TMyApp.HandleEvent(var Event: TEvent);
begin
  TApplication.HandleEvent(Event);
  if Event.What = evCommand then if Event.Command= cmNewWin then begin
    if Task_manager_installed then
      DeskTop^.Insert(New(P_task_mon_View, Init(cmIdle)))
    else
      MessageBox('No task manager', NIL, mfError);
    ClearEvent(Event)
  end
end;

procedure TMyApp.InitStatusLine;
var R: TRect;
begin
  GetExtent(R); R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~Alt-X~ Quit', kbAltX, cmQuit,
      NewStatusKey('~F4~ New', kbF4, cmNewWin,
      nil)),
    nil)
  ))
end;

PROCEDURE TMyApp.Idle;
BEGIN
  TApplication.Idle; {..:=} Message(DeskTop, evBroadcast, cmIdle, nil)
end;

var MyApp: TMyApp; begin MyApp.Init; MyApp.Run; MyApp.Done end.
