'
' LOGIN.BAS (12/18/97)
'
' Dials up the MarshallSoft BBS (205-880-9748) and logs on.
'
'  To run from the VB IDE, type:
'
'       VBDOS /LPCL4VB.QLB LOGIN.BAS
'
'$INCLUDE: 'PCL4VB.BI'
'$INCLUDE: 'MODEM_IO.BI'
'$INCLUDE: 'DEFINES.BI'


 DECLARE FUNCTION MyExit(BYVAL Port AS INTEGER) AS INTEGER

 DECLARE FUNCTION PutGet(BYVAL Port   AS INTEGER, _
                               Send   AS STRING,  _
                         BYVAL Pace   AS INTEGER, _
                               Expect AS STRING,  _
                         BYVAL Tics   AS INTEGER) AS INTEGER

 FALSE = 0
 TRUE  = NOT FALSE
 CTLZ    = 26
 ONE_SEC = 18

 RxBuf512$ = STRING$(512+16,0)   'must be 1st string statement
 TxBuf512$ = STRING$(512+16,0)   'must be 2nd string statement

 'declare variables
 DIM Port           AS INTEGER
 DIM I              AS INTEGER
 DIM L              AS INTEGER
 DIM Code           AS INTEGER
 DIM LibVer         AS INTEGER
 DIM BaudCode       AS INTEGER
 DIM Pace           AS INTEGER
 DIM AnyKey         AS STRING
 DIM RATES(9)       AS STRING
 DIM PARMS          AS STRING
 DIM ARG1           AS STRING
 DIM ARG2           AS STRING

 Pace = 4

 RATES$(1) = "300"
 RATES$(2) = "1200"
 RATES$(3) = "2400"
 RATES$(4) = "4800"
 RATES$(5) = "9600"
 RATES$(6) = "19200"
 RATES$(7) = "38400"
 RATES$(8) = "57600"
 RATES$(9) = "115200"

 'get command line arguments
 PARMS$ = RTRIM$(COMMAND$)
 I = INSTR(PARMS$, " ")
 IF I < 1 THEN
   PRINT "  Usage: LOGIN <Port> <BaudRate>"
   PRINT "Example: LOGIN 1 9600"
   END 1
 END IF

 L = LEN(PARMS$)
 ARG1$ = LEFT$(PARMS$, I - 1)
 ARG2$ = LTRIM$(RIGHT$(PARMS$, L - I))
 BaudCode = -1

 'Get COM port
 Port = VAL(ARG1$) - 1

 'Get baud code
 FOR I = 1 TO 9
   IF RATES$(I) = ARG2$ THEN
      BaudCode = I
      EXIT FOR
   END IF
 NEXT I

 'Verify good baud rate
 IF BaudCode = -1 THEN
   PRINT "Cannot recognize baud rate "; ARG2$
   END
 END IF

'setup RX buffer
 RxBufSeg = (1+SSEG(RxBuf512$)) + (SADD(RxBuf512$) \ 16)

 Code = SioRxBuf(Port, RxBufSeg, Size512)
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioRxBuf()"
   Code = SioError(Code)
   END
 END IF

 IF SioInfo(ASC("I")) <> 0 THEN
   'setup TX buffer
   TxBufSeg = (1+SSEG(TxBuf512$)) + (SADD(TxBuf512$) \ 16)
   Code = SioTxBuf(Port, TxBufSeg, Size512)
   IF Code < 0 THEN
     PRINT "Error "; Code; " returned from SioTxBuf()"
     Code = SioError(Code)
     STOP
   END IF
 END IF

 'reset port
 Code = SioReset(Port, BaudCode)
 CLS
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioReset()"
   Code = SioError(Code)
   END
 END IF

 PRINT "Login 12/18/97"
 PRINT " "
 LibVer = SioInfo(ASC("V"))
 PRINT "Library Version: "; LTRIM$(STR$(LibVer \ 16)); ".";
 PRINT LTRIM$(STR$(LibVer MOD 16))

 Code = SioDTR(Port, SET_LINE)
 Code = SioRTS(Port, SET_LINE)
 Code = SioFIFO(Port, LEVEL_4TH)

 IF AT_COMMAND_SET THEN
   PRINT "ready"
 ELSE
   PRINT "AT_COMMAND_SET must be 1. See DEFINES.BI"
   STOP
 END IF

 'send "AT" to modem & expect "OK" back
 IF PutGet(Port, "!AT!", 5, "OK", 180) = 0 THEN
   Code = MyExit(Port)
 END IF

 'initialize modem & expect "OK" back
 IF PutGet(Port, "AT E1 S7=60 S11=60 V1 X1 Q0 S0=0!", 5, "OK", 90) = 0 THEN
   Code = MyExit(Port)
 END IF

 ' log onto MarshallSoft BBS as GUEST

 Code = PutGet(Port,"!ATDT1,205,880,9748!",Pace,"CONNECT",45*ONE_SEC)
 IF Code <> 0 THEN Code = PutGet(Port,"!",Pace,"graphics (y/N)?|LAST name:",30*ONE_SEC)
 IF Code = ASC("0") THEN Code = PutGet(Port,"!",Pace,"LAST name:",10*ONE_SEC)
 IF Code <> 0 THEN Code = PutGet(Port,"GUEST GUEST!",Pace,"password:",10*ONE_SEC)
 IF Code <> 0 THEN Code = PutGet(Port,"GUEST!",Pace,"",10*ONE_SEC)

 'send CR to get prompt
 Code = SioPutc(Port,13)
 PRINT "Entering TERMINAL loop (^Z to quit)..."
 DO
   'Anything incoming ?
   Code = SioGetc(Port, 1)
   IF Code = 13 THEN
     PRINT
   ELSEIF Code >= &H20 THEN
     PRINT CHR$(Code);
   END IF
   'Anything to send ?
   AnyKey$ = INKEY$
   IF AnyKey$ <> "" THEN
     'Exit if user types Control-Z
     IF AnyKey$ = CHR$(26) THEN EXIT DO
     Code = SioPutc(Port,ASC(AnyKey$))
   END IF
 LOOP
 PRINT "User typed Control-Z..."
 Code = MyExit(Port)

 END

 FUNCTION PutGet(BYVAL Port   AS INTEGER, _
                       Send   AS STRING,  _
                 BYVAL Pace   AS INTEGER, _
                       Expect AS STRING,  _
                 BYVAL Tics   AS INTEGER) AS INTEGER

   DIM RC AS INTEGER

   PRINT "*** Sending '";Send;"'";
   IF Expect <> "" THEN
     PRINT " & awaiting '";Expect;"'";
   END IF
   PRINT

   RC = ModemSendTo(Port, Pace, Send)
   PutGet = RC
   IF RC = 0 THEN
     EXIT FUNCTION
   END IF

   IF Expect <> "" THEN
     RC = ModemWaitFor(Port, Tics, FALSE, Expect)
     IF RC = 0 THEN
       PRINT Expect; " not received"
       PutGet = 0
     ELSE
       PRINT
       PutGet = RC
     END IF
   END IF

END FUNCTION

FUNCTION MyExit(BYVAL Port AS INTEGER) AS INTEGER

   DIM Code AS INTEGER

   Code = SioDone(Port)

END FUNCTION

END


 