#include <math.h>
#include <stdio.h>

#define PI (double)3.14159265358979324
#define R_LN10 (double)0.43429448190325182765
#define LOG(x) (log(x)*R_LN10)
#define MINUTE (PI/10800.)
#define EXP_FACTOR (1e5)
#define PERMINUTE  1        /* substitute 5 for 0.2 degree increments */
#define TOTAL (5400*PERMINUTE)
#define COL 5
#define ROW 60
#define MINPERDEG 60
#define PAGE (TOTAL / (ROW * COL) )
#define SEQUENCE(r,c,p)  ( ( (ROW*COL)*(p) ) + (r) + (ROW * (c) ) )
#define SECONDS(r,c,p)  ( ( (p / PERMINUTE) * 18000L)    +             \
			  (c * 3600L)            +                     \
			  ( (p % PERMINUTE) * 720L )     +             \
			  (r * 12L * (5/PERMINUTE) ) )

write_number( char *buf, double number )
{
   long int inumber;

   inumber = (long int)( (EXP_FACTOR * number) + 0.5 );

   sprintf( buf, "%6ld", inumber );
}

write_angle( char *buf, double angle, int part )
{
   long int minutes;

   minutes = (long int)( (angle * (1.0/MINUTE) ) + 0.5);
   if      ( part == 0 )
   {
      sprintf( buf,
	 "%3ld\xF8 %2ld'", minutes / MINPERDEG, minutes % MINPERDEG );
   }
   else if ( part == 1 )
   {
      sprintf( buf, "%3ld\xF8", minutes / MINPERDEG );
   }
   else
   {
      sprintf( buf, "%2ld'", minutes % MINPERDEG );
   } /* ENDIF */
}

main( )
{
   long int row, col, page, anglecounter;
   double angle, sec_angle, csc_angle;
   char buf[80];
   FILE *outfile;

#if (PERMINUTE-1)
   outfile = fopen( "ho211a.dat", "w" );
#else
   outfile = fopen( "ho211.dat", "w" );
#endif

   fprintf( outfile,
      "\n\n\n\n\n\n\n\n\n                              H.O. 211 TABLE\n"
      "           A = log cosecant( angle )    B = log secant( angle )\n"
      "                  (values scaled by 100,000 then rounded)\n\n"
      "                  Use left minutes for top degrees,\n"
      "                  right minutes for bottom degrees\n\f" );
#if (PERMINUTE-1)
   printf( "Working on H.O. 211 Tables\n"
	   "Results in file HO211A.DAT\n" );
#else
   printf( "Working on H.O. 211 Tables\n"
	   "Results in file HO211.DAT\n" );
#endif

   for ( page = 0; page < PAGE; page++ )
   {
      printf( "Doing page %2ld of %2d\n", (page+1), (TOTAL/(ROW*COL) ) );
      fprintf( outfile, "        \xB3" );
      for ( col = 0; col < COL; col++ )
      {
	 anglecounter = SECONDS( 0, col, page );
	 fprintf( outfile,
	 "     %3ld\xF8    \xB3", anglecounter / 3600 );
      } /* ENDFOR */
      fprintf( outfile, "\n" );

      fprintf( outfile, "        \xB3" );
      for ( col = 0; col < COL; col++ )
      {
	 fprintf( outfile,
	       "     A      B\xB3" );
      } /* ENDFOR */
      fprintf( outfile, "\n" );

      fprintf( outfile, "   \xC4\xC4\xC4\xC4\xC4\xC5" );

      for ( col = 0; col < COL; col++ )
      {
	 fprintf( outfile,
       "\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC5" );
      } /* ENDFOR */
      fprintf( outfile, "\xC4\xC4\xC4\xC4\xC4\n" );

      for ( row = 0; row < ROW; row++ )
      {
	 anglecounter = SECONDS( row, 0, page );
	 anglecounter %= 3600;
	 fprintf( outfile, "   %2ld'.%1ld\xB3",
		  anglecounter / 60, (anglecounter % 60) / 6);

	 for ( col = 0; col < COL; col++ )
	 {
	    angle = (double)SECONDS( row, col, page );
	    angle *= (PI / (double)(180L*60*60) );
	    sec_angle = 1.0 / cos( angle );
	    sec_angle = LOG( sec_angle );
	    if ( angle == 0 )
	    {
	       csc_angle = 9.99999;
	    }
	    else
	    {
	       csc_angle = 1.0 / sin( angle );
	       csc_angle = LOG( csc_angle );
	    } /* ENDIF */
	    write_number( buf, csc_angle );
	    fprintf( outfile, "%s ", buf );
	    write_number( buf, sec_angle );
	    fprintf( outfile, "%s\xB3", buf );
	 } /* ENDFOR */
	 anglecounter = SECONDS( row, 0, page );
	 anglecounter %= 3600;
	 anglecounter = 3600 - anglecounter;
/*	 fprintf( outfile, "%2d'\n", MINPERDEG - row );*/
	 fprintf( outfile, "%2ld'.%1ld\n",
		  anglecounter / 60, (anglecounter % 60) / 6);
      } /* ENDFOR */

      fprintf( outfile, "   \xC4\xC4\xC4\xC4\xC4\xC5" );
      for ( col = 0; col < COL; col++ )
      {
	 fprintf( outfile,
       "\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC5" );
      } /* ENDFOR */
      fprintf( outfile, "\xC4\xC4\xC4\xC4\xC4\n" );

      fprintf( outfile, "        \xB3" );
      for ( col = 0; col < COL; col++ )
      {
/*	 fprintf( outfile,
	       "     %3ld\xF8    \xB3",
		179 - (SEQUENCE( 0, col, page ) / MINPERDEG ) );*/
	 anglecounter = ( (180L*3600L) -1) - SECONDS( 0, col, page );
	 fprintf( outfile,
	 "     %3ld\xF8    \xB3", anglecounter / 3600 );
      } /* ENDFOR */
      fprintf( outfile, "\n" );

#if 0
      fprintf( outfile, "   \xB3" );
      for ( col = 0; col < COL; col++ )
      {
	 fprintf( outfile,
	       "     A      B\xB3" );
      } /* ENDFOR */
      fprintf( outfile, "\n" );
#endif

      fprintf( outfile, "\f" );
   } /* ENDFOR */
}