UNIT AE0 ;

{$R-}
{$B-}
{$I-}
{$S+}
{$V-}

{-----------------------------------------------------------------------------}
{ This unit contains the definitions of all constants, types                  }
{ and global variables                                                        }
{-----------------------------------------------------------------------------}

INTERFACE

USES Crt, Dos ;

CONST MaxNrOfWorkspaces = 3 ;     { maximum number of workspaces }
      WsBufSize         = 65534 ; { maximum size of workspace buffer }
      PasteBufSize      = 16384 ; { maximum size of paste buffer }
      MaxMacroLength    = 100 ;   { maximum number of keystrokes in a macro }
      NrOfMacros        = 10 ;    { number of macros }
      MacroStackDepth   = 10 ;    { maximum size of macro stack }
      PosStackDepth     = 10 ;    { maximum size of position stack }
      Inactive          = 0 ;     { generally used value }
      NrOfCursorTypes   = 4 ;     { number of cursor available types }
      UnderLineCursor   = 1 ;     { cursor type }
      HalfBlockCursor   = 2 ;     { cursor type }
      BlockCursor       = 3 ;     { cursor type }
      NoBlinkCursor     = 4 ;     { cursor type }
      NrOfColorSettings = 9 ;     { size of ScreenColorArray }
      LinesOnScreen     = 25 ;    { number of lines on a screen }
      NrOfTextLines     = 24 ;    { = LinesOnScreen - 1 }
      ColsOnScreen      = 80 ;    { number of columns on a screen }
      CharsOnScreen     = 2000 ;  { number of characters on a screen (25*80) }
      BkspKey           = 264 ;   { keynumber of Backspace key }
      TabKey            = 265 ;   { keynumber of Tab key }
      CtrlReturnKey     = 266 ;   { keynumber of Control-Return key }
      ReturnKey         = 269 ;   { keynumber of Return (= Enter) key }
      EscapeKey         = 283 ;   { keynumber of Escape key }
      TAB               = #9  ;   { tab character (ASCII value 9 }
      LF                = #10 ;   { line feed character (ASCII value 10) }
      FF                = #12 ;   { form feed character (ASCII value 12) }
      CR                = #13 ;   { carriage return character (ASCII value 13) }
      EF                = #26 ;   { end-of-file character (ASCII value 26) }
      ESC               = #27 ;   { escape character (ASCII value 27) }
      ConfigFilename    = 'AE.CFG' ; { name of file containing setup settings }
      Find              = 1 ;     { used to indicate search type }
      FindAndReplace    = 2 ;     { used to indicate search type }
      MaxFileListLength = 100 ;   { maximum number of files that can be in }
                                  { a file list }
      MaxHistLength     = 10 ;    { maximum number of lines in a history }
      WorkFilename      = 'AE.WRK' ; { name of file with saved workspace }
      UpCompatSetupVersion = '1.63' ; { earliest setup verion that is upward
                                        compatible with current version }
      UpCompatWorkVersion = '1.61' ; { same for work file }


TYPE Position       = RECORD Index       : WORD ;
                             Linenr      : WORD ;
                             Colnr       : WORD ;
                             END ;
                      { a position within a workspace buffer is stored in two }
                      { ways: an index for the array (of type WsBuftype) and }
                      { a line number plus column number }
     WsBuftype      = ARRAY [1..WsBufSize] OF CHAR ;
     WsBufPtr       = ^WsBuftype ;
     Workspacetype  = RECORD
                         Name             : PathStr ;
                         ChangesMade      : BOOLEAN ;
                         LastTimeSaved    : ARRAY [1..4] OF WORD ;
                                            { hrs,mins,secs,1/100 secs }
                         CurPos           : Position ;
                                            { current position }
                         MARK             : WORD ;
                                            { index of block mark }
                         FirstVisibleLine : Position ;
                                            { points to start of first line }
                                            { that is shown on screen }
                         FirstScreenCol   : WORD ;
                         VirtualColnr     : WORD ;
                                            { column nr that CurPos should }
                                            { be on when moving through    }
                                            { buffer vertivally            }
                         Buffer           : WsBufPtr ;
                         BufferSize       : WORD ;
                                            { number of chars in buffer }
                         PosStack         : ARRAY [1..PosStackDepth] OF WORD;
                                            { position stack }
                         PosStackPointer  : BYTE ;
                             END ;
     PasteBuftype   = ARRAY [1..PasteBufSize] OF CHAR ;
     SetupBlock     = RECORD Banner          : STRING [12] ;
                             Version         : STRING [4] ;
                             CursorType      : BYTE ;
                             Keyclick        : BOOLEAN ;
                             ScreenColors    : BYTE ;
                             FastRedraw      : BOOLEAN ;
                             SoundBell       : BOOLEAN ;
                             PageLength      : WORD ;
                             LeftMargin      : WORD ;
                             TopMargin       : WORD ;
                             PrintPageNrs    : BOOLEAN ;
                             WordWrapLength  : WORD ;
                             AutoWrap        : BOOLEAN ;
                             TabSpacing      : WORD ;
                             AutoIndent      : BOOLEAN ;
                             DotsForSpaces   : BOOLEAN ;
                             InsertMode      : BOOLEAN ;
                             SaveOnExit      : BOOLEAN ;
                             SaveInterval    : WORD ;
                             MakeBAKfile     : BOOLEAN ;
                             SaveWork        : BOOLEAN ;
                             END ;
     MacroBlock        = RECORD Contents      : ARRAY [1..NrOfMacros,
                                                       1..MaxMacroLength]
                                                       OF WORD ;
                                LENGTH        : ARRAY [1..NrOfMacros] OF WORD ;
                                END ;
     ConfigBlock       = RECORD Setup : SetupBlock ;
                                Macro : MacroBlock ;
                                END ;
     MacroStackElement = RECORD Macronr : BYTE ;
                                Index   : BYTE ;
                                END ;
     { the following types are defined because most information is written }
     { directly into video memory }
     ScreenArray    = ARRAY [1..LinesOnScreen, 1..ColsOnScreen] OF WORD ;
     ScreenPtr      = ^ScreenArray ;
     ScreenBlock    = ARRAY [1..CharsOnScreen] OF WORD ;
     ScreenBlockPtr = ^ScreenBlock ;
     ScreenElement  = RECORD Contents  : CHAR ;
                             Attribute : BYTE ;
                             END ;
     ScreenElementPtr = RECORD
                             CASE BYTE OF
                                  0 : (Ref : ^ScreenElement) ;
                                  1 : (OFS, SEG : WORD) ;
                             END ;
     ColorSetting   = RECORD NormAttr         : BYTE ;
                             BlockAttr        : BYTE ;
                             StatusAttr       : BYTE ;
                             CursorAttr       : BYTE ;
                             StatusCursorAttr : BYTE ;
                             END ;
                      { contains the attributes used on the screen: }
                      { NormAttr for normal characters, }
                      { BlockAttr for characters within the selected block, }
                      { StatusAttr for characters on the status line, }
                      { CursorAttr for the non-blinking block cursor, }
                      { StatusCursorAttr for same within status line }
     FilenameStr    = STRING [12] ;
                      { contains the name of a file plus extension }
     stringptr      = ^STRING ;
     History        = RECORD MaxLineLen : BYTE ;
                                          { max length of lines in history }
                             Len        : BYTE ;
                                          { current number of lines }
                             LINE       : ARRAY [1..MaxHistLength]
                                               OF stringptr ;
                             CurLine    : BYTE ;
                                          { current line }
                             END ;
     HistPtr        = ^History ;
     WorkBlock      = RECORD Banner           : STRING [12] ;
                             Version          : STRING [4] ;
                             NrOfWorkSpaces   : BYTE ;
                             CurrentWsnr      : BYTE ;
                             FileName         : ARRAY [1..MaxNrOfWorkspaces]
                                                  OF PathStr ;
                             CursorPos        : ARRAY [1..MaxNrOfWorkspaces]
                                                 OF Position ;
                             FirstVisibleLine : ARRAY [1..MaxNrOfWorkspaces]
                                                 OF Position ;
                             FirstScreenCol   : ARRAY [1..MaxNrOfWorkspaces]
                                                 OF WORD ;
                             END ;


CONST DefaultSetup : { default setup, used if no setup file is found }
                     { in the current directory }
                     SetupBlock = (
                            Banner          : ConfigFilename ;
                            Version         : '1.00' ;
                            CursorType      : UnderLineCursor ;
                            Keyclick        : FALSE ;
                            ScreenColors    : 3 ;
                            FastRedraw      : FALSE ;
                            SoundBell       : TRUE ;
                            PageLength      : Inactive ;
                            LeftMargin      : 0 ;
                            TopMargin       : 0 ;
                            PrintPageNrs    : FALSE ;
                            WordWrapLength  : Inactive ;
                            AutoWrap        : FALSE ;
                            TabSpacing      : 0 ;
                            AutoIndent      : TRUE ;
                            DotsForSpaces   : FALSE ;
                            InsertMode      : TRUE ;
                            SaveOnExit      : FALSE ;
                            SaveInterval    : Inactive ;
                            MakeBAKfile     : FALSE ;
                            SaveWork        : FALSE ) ;
      ScreenColorArray : { contains the screen color settings that can be }
                         { chosen from. Only the first two are available }
                         { for monochrome video adapters }
                         ARRAY [1..NrOfColorSettings] OF ColorSetting =
                           {1} ( (NormAttr : LightGray + Black * 16 ;
                                 BlockAttr : Black + LightGray * 16 ;
                                 StatusAttr : White + Black * 16 ;
                                 CursorAttr : Black + LightGray * 16 ;
                                 StatusCursorAttr : Black + LightGray * 16) ,
                           {2}  (NormAttr : LightGray + Black * 16 ;
                                 BlockAttr : Black + LightGray * 16 ;
                                 StatusAttr : Black + LightGray * 16 ;
                                 CursorAttr : Black + LightGray * 16 ;
                                 StatusCursorAttr : LightGray + Black * 16) ,
                           {3}  (NormAttr : LightGray + Blue * 16 ;
                                 BlockAttr : White + Cyan * 16 ;
                                 StatusAttr : Blue + LightGray * 16 ;
                                 CursorAttr : White + Magenta * 16 ;
                                 StatusCursorAttr : White + Magenta * 16) ,
                           {4}  (NormAttr : LightGray + Blue * 16 ;
                                 BlockAttr : White + Magenta * 16 ;
                                 StatusAttr : Yellow + LightGray * 16 ;
                                 CursorAttr : White + Cyan * 16 ;
                                 StatusCursorAttr : White + Cyan * 16) ,
                           {5}  (NormAttr : Black + LightGray * 16 ;
                                 BlockAttr : LightGray + Blue * 16 ;
                                 StatusAttr : White + Red * 16 ;
                                 CursorAttr : LightGray + Black * 16 ;
                                 StatusCursorAttr : LightGray + Black * 16) ,
                           {6}  (NormAttr : LightGray + Black * 16 ;
                                 BlockAttr : Black + LightGray * 16 ;
                                 StatusAttr : Red + LightGray * 16 ;
                                 CursorAttr : LightGray + Red * 16 ;
                                 StatusCursorAttr : LightGray + Red * 16) ,
                           {7}  (NormAttr : Green + Black * 16 ;
                                 BlockAttr : Black + LightGray * 16 ;
                                 StatusAttr : White + LightGray * 16 ;
                                 CursorAttr : Black + Green * 16 ;
                                 StatusCursorAttr : Black + Green * 16) ,
                           {8}  (NormAttr : Cyan + Black * 16 ;
                                 BlockAttr : LightGray + Blue * 16 ;
                                 StatusAttr : Red + LightGray * 16 ;
                                 CursorAttr : Black + Cyan * 16 ;
                                 StatusCursorAttr : Black + Cyan * 16) ,
                           {9}  (NormAttr : Yellow + Blue * 16 ;
                                 BlockAttr : Blue + LightGray * 16 ;
                                 StatusAttr : Black + LightGray * 16 ;
                                 CursorAttr : Red + LightGray * 16 ;
                                 StatusCursorAttr : Red + LightGray * 16) ) ;
      { frame constant used as border string in calls of PutFrame }
      Quasi3DFrame : STRING [8] = 'ķԳ' ;
      { categories of characters, for text formatting etc. }
      WordDelimiters : SET OF CHAR = [' ', CR, LF, TAB] ;
      WordPunctuators : SET OF CHAR = [',', '.', ':', ';', '[', ']',
                                       '(', ')', '{', '}', '/', 
                                       '\', '+', '-', '=', '"', #39 ] ;
      { constants used for constructing the statusline }
      Status_Wrap   : STRING [4] = 'Wrap' ;   { indicates word wrap }
      Status_Ins    : STRING [3] = 'Ins' ;    { indicates insert mode }
      Status_Def    : STRING [3] = 'Def' ;    { on when defining a macro }
      Status_Indent : STRING [6] = 'Indent' ; { indicates autoindent }
      { basis for constructing the statusline }
      BasicStatusLine : STRING [80] =
                         '   L       C                            ' +
                         '                     Ovr               %' ;
      { string used to display CR/LF pair when entering search string }
      CRLFalias : STRING [2] = #17 + #217 ;

VAR AEVersionNr        : STRING [4] ;
    AEVersionDate      : STRING [12] ;
    ProgramFinished    : BOOLEAN ;
                         { indicates if user has given command to exit AE }
    Config             : ConfigBlock ;
    Workspace          : ARRAY [1..MaxNrOfWorkspaces] OF Workspacetype ;
    NrOfWorkspaces     : BYTE ;
                         { actual number of workspaces; may be less than }
                         { MaxNrOfWorkspaces if not enough memory }
    CurrentWsnr        : BYTE ;
                         { contains number of the current workspace }
    CurrentWs          : Workspacetype ;
                         { copy of Workspace[CurrentWsnr] ; used to }
                         { avoid one level of indirection }
    PasteBuffer        : ^PasteBuftype ;
    PasteBufferSize    : WORD ;
                         { contains number of characters in paste buffer }
    MacroStack         : ARRAY [1..MacroStackDepth] OF MacroStackElement ;
                         { macro stack is necessary because macros can call }
                         { other macros }
    MacroStackPointer  : BYTE ;
    MacroDefining      : BYTE ;
                         { number of the macro that is currently being }
                         { defined (when 0: not defining any) }
    FindString         : STRING ;
    ReplaceString      : STRING ;
    SearchOptions      : STRING [10] ;
    SearchType         : BYTE ;
    ColorCard          : BOOLEAN ;
                         { indicates whether video adapter is monochrome }
                         { or color }
    OrigCursorType     : BYTE ;
    OrigTextAttr       : BYTE ;
                         { cursor type and video text attribute on startup }
                         { are kept for restoration on exiting program }
    MessageRead        : BOOLEAN ;
                         { indicates if the message on the status line has }
                         { been read by the user }
                         { set by Message, reset by GetKeyNr }
    LoadfileName       : PathStr ;
                         { contains name of last file to be read or inserted }
    EscPressed         : BOOLEAN ;
                         { indicates whether last call of EnterString, }
                         { EnterWord, EnterBoolean, Answer or Choose was }
                         { terminated by user by pressing Escape }
    Found              : BOOLEAN ;
                         { indicates whether last search operation or }
                         { bracket matching was succesful }
    IgnoreCase         : BOOLEAN ;
    ReverseSearch      : BOOLEAN ;
    NoQuery            : BOOLEAN ;
    WholeWords         : BOOLEAN ;
                         { the current search options }
    DiskError          : BYTE ;
                         { contains result of last disk or print operation }
                         { value 0: everything OK }
    DisplayPtr         : ScreenPtr ;
                         { points to begin of video memory }
    StatusLinePtr      : ScreenPtr ;
                         { points to begin of status line in video memory }
    WordSeparators     : SET OF CHAR ;
    FileHist           : HistPtr ; { history of file names loaded }
    FindHist           : HistPtr ; { history of string searched }
    ReplaceHist        : HistPtr ; { history of string replaced }
    WorkFilePath       : PathStr ; { name of work file loaded at startup }
    {$IFDEF DEVELOP }
    InitMemAvail       : LONGINT ; { initially available heap memory }
    BasicMemAvail      : LONGINT ; { above basic needs (1 workspace) }
    StdMemAvail        : LONGINT ; { after creating all workspaces }
    MinMemAvail        : LONGINT ; { always available during running }
                         { used to compute minimum heap size needed }
    {$ENDIF }

IMPLEMENTATION

BEGIN
WordSeparators := WordDelimiters + WordPunctuators ;
END.
