{ EDITV.PAS - Text file Editor with Borland Turbo Vision

  Title   : EDITV
  Version : 1.6
  Date    : Dec 16,1996
  Author  : J R Ferguson
  Language: Borland Pascal v7.0 with Objects and Turbo Vision v2.0
  Usage   : MS-Dos program
  Download: http://www.xs4all.nl/~ferguson
  E-mail  : j.r.ferguson@iname.com

This program and its source may be used and copied freely without charge,
but only for non-commercial purposes. The author is not responsible for 
any damage or loss of data that may be caused by using it.
}

{$I EDITV.INC}  {compiler directives}

Program EDITV;

uses
  Memory, Drivers, Objects, Views, Menus, App, MsgBox, Editors, StdDlg, 
  Dos, Printer, EditVRes;

const
  C_IdentStr    = 'EDITV v1.6';
  C_OptsExt     = '.OPT';
  C_DflOptBak   = false;

  C_KeyOptBak   = 'Backup';
  C_MaxStatusMsg= 45;


type
  P_StatusMsg   = ^T_StatusMsg;
  P_MenuBar     = ^T_MenuBar;
  P_StatusLine  = ^T_StatusLine;
  P_FileEditor  = ^T_FileEditor;
  P_EditWindow  = ^T_EditWindow;
  P_Application = ^T_Application;

  T_StatusMsg   = String[C_MaxStatusMsg];

  T_MenuBar     = Object(TMenuBar)
    Title       : TTitleStr;
    Constructor   Init(var V_Bounds:TRect; V_Menu:PMenu; V_Title:TTitleStr);
    procedure     Draw; virtual;
  end;

  T_StatusLine  = Object(TStatusLine)
    StatusMsg   : T_StatusMsg;
    Constructor   Init(V_Bounds: TRect; V_Defs: PStatusDef);
    procedure     Draw; virtual;
    procedure     SetMessage(V_Message: T_StatusMsg); virtual;
  end;

  T_FileEditor  = object(TFileEditor)
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   DoInsertLine; virtual;
    procedure   DoFilePrint;  virtual;
    procedure   DoOptIndent;  virtual;
  end;

  T_EditWindow  = object(TEditWindow)
    Constructor Init(var V_Bounds: TRect; V_FileName: PathStr; V_Number: integer);
    procedure   Close; virtual;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
  end;

  T_Application = object(TApplication)
    ClipWindow  : PEditWindow;
    WindowCount : integer;
    OptBak      : boolean;
    constructor Init;
    destructor  Done; virtual;
    procedure   InitMenuBar; virtual;
    procedure   InitStatusLine; virtual;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   Idle; virtual;
    procedure   AdjustCommands;
    procedure   NewWindow(V_FileName: PathStr);
    procedure   OpenFile(const V_FileMask: PathStr);
    function    ReadOptions: boolean;
    function    SaveOptions: boolean;
    procedure   DoFileNew;
    procedure   DoFileOpen;
    procedure   DoSaveAll;
    procedure   DoCloseAll;
    procedure   DoChangeDir;
    procedure   DoEditClip;
    procedure   DoOptEGA;
    procedure   DoOptBak;
    procedure   DoHlpUsage;
    procedure   DoHlpAbout;
  end;

var
  G_ProgName    : NameStr;
  G_ProgDir     : PathStr;
  G_OptsFile    : PathStr;

{ --- General routines --- }

function IsWild(const V_FileMask: PathStr): boolean;
var Dir: DirStr; Name: NameStr; Ext: ExtStr;
begin
  FSplit(FExpand(V_FileMask),Dir,Name,Ext);
  IsWild:= (Pos('*',Name+Ext) > 0) or (Pos('?',Name+Ext) > 0);
end;

procedure GetDirs;
var ProgPath: PathStr; ProgExt: ExtStr;
begin
  ProgPath:= FExpand(ParamStr(0));
  FSplit(ProgPath,G_ProgDir,G_ProgName,ProgExt);
  G_OptsFile:= G_ProgDir + G_ProgName + C_OptsExt;
end;

function Exist(const V_FileMask: PathStr): boolean;
const fatr= AnyFile and not (Directory or VolumeID);
var srec: SearchRec; Path: PathStr; Dir: DirStr; Name: NameStr; Ext: ExtStr;
begin
  Path:= FExpand(V_FileMask); FSplit(Path,Dir,Name,Ext);
  if (Pos('*',Name+Ext) > 0) or (Pos('?',Name+Ext) > 0) then Exist:= false
  else begin
    FindFirst(Path,fatr,srec);
    Exist:= DosError = 0;
  end;
end;

function CreateFile(V_FileName: PathStr): boolean;
var f: text;
begin
  {$I-} Assign(f,V_FileName); rewrite(f); {$I+}
  if IOResult = 0 then begin System.Close(f); CreateFile:= true; end
  else CreateFile:= false;
end;

function HasFlag(V_Status, V_Flag: word): boolean;
begin HasFlag:= (V_Status and V_Flag) <> 0; end;

procedure SetFlag(var V_Status: word; V_Flag: word; V_Condition: boolean);
begin case V_Condition of
  false: V_Status:= V_Status and not V_Flag;
  true : V_Status:= V_Status or      V_Flag;
end; end;

procedure ToggleFlag(var V_Status: word; V_Flag: word);
begin V_Status:= V_Status xor V_Flag; end;


procedure SetStatusMsg(V_StatusMsg: T_StatusMsg);
begin P_StatusLine(StatusLine)^.SetMessage(V_StatusMsg); end;


{ --- T_MenuBar --- }

Constructor   T_MenuBar.Init(var V_Bounds:TRect; V_Menu:PMenu;
                             V_Title:TTitleStr);
begin
  Inherited Init(V_Bounds,V_Menu);
  Title:= V_Title;
end;

procedure     T_MenuBar.Draw;
var R: TRect;
begin
  Inherited Draw;
  GetExtent(R);
  WriteStr(R.B.X-Length(Title)-1, R.A.Y, Title, 2);
end;


{ --- T_StatusLine --- }

Constructor   T_StatusLine.Init(V_Bounds: TRect; V_Defs: PStatusDef);
begin
  Inherited Init(V_Bounds,V_Defs);
  StatusMsg:= '';
end;

procedure     T_StatusLine.Draw;
var R: TRect; p: P_FileEditor;
begin
  Inherited Draw;
  GetExtent(R);
  WriteStr(R.B.X-(C_MaxStatusMsg+10), R.A.Y, StatusMsg, 1);
  p:= Message(DeskTop,evBroadCast,cmGetEditor,nil);
  if (p<>nil) and p^.AutoIndent         then WriteStr(R.B.X-8, R.A.Y, 'IND', 2);
  if P_Application(Application)^.OptBak then WriteStr(R.B.X-4, R.A.Y, 'BAK', 2);
end;

procedure     T_StatusLine.SetMessage(V_Message: T_StatusMsg);
begin
  StatusMsg:= V_Message;
  DrawView;
end;


{ --- T_FileEditor --- }

procedure T_FileEditor.HandleEvent(var V_Event: TEvent);
begin
  inherited HandleEvent(V_Event);
  case V_Event.What of
    evBroadCast: case V_Event.Command of
      cmGetEditor: ClearEvent(V_Event);
    end;
    evCommand  : case V_Event.Command of
      cmInsLine  : begin DoInsertLine; ClearEvent(V_Event); end;
      cmFilePrint: begin DoFilePrint;  ClearEvent(V_Event); end;
      cmOptIndent: begin DoOptIndent;  ClearEvent(V_Event); end;
    end;
  end;
end;

procedure T_FileEditor.DoInsertLine;
  const CrLf : array[1..2] of char = #13#10;
begin
  InsertText(@CrLf,SizeOf(CrLf),false);
  Message(@Self,evCommand,cmCharLeft,nil);
end;

procedure T_FileEditor.DoFilePrint;
var i: word;
begin
  SetStatusMsg('Printing...');
  for i:= 0             to CurPtr        do write(Lst,Buffer^[i]);
  for i:= CurPtr+GapLen to GapLen+BufLen do write(Lst,Buffer^[i]);
  write(Lst,#12);
  SetStatusMsg('');
end;

procedure T_FileEditor.DoOptIndent;
begin
  AutoIndent:= not AutoIndent;
  StatusLine^.DrawView;
end;


{ --- T_EditWindow --- }

Constructor T_EditWindow.Init(var V_Bounds: TRect; V_FileName: PathStr; V_Number: integer);
var MyEditor: P_FileEditor; R: TRect;
begin
  Inherited Init(V_Bounds,'',V_Number);
  Editor^.GetBounds(R);
  MyEditor := New(P_FileEditor, Init(
    R,Editor^.HScrollBar,Editor^.VScrollBar,Editor^.Indicator,V_FileName));
  Dispose(Editor,Done); Editor:= MyEditor; Insert(Editor);
end;

procedure T_EditWindow.Close;
begin
  Dec(P_Application(Application)^.WindowCount);
  inherited Close;
end;

procedure T_EditWindow.HandleEvent(var V_Event: TEvent);
begin
  inherited HandleEvent(V_Event);
  case V_Event.What of
    evBroadcast : case V_Event.Command of
      cmCloseAll    : Close;
      cmSaveAll     : if Editor <> nil then Editor^.Save;
      cmHasNumber   : if V_Event.InfoInt = Number then ClearEvent(V_Event);
    end;
  end;
end;


{ --- T_Application --- }

constructor T_Application.Init;
var R: TRect;
begin
  MaxHeapSize  := 4096;   { allow for Edit buffer area }
  EditorDialog := StdEditorDialog;

  inherited Init;

  Desktop^.GetExtent(R);
  ClipWindow:= New(PEditWindow, Init(R, '', wnNoNumber));
  if ValidView(ClipWindow) <> nil then begin
    ClipWindow^.Hide;
    InsertWindow(ClipWindow);
    Clipboard:= ClipWindow^.Editor;
    Clipboard^.CanUndo:= false;
  end;
  OptBak     := C_DflOptBak;
  WindowCount:= 0;
  if ParamCount >= 1 then
    if IsWild(ParamStr(1)) then OpenFile(ParamStr(1))
                           else NewWindow(ParamStr(1));

  ReadOptions;
  SetFlag(EditorFlags,efBackupFiles,OptBak);
end;

destructor T_Application.Done;
begin
  SaveOptions;
  inherited Done;
end;

procedure T_Application.InitMenuBar;
var R: TRect;
begin
  GetExtent(R); R.B.Y:= R.A.Y + 1;
  MenuBar:= New(P_MenuBar, Init(R, Menu_Main, C_IdentStr));
end;

procedure T_Application.InitStatusLine;
var R: TRect;
begin
  GetExtent(R); R.A.Y:= R.B.Y - 1;
  StatusLine:= New(P_StatusLine, Init(R, Stat_Main));
end;

procedure T_Application.HandleEvent(var V_Event: TEvent);
begin
  inherited HandleEvent(V_Event);
  if V_Event.What = evCommand then case V_Event.Command of
    cmNew         : begin DoFileNew;   ClearEvent(V_Event); end;
    cmOpen        : begin DoFileOpen;  ClearEvent(V_Event); end;
    cmSaveAll     : begin DoSaveAll;   ClearEvent(V_Event); end;
    cmCloseAll    : begin DoCloseAll;  ClearEvent(V_Event); end;
    cmChangeDir   : begin DoChangeDir; ClearEvent(V_Event); end;
    cmEditClip    : begin DoEditClip;  ClearEvent(V_Event); end;
    cmOptEGA      : begin DoOptEGA;    ClearEvent(V_Event); end;
    cmOptBak      : begin DoOptBak;    ClearEvent(V_Event); end;
    cmHlpUsage    : begin DoHlpUsage;  ClearEvent(V_Event); end;
    cmHlpAbout    : begin DoHlpAbout;  ClearEvent(V_Event); end;
  end;
end;

procedure T_Application.Idle;
begin
  AdjustCommands;
  Inherited Idle;
end;

procedure T_Application.AdjustCommands;
begin
  SetCmdState([cmSave,cmSaveAs,cmSaveAll,cmFilePrint,cmCut,cmCopy,cmPaste,
    cmUndo,cmClear,cmOptIndent,cmFind,cmReplace,cmTile,cmCascade,cmCloseAll],
    WindowCount > 0);
  SetCmdState([cmSearchAgain], FindStr <> '');
end;

procedure T_Application.NewWindow(V_FileName: PathStr);
var R: TRect; NewNumber: integer;
begin
  if (V_FileName = '') or Exist(V_FileName) or CreateFile(V_FileName)
  then begin
    NewNumber:= 1;
    while (NewNumber < 10)
      and (Message(DeskTop,evBroadcast,cmHasNumber,Pointer(NewNumber)) <> nil)
    do Inc(NewNumber);
    if NewNumber=10 then NewNumber:= wnNoNumber;

    GetTileRect(R);
    InsertWindow(New(P_EditWindow,Init(R, V_FileName, NewNumber)));
    Cascade;
    Inc(WindowCount);
  end
  else MessageBox(#3'Unable to create file'#13#3 + V_FileName,nil,
       mfError or mfOKButton);
end;

procedure T_Application.OpenFile(const V_FileMask: PathStr);
var FileName: PathStr;
begin
  FileName:= V_FileMask;
  if ExecuteDialog(New(PFileDialog,
     Init(FileName, 'Openfile', '~F~ile name',fdOKButton or fdOpenButton, 1)
     ),@FileName) <> cmCancel
  then NewWindow(FileName);
end;

function  T_Application.ReadOptions: boolean;
var ok: boolean; f: text; s: String;
  function ReadBoolean: Boolean;
  var i,n,e: integer;
  begin
    i:= Pos('=',s);
    if (i=0) or (i=Length(s)) then ReadBoolean:= false
    else begin
      Val(System.Copy(s,i+1,255),n,e);
      ReadBoolean:= n<>0;
    end;
  end;
begin {ReadOptions}
  ok:= false;
  Assign(f,G_OptsFile); {$I-} reset(f); {$I+}
  if IOResult = 0 then begin
    while not eof(f) do begin
      readln(f,s);
      if      Pos('*'        ,s)=1 then {comment}
      else if Pos(C_KeyOptBak,s)=1 then OptBak:= ReadBoolean;
    end;
    System.Close(f);
  end;
  ReadOptions:= ok;
end;

function  T_Application.SaveOptions: boolean;
var ok: boolean; f: text; s: String;
begin
  ok:= false;
  Assign(f,G_OptsFile); {$I-} rewrite(f); {$I+}
  if IOResult = 0 then begin
    writeln(f,'* ',G_ProgName,' options');
    writeln(f,C_KeyOptBak ,'=',Ord(OptBak));
    System.Close(f);
    ok:= true;
  end;
  if not ok then MessageBox(
    #3'Unable to save options to'#13+
    #3+G_OptsFile,nil,mfWarning+mfOKButton);
  SaveOptions:= ok;
end;

procedure T_Application.DoFileNew;
begin NewWindow('') end;

procedure T_Application.DoFileOpen;
begin OpenFile('*.*'); end;

procedure T_Application.DoSaveAll;
begin Message(DeskTop,evBroadCast,cmSaveAll,nil); end;

procedure T_Application.DoCloseAll;
begin Message(DeskTop,evBroadCast,cmCloseAll,nil); end;

procedure T_Application.DoChangeDir;
begin ExecuteDialog(New(PChDirDialog,Init(cdNormal,hlChangeDir)),nil) end;

procedure T_Application.DoEditClip;
begin with ClipWindow^ do begin Select; Show; end; end;

procedure T_Application.DoOptEGA;
begin SetScreenMode(ScreenMode xor smFont8x8); end;

procedure T_Application.DoOptBak;
begin
  OptBak:= not OptBak;
  SetFlag(EditorFlags,efBackupFiles,OptBak);
  StatusLine^.DrawView;
end;

procedure T_Application.DoHlpUsage;
var R: TRect;
begin
  R.Assign(19,4, 61,16);
  MessageBoxRect(R,
    'This program offers the standard'#13 +
    'textfile edit capabilities available'#13 +
    'with Borland Turbo Vision v2.0.'#13#13 +
    'The functions are considered to be'#13 +
    'self-explanatory.'#13#13,
    nil,mfInformation or mfOKButton);
end;

procedure T_Application.DoHlpAbout;
begin
  MessageBox(#3+C_IdentStr+' (c) 1996 JR Ferguson'#13 +
             #3'Character based textfile editor'#13 +
             #3'using Borland Turbo Vision v2.0'#13,
             nil,mfInformation or mfOKButton);
end;


{ --- Main program --- }

begin
  GetDirs;
  Application:= New(P_Application,Init);
  Application^.Run;
  Dispose(Application,Done);
end.
