#include <time.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>


extern void normal(void);
extern void read(char filename[]);
void run6(void);
extern void readdata(char ext[]);
extern void readinst(char filename[]);
extern int sort_function( const void *a, const void *b);


extern void semantic(void) {

 char choice;

 for(;;) {
  normal();
  _setcursortype(_NOCURSOR);
  window(18,6,62,19);
  textbackground(LIGHTGRAY);
  clrscr();
  window(20,7,60,18);
  textcolor(WHITE);
  textbackground(BLUE);
  clrscr();
   gotoxy(5,2);
  cprintf("SEMANTIC PRIMING MENU:");
  gotoxy(5,4);
  cprintf("1. Run the experiment");
  gotoxy(5,5);
  cprintf("2. Show individual results ");
  gotoxy(5,6);
  cprintf("3. Show SPSS ready file ");
  gotoxy(5,7);
  cprintf("4. Details of design");
  gotoxy(5,8);
  cprintf("5. References for further reading");
  gotoxy(5,9);
  cprintf("6. Return to main menu");
  gotoxy(2,12);
  cprintf("Enter choice (1-6)");

  Repeat:
  choice=getch();
  switch (choice) {

   case '1': run6();break;
   case '2': readdata(".sem");break;
   case '3': read("Semantic.cat");break;
   case '4': read("SEMDets.txt");break;
   case '5': read("SEMrefs.txt");break;
   case '6': return;
   default: goto Repeat;
  }
 }
}





 /*RUN6 (): Runs the experiment */
 void run6(void)
 {
  clock_t start, end;
  char *strng;
  int  hit1, hit2, miss1, miss2,  fpos,  crej;
  float rthit1, rthit2, rtmiss1, rtmiss2, rtfpos,rtcrej;
  float mrthit1, mrthit2, mrtmiss1, mrtmiss2, mrtfpos, mrtcrej;
  float value,temp;
  int dec, sign, finish;
  int ndig = 1;
  int b,correct;
  int cond[300];
  int set1, set2,count,a,i,sexno, x, y, comp;
  int rnumber, rnum[100], rnum2[300];
  int RT,rn;
  char init[5], sex;
  char sexstr[2];
  char filename[20],filetemp[20],fileinfo[20],word1[300][20],word2[300][20];
  char ch_ins, quit, cha, resp,let;
  char ch, string[80];
  char letter[300], setstr[80];
  FILE *fpword,*fpins,*fpmaster,*fp,*fpset;
  struct find_t ffblk;

  normal();

  /* record personal data */
   textcolor(WHITE);
   for(;;) {

    do{
     clrscr();
     printf("\nPlease, enter up to four initials\n(press 'enter' when finished): ");
     gets(init);
    } while (strlen(init)>4);

    do {
     clrscr();
     printf("\nMale or female? (just press 'm' or 'f'): ");
     sex=getche();
     delay(300);
    } while (tolower(sex)!='m'&&tolower(sex)!='f');

    sexstr[0]=sex;
    sexstr[1]=0;



    do {
     clrscr();
     printf("\nInitials: %s\nSex: %c\n",init, sex);
     printf("\nAre these correct? (press 'y' or 'n')");
     resp=getche();
    } while (tolower(resp)!='y' && tolower(resp)!='n');

    if (tolower(resp)=='y') break;
    clrscr();
   }


   /*CHECK IF THE FILE EXISTS, ADD NUMBER AND SAVE*/

   value=0;
   ndig=1;
   strcpy(filename,init);
   strcat(filename,sexstr);

   for(;;){
    strcpy(filetemp,filename);
    if(value>9) ndig=2;
    strng = ecvt(value, ndig, &dec, &sign);
    strcat(filetemp,strng);
    strcpy(fileinfo,filetemp);
    strcat(filetemp,".SEM");
    if(ch=='q') exit(0);
    if(!_dos_findfirst(filetemp,_A_NORMAL,&ffblk)) value++;
    else break;
   }


   if((fp=fopen(filetemp,"w"))==NULL) {
    printf("Error: Cannot open %s file",filename);
    exit(1);
   }

   fprintf(fp,"Initials: %s \nSex: %c\n",init,sex);
   fclose(fp);
   clrscr();


    /* instructions */

   readinst("semins.txt");
   textcolor(WHITE);
   clrscr();
   printf("\a");
   delay(1000);
   textcolor(WHITE);


   if((fpset=fopen("semsys.txt","r"))==NULL) {
    printf("Cannot open 'semantic priming' system file: semsys.txt file");
    exit(1);
   }

   for(i=0;;i++) {
    ch=fgetc(fpset);
    if(isdigit(ch)) setstr[i]=ch;
    if(ch=='\n') {
     setstr[i]=0;
     set1=atoi(setstr);
     break;
    }
   }
   for(i=0;;i++) {
    ch=fgetc(fpset);
    if(isdigit(ch)) setstr[i]=ch;
    else {
     setstr[i]=0;
     set2=atoi(setstr);
     fclose(fpset);
     break;
    }
   }


   /*get words AND CONDITIONS and put them to an array*/

   if((fpword=fopen("semword.txt","r"))==NULL) {
    printf("Cannot open semword.txt file");
    exit(1);
   }

    finish=1;
    let=0;
    for(a=0;finish&&a<=300;a++) {
     if(a&&!strlen(word1[a-1])) {
      finish=0;
//      size=a;
      break;
     }
     for(b=0;finish;b++) {
      if(!feof(fpword)) {
       ch=fgetc(fpword);
       if(isspace(ch)) b--;
       if(!let&&isalpha(ch)) word1[a][b]=ch;
       if(!let&&ch==':') {
	word1[a][b]=0;
	let=1;
	b=-1;
       }

       if(let&&isalpha(ch)) word2[a][b]=ch;
       if(let&&ch==':') {
	word2[a][b]=0;
       }

       if(let&&isdigit(ch)) {
	cond[a]=ch-48;
	let=0;
	if(cond[a]>3||cond[a]<1) {
	 printf("ERROR in line #%d: Valid values for conditions are 1-3",a);
	 exit(0);
	}
	break;
       }

      }
      else {
       finish=0;
//       size=a;
      }
     }
    }

    fclose(fpword);


  /* PRACTICE TRIALS*/

   /*present Practice trials*/


   randomize();
   for(a=0;a<set1;) {
    comp=0;
    rnumber=random(set1);
    for(i=0;i<a;i++) if(rnumber==rnum[i]) comp++;
    if(comp==0) {
     rnum[a]=rnumber;
     a++;
    }
   }



   _setcursortype(_NOCURSOR);

   /*presentations*/

   for(count=0;count<set1;count++) {

    // present prime
    gotoxy(35,10);
    cprintf("%s",word1[rnum[count]]);
    delay(200);
    clrscr();
    delay(200);
    //present target
    gotoxy(35,10);
    cprintf("%s",word2[rnum[count]]);


    while(kbhit()) getch();


    do {
    ch=getch();
    } while(tolower(ch)!='1'&&tolower(ch)!='0');


    sound(500);
    delay(20);
    nosound();
    clrscr();

    if(ch=='1') {
     if(cond[rnum[count]]<3) {
      sound(50);
      delay(200);
      nosound();
     }
    }

    else if(ch=='0') {
     if(cond[rnum[count]]>2) {
      sound(50);
      delay(200);
      nosound();
     }
    }


    delay(400);
   }

     /* Pause between sessions*/

   window(1,1,80,24);
   textcolor(BLACK);
   textbackground(LIGHTGRAY);
   clrscr();
   if((fpins=fopen("semins2.txt","r"))==NULL) {
    printf("Cannot open 'STRINS2.TXT' file!");
    exit(1);
   }

   while((ch_ins=fgetc(fpins))!=EOF) putchar(ch_ins);
   fclose(fpins);
   while(kbhit()) getch();
   getch();
   window(1,1,80,25);
   textcolor(WHITE);
   textbackground(BLACK);
   clrscr();
   printf("\a");
   delay(1000);




     /* EXPERIMENTAL TRIALS*/


  /* create random numbers */

   randomize();
   for(a=0;a<set2;) {
    comp=0;
    rnumber=random(set2);
    for(i=0;i<a;i++) if(rnumber==rnum2[i]) comp++;
    if(comp==0) {
     rnum2[a]=rnumber;
     a++;
    }
   }

   for(a=0;a<set2;a++) rnum2[a]=rnum2[a]+set1;




   /*presentations*/


   _setcursortype(_NOCURSOR);

   rthit1=0;
   rthit2=0;
   hit1=0;
   hit2=0;
   miss1=0;
   miss2=0;
   rtmiss1=0;
   rtmiss2=0;
   fpos=0;
   rtfpos=0;
   crej=0;
   rtcrej=0;



   for(count=0;count<set2;count++) {

    // present prime
    gotoxy(35,10);
    cprintf("%s",word1[rnum2[count]]);
    delay(200);
    clrscr();
    delay(200);
    //present target
    gotoxy(35,10);
    cprintf("%s",word2[rnum2[count]]);

    while(kbhit()) getch();

    start = clock();
    do {
     ch=getch();
    } while(tolower(ch)!='1'&&tolower(ch)!='0');
    end = clock();

    RT=(end-start)/CLK_TCK*1000;
    if(RT>3000) RT=3000;
    sound(500);
    delay(20);
    nosound();
    clrscr();


    delay(400);


    /*		   Three CONDITIONS:
    1=related prime:  No of misses+MRT, No. of hits+RT
    2=unrelated prime: same
    3=negative trials (target nonword): No. of fpos+MRT, No. of crej+MRT */

    if(tolower(ch)=='1') {
     if(cond[rnum2[count]]==3) {
      crej++;
      rtcrej=rtcrej+RT;
     }
     if(cond[rnum2[count]]==2) {
      miss2++;
      rtmiss2=rtmiss2+RT;
     }
     if(cond[rnum2[count]]==1) {
      miss1++;
      rtmiss1=rtmiss1+RT;
     }
    }
    else if(tolower(ch)=='0') {
     if(cond[rnum2[count]]==3) {
      fpos++;
      rtfpos=rtfpos+RT;
     }
     if(cond[rnum2[count]]==2) {
      hit2++;
      rthit2=rthit2+RT;
     }
     if(cond[rnum2[count]]==1) {
      hit1++;
      rthit1=rthit1+RT;
     }
    }

     /*pause*/

    if(count>20 && count%(set2/5)==0) {
     clrscr();
     printf("\a");
     gotoxy(20,10);
     printf("Have a short rest.");
     gotoxy(1,25);
     printf("Press any key to continue...");
     getch();
     clrscr();
     printf("\a");
     delay(1000);

    }



   }
   //MEANS

   if(!hit1) mrthit1=0;
   else mrthit1=rthit1/hit1;
   if(!hit2) mrthit2=0;
   else mrthit2=rthit2/hit2;
   if(!miss1) mrtmiss1=0;
   else mrtmiss1=rtmiss1/miss1;
   if(!miss2) mrtmiss2=0;
   else mrtmiss2=rtmiss2/miss2;
   if(!fpos) mrtfpos=0;
   else mrtfpos=rtfpos/fpos;
   if(!crej) mrtcrej=0;
   else mrtcrej=rtcrej/crej;


   if((fp=fopen(filetemp,"a"))==NULL) {
    printf("Cannot open '%s' file!",filetemp);
    exit(1);
   }
   fprintf(fp, "\nWORD TRIALS\n===============");
   fprintf(fp, "\n\nRelated words");
   fprintf(fp, "\nNo. of hits  : %d", hit1);
   fprintf(fp, "\nMean RT:       %-4.0f", mrthit1);
   fprintf(fp, "\nNo. of misses: %d", miss1);
   fprintf(fp, "\nMean RT:       %-4.0f", mrtmiss1);
   fprintf(fp, "\n\nUnrelated words");
   fprintf(fp, "\nNo. of hits  : %d", hit2);
   fprintf(fp, "\nMean RT:       %-4.0f", mrthit2);
   fprintf(fp, "\nNo. of misses: %d", miss2);
   fprintf(fp, "\nMean RT:       %-4.0f", mrtmiss2);
   fprintf(fp, "\n\nNONWORD TRIALS\n===============");
   fprintf(fp, "\nNo. of correct rejections: %d", crej);
   fprintf(fp, "\nMean RT:                   %-4.0f", mrtcrej);
   fprintf(fp, "\nNo. of false positives:    %d",  fpos);
   fprintf(fp, "\nMean RT:                   %-4.0f", mrtfpos);
   fclose(fp);


      /* Update master catalogue */
   if((fpmaster=fopen("semantic.cat","a"))==NULL) {
    printf("Error: Cannot open SEMANTIC.CAT file\n");
    exit(1);
   }
   if (tolower(sex)=='m') sexno=1;
   else if(tolower(sex)=='f') sexno=2;

   fprintf(fpmaster,"\n%4s %d %d %4.0f %d %4.0f %d %4.0f %d %4.0f %d %4.0f %d %4.0f", init, sexno, hit1, mrthit1, miss1, mrtmiss1, hit2, mrthit2, miss2, mrtmiss2, crej, mrtcrej, fpos, mrtfpos);
   fclose(fpmaster);

   /* END MESSAGE*/
   clrscr();
   window(9,8,71,17);
   textbackground(LIGHTGRAY);
   clrscr();
   window(10,9,70,16);
   textbackground(GREEN);
   textcolor(BLACK);
   clrscr();
   gotoxy(3,2);
   printf("THIS IS THE END OF THE EXPERIMENT");
   gotoxy(3,5);
   printf("Your complete results were saved in the '%s' file.",filetemp);
   getch();
   return;






 }


