/*******************************************************************
 *
 *  ttengine.h                                                   1.0
 *
 *    Engine instance structure definition
 *
 *  Copyright 1996, 1997 by
 *  David Turner, Robert Wilhelm, and Werner Lemberg.
 *
 *  This file is part of the FreeType project, and may only be used
 *  modified and distributed under the terms of the FreeType project
 *  license, LICENSE.TXT. By continuing to use, modify or distribute
 *  this file you indicate that you have read the license and
 *  understand and accept it fully.
 *
 ******************************************************************/

#ifndef TTENGINE_H
#define TTENGINE_H

#include "freetype.h"
#include "ttmutex.h"

  #ifdef __cplusplus
  extern "C" {
  #endif

  /********************************************************************/
  /*                                                                  */
  /*  The freetype engine instance structure.                         */
  /*                                                                  */
  /*  This structure holds all the data that is necessary to run      */
  /*  one instance of the freetype engine. It is needed to get a      */
  /*  completely re-entrant version of the library.                   */
  /*                                                                  */
  /*  The goal is to move _all_ component-specific variables, either  */
  /*  static or global in the structure; the component initializers   */
  /*  and finalizers will all be called with the address of a valid   */
  /*  TEngine_Instance.                                               */
  /*                                                                  */
  /********************************************************************/

  struct _TEngine_Instance 
  {
     TMutex  lock;               /* engine lock */

     void*   list_free_elements;

     void*   objs_face_class;       /* the face cache class     */
     void*   objs_instance_class;   /* the instance cache class */
     void*   objs_execution_class;  /* the context cache class  */
     void*   objs_glyph_class;      /* the glyph cache class    */

     void*   objs_face_cache;  /* these caches are used to track */
     void*   objs_glyph_cache; /* active face and glyph objects  */
                               /* they do not perform recycling  */

     void*   file_component;    /* ttfile implementation dependent   */
     void*   memory_component;  /* ttmemory implementation dependent */

     void*   raster_component;  /* ttraster implementation depedent  */
     char    raster_palette[5]; /* gray-levels palette for anti-aliasing */

     void*   extension_component;  /* extensions dependent */
  };

  typedef struct _TEngine_Instance  TEngine_Instance;
  typedef TEngine_Instance         *PEngine_Instance;

#ifdef TT_CONFIG_REENTRANT  /* for re-entrant builds */

  #define ENGINE_ARG    TEngine_Instance*  _engine
  #define ENGINE_ARGS   TEngine_Instance*  _engine,

  #define ENGINE_VAR   _engine
  #define ENGINE_VARS  _engine,

  #define ENGINE  _engine

#else                       /* for thread-safe builds */

  #define ENGINE_ARG    /* void */
  #define ENGINE_ARGS

  #define ENGINE_VAR
  #define ENGINE_VARS

#endif

  extern TEngine_Instance  engine;
  /* the library's single engine instance. This     */
  /* variable must be defined by the high-level API */

  /* i.e. the variable is defined in the file 'ttapi.c' */

  /* Our goal is to make 'engine' FreeType's engine's _only_ */
  /* global variable, even in re-entrant builds.             */

  #ifdef __cplusplus
  }
  #endif

#endif /* TTENGINE_H */
