/*
Ŀ
 Little Draw v1.0 beta   By Shachar Greenberg & Eyal Mush  ISRAEL  1996 

									    */
#include <graphics.h>
#include <fstream.h>
#include <iostream.h>
#include <conio.h>
#include <process.h>

int huge detectVGA(void);
void checkerrors(void);
void load_ldw(ifstream *file,int x,int y);
main(int argc, char *argv[])
{
 ifstream file;
 int gdriver, gmode;
 if (argc==2)
    {
     file.open(argv[1], ios::in | ios::nocreate);
     if (!file)
       {
	cout<<"\n Viewer for - Little Draw 1.0 beta (1996) format.\n";
	cout<<"\n Error: '"<<argv[1]<<"' was not found! \n";
	return 1;
       }
     else
       {
	gdriver = installuserdriver("Svga256",  detectVGA);
	gdriver = DETECT;
	checkerrors();
	initgraph(&gdriver,&gmode, "");
	checkerrors();
	load_ldw(&file,0,0);
	getch();
	file.close();
	closegraph();
       }
    }
 else
    {
     cout<<"\n Viewer for - Little Draw 1.0 beta (1996) format.\n";
     cout<<"\n  "<<argv[0]<<" filename.LDW \n";
    }
return 0;
}

/*************************** Load LDW **************************************/
void load_ldw(ifstream *file,int x,int y)
 {
  unsigned char *FORMAT="LDRAW96a";
  unsigned char header[sizeof(FORMAT)*2];
  unsigned int colors,maxx=getmaxx();
  unsigned int i,j,xwin,ywin;
  unsigned char pcolor;
  file->read(header,sizeof(header));
  file->read((unsigned char*)&colors,sizeof(int));
  file->read((unsigned char*)&xwin,sizeof(int));
  file->read((unsigned char*)&ywin,sizeof(int));
  for(i=0;(i<ywin) && ((i+y)<=getmaxy());i++)
   {
    for(j=0;j<xwin;j++)
     {
      if ((j+x)<=maxx)
       {
	file->read((unsigned char*)&pcolor,sizeof(char));
	putpixel(x+j,y+i,(int)pcolor);
       }
      else
       {
	file->seekg(xwin-j,ios::cur);
	break;
       }
     }
    if ((y+i)==getmaxy()) break;
   }
 }


int huge detectVGA(void)
{
   int driver, mode, sugmode = 0;
   detectgraph(&driver, &mode);
   if (driver == VGA) return sugmode;
       else return grError;
}

void checkerrors(void)
{
   int errorcode;

   /* read result of last graphics operation */
   errorcode = graphresult();
   if (errorcode != grOk)
   {
      cout<<"Graphics error: "<<grapherrormsg(errorcode)<<"\n";
      cout<<"Press any key to halt:";
      getch();
      cout<<"\n";
      exit(1);
   }
}