#
# Perform integration tests to determine the effect
# of relerr, and abserr on the solution.
#

vdpol = function ( t , x ) 
{
  local (xp)
  xp = zeros(2,1);
  xp[1] = x[1] * (1 - x[2]^2) - x[2];
  xp[2] = x[1];
  return xp;
};

t0 = 0;
tf = 10;
x0 = [0; 0.25];
dtout = 0.05;

relerr = [1e-6, 1e-5, 1e-4, 1e-3, 1e-2, 1e-1];
abserr = relerr;

#
# Baseline
#

xbase = ode( vdpol, 0, 20, x0, 0.05, 1e-9, 1e-9);
results = zeros (relerr.n, abserr.n);
elapse = zeros (relerr.n, abserr.n);

"start testing loop"
for (i in 1:abserr.n)
{
  xode.[i] = <<>>;
  for (j in 1:relerr.n)
  {
    printf("\t%i %i\n", i, j);
    tic();
    xode.[i].[j] = ode( vdpol, 0, 20, x0, 0.05, relerr[j], abserr[i]);
    elapse[i;j] = toc();

    # Save results
    results[i;j] = max (max (abs (xode.[i].[j] - xbase)));
  }
}

results
