;
;  -- crc.asm --
;
;  The CRC functions are callable from BASIC as large
;  model C functions. See file CRC.BI.
;
DGROUP   group   _DATA,_BSS
   assume   cs:CRC_TEXT,ds:DGROUP
_DATA   segment word public 'DATA'
_DATA   ends
_BSS   segment word public 'BSS'
Counter  dw   ?
CRCtable label   word
   db   512 dup (?)
_BSS   ends
CRC_TEXT   segment byte public 'CODE'
   ;
   ;   void InitCRC(void)
   ;
   assume   cs:CRC_TEXT
_InitCRC   proc   far
   push   bp
   mov    bp,sp
   push   si
   ;
   ;   {int i;
   ;    for(i=0;i<256;i++) CRCtable[i] = CalcTable(i,POLY,0);
   ;
   xor   si,si
   jmp   short CRC114
CRC58:
   xor   ax,ax
   push   ax
   mov   ax,4129
   push   ax
   push   si
   call   far ptr _CalcTable
   add   sp,6
   mov   bx,si
   shl   bx,1
   mov   word ptr DGROUP:CRCtable[bx],ax
   inc   si
CRC114:
   cmp   si,256
   jl   short CRC58
   ;
   ;   }
   ;
   pop   si
   pop   bp
   ret
_InitCRC   endp
CRC_TEXT   ends
;
CRC_TEXT   segment byte public 'CODE'
   ;
   ;   unsigned short CalcTable(
   ;
   assume   cs:CRC_TEXT
_CalcTable   proc   far
   push   bp
   mov   bp,sp
   push   si
   push   di
   mov   di,word ptr [bp+6]
   mov   si,word ptr [bp+10]
   ;
   ;      unsigned short data,
   ;      unsigned short genpoly,
   ;      unsigned short accum)
   ;   {static int i;
   ;    data <<= 8;
   ;
   mov   cl,8
   shl   di,cl
   ;
   ;    for(i=8;i>0;i--)
   ;
   mov   word ptr DGROUP:Counter,8
   jmp   short CALC198
CALC58:
   ;
   ;            {
   ;             if((data^accum) & 0x8000) accum = (accum << 1) ^ genpoly;
   ;
   mov   ax,di
   xor   ax,si
   test   ax,32768
   je   short CALC114
   mov   ax,si
   shl   ax,1
   xor   ax,word ptr [bp+8]
   mov   si,ax
   jmp   short CALC142
CALC114:
   ;
   ;             else accum <<= 1;
   ;
   shl   si,1
CALC142:
   ;
   ;             data <<= 1;
   ;
   shl   di,1
   dec   word ptr DGROUP:Counter
CALC198:
   cmp   word ptr DGROUP:Counter,0
   jg   short CALC58
   ;
   ;            }
   ;    return(accum);
   ;
   mov   ax,si
   jmp   short CALC254
CALC254:
   ;
   ;   }
   ;
   pop   di
   pop   si
   pop   bp
   ret
_CalcTable   endp
   ;
   ;   long UpdateCRC(long crc, unsigned char byte)
   ;
   assume   cs:CRC_TEXT
_UpdateCRC   proc   far
   push   bp
   mov   bp,sp
   push   si
   mov   si,word ptr [bp+6]
   ;
   ;    ...Visual BASIC doesn't have unsigned integers, so forced to use
   ;    ...longs so don't get overflow when msb = 1
   ;
   ;   {
   ;    return( (crc << 8) ^ CRCtable[ (crc >> 8) ^ byte ] );
   ;
   mov   al,byte ptr [bp+10]  ;get byte
   mov   ah,0
   mov   bx,si
   mov   cl,8
   shr   bx,cl
   xor   bx,ax
   shl   bx,1
   mov   ax,si
   mov   cl,8
   shl   ax,cl
   xor   ax,word ptr DGROUP:CRCtable[bx]
UPDATE58:
   ;
   ;   }
   ;
   pop   si
   pop   bp
   xor   dx,dx
   ret
_UpdateCRC   endp
CRC_TEXT   ends
_CRCtable   equ   CRCtable
   public   _UpdateCRC
   public   _CalcTable
   public   _InitCRC
   end
