'
' PCL4VB.BI
'

 DEFINT A-Z

REM PCL4VB functions

 DECLARE FUNCTION SioBaud CDECL (BYVAL Port,BYVAL BaudCode)
 DECLARE FUNCTION SioBrkKey CDECL ()
 DECLARE FUNCTION SioBrkSig CDECL (BYVAL Port,BYVAL Char)
 DECLARE FUNCTION SioCrtWrite CDECL (BYVAL Char)
 DECLARE FUNCTION SioCTS CDECL (BYVAL Port)
 DECLARE FUNCTION SioDCD CDECL (BYVAL Port)
 DECLARE FUNCTION SioDSR CDECL (BYVAL Port)
 DECLARE FUNCTION SioDTR CDECL (BYVAL Port,BYVAL Char)
 DECLARE FUNCTION SioDelay CDECL (BYVAL Tics)
 DECLARE FUNCTION SioDone  CDECL (BYVAL Port)
 DECLARE FUNCTION SioError CDECL (BYVAL Code)
 DECLARE FUNCTION SioFIFO CDECL (BYVAL Port,BYVAL Code)
 DECLARE FUNCTION SioFlow CDECL (BYVAL Port,BYVAL Code)
 DECLARE FUNCTION SioGetDiv CDECL (BYVAL Port)
 DECLARE FUNCTION SioGetc  CDECL (BYVAL Port,BYVAL Tics)
 DECLARE FUNCTION SioInfo CDECL (BYVAL Char)
 DECLARE FUNCTION SioIRQ CDECL (BYVAL Port,BYVAL IRQ)
 DECLARE FUNCTION SioKeyPress CDECL ()
 DECLARE FUNCTION SioKeyRead CDECL ()
 DECLARE FUNCTION SioLine CDECL (BYVAL Port)
 DECLARE FUNCTION SioLoopBack CDECL (BYVAL Port)
 DECLARE FUNCTION SioModem CDECL (BYVAL Port,BYVAL Char)
 DECLARE FUNCTION SioParms CDECL (BYVAL Port,BYVAL Code1,BYVAL Code2,BYVAL Code3)
 DECLARE FUNCTION SioPorts CDECL (BYVAL Port,BYVAL Code1,BYVAL Code2,BYVAL Code3)
 DECLARE FUNCTION SioPutc  CDECL (BYVAL Port,BYVAL Char)
 DECLARE FUNCTION SioRead CDECL (BYVAL Port,BYVAL Code)
 DECLARE FUNCTION SioReset CDECL (BYVAL Port,BYVAL BaudCode)
 DECLARE FUNCTION SioRI CDECL (BYVAL Port)
 DECLARE FUNCTION SioRTS CDECL (BYVAL Port,BYVAL Char)
 DECLARE FUNCTION SioRxBuf CDECL (BYVAL Port,BYVAL PtrSeg,BYVAL Size)
 DECLARE FUNCTION SioRxClear CDECL (BYVAL Port)
 DECLARE FUNCTION SioRxQue CDECL (BYVAL Port)
 DECLARE FUNCTION SioSetDiv CDECL (BYVAL Port,BYVAL Divisor)
 DECLARE FUNCTION SioTimer& CDECL ()
 DECLARE FUNCTION SioTxBuf CDECL (BYVAL Port,BYVAL PtrSeg,BYVAL Size)
 DECLARE FUNCTION SioTxClear CDECL (BYVAL Port)
 DECLARE FUNCTION SioTxFlush CDECL (BYVAL Port)
 DECLARE FUNCTION SioTxQue CDECL (BYVAL Port)
 DECLARE FUNCTION SioUART CDECL (BYVAL Port,BYVAL UART)
 DECLARE FUNCTION SioUnGetc CDECL (BYVAL Port,BYVAL Char)

REM COM port codes

 CONST COM1  = 0
 CONST COM2  = 1
 CONST COM3  = 2
 CONST COM4  = 3
 CONST COM5  = 4
 CONST COM6  = 5
 CONST COM7  = 6
 CONST COM8  = 7
 CONST COM9  = 8
 CONST COM10 = 9
 CONST COM11 = 10
 CONST COM12 = 11
 CONST COM13 = 12
 CONST COM14 = 13
 CONST COM15 = 14
 CONST COM16 = 15
 CONST COM17 = 16
 CONST COM18 = 17
 CONST COM19 = 18
 CONST COM20 = 19

REM Baud codes


 CONST BaudUser = 0
 CONST Baud300 = 1
 CONST Baud1200 = 2
 CONST Baud2400 = 3
 CONST Baud4800 = 4
 CONST Baud9600 = 5
 CONST Baud19200 = 6
 CONST Baud38400 = 7
 CONST Baud57600 = 8
 CONST Baud115200 = 9
 CONST NORESET = -1

REM Parity Codes

CONST NoParity  = 0
CONST OddParity  = 1
CONST EvenParity = 3
CONST MarkParity = 5
CONST SpaceParity = 7

REM Stop Bit Codes

CONST OneStopBit  = 0
CONST TwoStopBits = 1

REM Word Length Codes

CONST WordLength5  = 0
CONST WordLength6  = 1
CONST WordLength7  = 2
CONST WordLength8  = 3

REM Buffer Size Codes

CONST Size128  = 4
CONST Size256  = 5
CONST Size512  = 6
CONST Size1024 = 7
CONST Size2048 = 8
CONST Size4096 = 9
CONST Size8192 = 10
CONST Size16384 = 11
CONST Size32768 = 12
CONST Size1K   = 7
CONST Size2K   = 8
CONST Size4K   = 9
CONST Size8K   = 10
CONST Size16K  = 11
CONST Size32K  = 12

REM Line Status Masks

CONST TransBufferEmpty = 32
CONST BreakDetect  = 16
CONST FramingError = 8
CONST ParityError  = 4
CONST OverrunError = 2
CONST DataReady    = 1

REM Modem Status Masks

CONST DCD = 128
CONST RI  =  64
CONST DSR =  32
CONST CTS =  16
CONST DeltaDCD = 8
CONST DeltaRI  = 4
CONST DeltaDSR = 2
CONST DeltaCTS = 1

REM Break Signal Commands

CONST ASSERT_BREAK = 65
CONST CANCEL_BREAK = 67
CONST DETECT_BREAK = 68

REM SioDTR & SioRTS Commands

CONST SET_LINE   = 83
CONST CLEAR_LINE = 67
CONST READ_LINE  = 82

REM FIFO level codes

CONST FIFO_OFF  = -1
CONST LEVEL_1   =  0
CONST LEVEL_4   =  1
CONST LEVEL_8   =  2
CONST LEVEL_14  =  3
CONST LEVEL_1ST =  0
CONST LEVEL_2ND =  1
CONST LEVEL_3RD =  2
CONST LEVEL_4TH =  3

REM IRQ codes

CONST IRQ2  = 2
CONST IRQ3  = 3
CONST IRQ4  = 4
CONST IRQ5  = 5
CONST IRQ6  = 6
CONST IRQ7  = 7
CONST IRQ8  = 8
CONST IRQ9  = 9
CONST IRQ10 = 10
CONST IRQ11 = 11
CONST IRQ12 = 12
CONST IRQ13 = 13
CONST IRQ14 = 14
CONST IRQ15 = 15

REM SioInfo Commands

CONST VERSION = 86

REM SioPort dumbcard types

CONST PC_PORTS  = 0
CONST DIGIBOARD = 1
CONST BOCABOARD = 2
CONST GTEK      = 2
CONST FASTCOMM  = 2

