#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <libp.h>

void *_allocbloc = 0;

#pragma rundown memdelete 5

void memdelete(void)
{
	BLKHEAD *p = _allocbloc;
	while (p) {
		BLKHEAD *n = p->next;
		_ll_free(p);
		p = n;
	}
}

static int init_block(BLKHEAD **blk, size_t size)
{
	size_t ns = size+sizeof(BLKHEAD)+sizeof(FREELIST);
	void *nb;
	FREELIST *lp;
	if (ns < ALLOCSIZE)
		ns = ALLOCSIZE;
	nb = _ll_malloc(ns);
	if (!nb)
		return 0;
	(*blk) = nb;
	((BLKHEAD *)nb)->next = 0;
	((BLKHEAD *)nb)->list = lp = (((char *)nb)+sizeof(BLKHEAD));
	((BLKHEAD *)nb)->size = ns;
	lp->next = 0;
	lp->size = ns - sizeof(BLKHEAD);
	return 1;
}
static void *split(FREELIST **flist, size_t size)
{
	FREELIST *p = *flist;
	FREELIST *flist2;
	if (size + sizeof(size_t) < p->size + sizeof(FREELIST)) {
		flist2 = (char *)*flist+size+sizeof(size_t);
		flist2->size = p->size - size-sizeof(size_t);
		flist2->next = p->next;
		*flist = flist2;
	}
	else {
		(*flist) = (*flist)->next;
	}
	*(long *)p = size;
	return (size_t *)p+1;
}
void *malloc(size_t size)
{
	BLKHEAD **blist;
	FREELIST **flist;
	void *p;
	size +=3;
	size &= 0xfffffffc;
	blist = &_allocbloc;
	while (*blist) {
		flist = &(*blist)->list;
		while (*flist) {
			if ((*flist)->size >= size+sizeof(size_t) + sizeof(FREELIST)) {
				p =split(flist,size);
				return p;
			}
			flist = &((*flist)->next);
		}
		blist = &(*blist)->next;
	}
	if (!init_block(blist,size)) {
		return 0;
	}
	flist = &(*blist)->list;
	p = split(flist,size);
	return p;
}