#include <stdio.h>
#include <time.h>
#include <libp.h>
#include <dpmi.h>
#include <llp.h>
#include <errno.h>

extern unsigned _linear;

void *_ll_malloc(int size)
{
	DPMI_MEM_HANDLE handle;
	ULONG address;
  if (dpmi_get_memory(&address, &handle, size+sizeof(DPMI_MEM_HANDLE) + 4095) & -4096) {
		errno = _dos_errno = ENOMEM;
		return 0;
	}
	address -= _linear;
	*(DPMI_MEM_HANDLE *)address = handle;
	return (void *) (address + sizeof(DPMI_MEM_HANDLE));
}

void _ll_free(void *block)
{
	DPMI_MEM_HANDLE handle;
	handle = *(((DPMI_MEM_HANDLE *) block) -1);
	dpmi_free_memory(handle);
}