#include <time.h>
#include <stdio.h>
#include <libp.h>
#include <dpmi.h>
#include <llp.h>

extern int maxfiles;

unsigned char inbuf[512],outbuf[512],errbuf[512];

FILE output_file = { 0, _F_WRIT | _F_LBUF | _F_TERM,1,0,512,outbuf,outbuf,0,FILTOK };
FILE input_file = { 0, _F_READ | _F_LBUF | _F_TERM,1,0,512,inbuf,inbuf,0,FILTOK };
FILE error_file = { 0, _F_WRIT | _F_LBUF | _F_TERM,1,0,512,errbuf,errbuf,0,FILTOK };

#undef stdin
#undef stdout
#undef stderr

FILE *stdin = &input_file;
FILE *stdout = &output_file;
FILE *stderr = &error_file;

extern int maxfiles;

void _ll_init(void)
{
	_pstreams[0] = &input_file;
	_pstreams[1] = &output_file;
	_pstreams[2] = &error_file;
	maxfiles = 3;
}
int _ll_open(char *name, int flags)
{
	DPMI_REGS regs;
	regs.d.eax = flags;
	regs.h.dx = __nametodta(name,0);
	return __doscall(0x3d,&regs);
}
int _ll_creat(char *name, int flags)
{
	DPMI_REGS regs;
	regs.d.ecx = flags;
	regs.h.dx = __nametodta(name,0);
	return __doscall(0x3c,&regs);
}
int _ll_close(int fd)
{
	DPMI_REGS regs;
	if (fd < 5)
		return 0;
	regs.h.bx = fd;
	__doscall(0x3e,&regs);
	return 0;
}
size_t _ll_getpos(int fd)
{
	DPMI_REGS regs;
	regs.h.bx = fd;
	regs.h.dx =0;
	regs.h.cx = 0;
	regs.b.al=1;
	__doscall(0x42,&regs);
	if (regs.h.flags & 1)
		return -1;
	return ((regs.h.dx << 16) + regs.h.ax);
}
int _ll_flags(int flags)
{
	if (flags & _F_WRIT)
		if (flags & _F_READ)
			return 2;
		else
			return 1;
	else
		return 0;
} 

int _ll_seek(int fd, int pos, int origin)
{
	DPMI_REGS regs;
	regs.h.bx = fd;
	regs.h.cx = pos >> 16;
	regs.h.dx = pos & 65535;
	regs.b.al = origin;
	__doscall(0x42,&regs);
	if (regs.h.flags & 1)
		return -1;
	
	return 0;
}
int _ll_rename(char *old , char *new)
{
	DPMI_REGS regs;
	regs.h.dx = __nametodta(old,0);
	regs.h.di = __nametodta(new,256);
	__doscall(0x56,&regs);
	if (regs.h.flags & 1)
		return -1;
	
	return 0;
}
int _ll_remove(char *name)
{
	DPMI_REGS regs;
	regs.h.dx = __nametodta(name,0);
	__doscall(0x41,&regs);
	if (regs.h.flags & 1)
		return -1;
	
	return 0;
}
int _ll_write(int fd, void *buf, int size)
{
	DPMI_REGS regs;
	regs.h.dx = __buftodta(buf,512);
	regs.h.bx = fd;
	regs.h.cx = size;
	__doscall(0x40,&regs);
	if (regs.h.flags & 1)
		return 0;
	return regs.h.ax;
}
int _ll_read(int fd, void *buf, int size)
{
	DPMI_REGS regs;
	regs.h.dx = 0;
	regs.h.bx = fd;
	regs.h.cx = size;
	__doscall(0x3f,&regs);
	if (regs.h.flags & 1)
		return 0;
	__dtatobuf(buf,size);
	return regs.h.ax;
}