/*
 * This file is included in this release as an alpha version.
 *
 * The only things that have been tested at this time are
 * the series 00xx,01xx,03xx functions
 *
 * Use the rest at your own risk!
 */

#ifndef __DPMI_H
#define __DPMI_H

typedef unsigned ULONG;
typedef unsigned short UWORD;
typedef unsigned char UBYTE;
typedef UWORD SELECTOR;

typedef unsigned char DESCRIPTOR[8];

typedef struct _multiple_descriptor_ {
	UWORD sel;
	DESCRIPTOR desc;
} MULTIPLE_DESCRIPTOR;

typedef union _dpmi_regs_{
	struct {
		ULONG edi,esi,ebp,res1;
		ULONG ebx,edx,ecx,eax;
	} d;
	struct {
		UWORD di,h_di;
		UWORD si,h_si;
		UWORD bp,h_bp;
		UWORD res1,res2;
		UWORD bx,h_bx;
		UWORD dx,h_dx;
		UWORD cx,h_cx;
		UWORD ax,h_ax;
		UWORD flags;
		UWORD es,ds,fs,gs;
		UWORD ip,cs;
		UWORD sp,ss;
	} h;
	struct {
		UBYTE edi[4],esi[4],ebp[4],res1[4];
		UBYTE bl,bh,b_bh1,b_bh2;
		UBYTE dl,dh,b_dh1,b_dh2;
		UBYTE cl,ch,b_ch1,b_ch2;
		UBYTE al,ah,b_ah1,b_ah2;
	} b;
} DPMI_REGS;

typedef struct _dpmi_ver {
	UBYTE	minor,major;
	UWORD	flags;
	UBYTE	processor;
	UBYTE	master_pic;
	UBYTE	slave_pic;
} DPMI_VER;

typedef struct _dpmi_freemem_info_ {
  ULONG largest_block;
  ULONG reserved[11];
} DPMI_FREEMEM_INFO;

typedef ULONG DPMI_MEM_HANDLE;

#ifdef __cplusplus
extern "C" {
#endif

/* group 0 */
int	dpmi_alloc_descriptors(SELECTOR *,UWORD);
int	dpmi_free_selector(SELECTOR);
int	dpmi_get_sel_increment(ULONG *);
int     dpmi_get_sel_base(ULONG *, SELECTOR);
int	dpmi_set_sel_base(SELECTOR, ULONG);
int	dpmi_get_sel_limit(ULONG *, SELECTOR);
int	dpmi_set_sel_limit(SELECTOR, ULONG);
int	dpmi_get_sel_access_rights(UWORD *, SELECTOR);
int	dpmi_set_sel_access_rights(SELECTOR, UWORD);
int	dpmi_get_alias_descriptor(SELECTOR *, SELECTOR);
int	dpmi_set_descriptor(SELECTOR, DESCRIPTOR *);
int	dpmi_get_descriptor(DESCRIPTOR *, SELECTOR);
int	dpmi_set_multiple_descriptors(MULTIPLE_DESCRIPTOR *, UWORD count);
int	dpmi_get_multiple_descriptors(MULTIPLE_DESCRIPTOR *, UWORD count);

/* group 1 */
int	dpmi_alloc_real_memory(SELECTOR *, UWORD *, UWORD);
int	dpmi_dealloc_real_memory(SELECTOR);
int	dpmi_realloc_real_memory(SELECTOR, UWORD);

int	dpmi_arbitrary_copy( SELECTOR, ULONG, SELECTOR, ULONG, ULONG);
int	dpmi_copy_from_ds(SELECTOR,ULONG,void *, ULONG);
int 	dpmi_copy_to_ds(void *, SELECTOR, ULONG, ULONG);

/* group 2 */
int	dpmi_get_real_interrupt(UWORD *, UWORD *, UWORD);
int	dpmi_set_real_interrupt(UWORD,UWORD,UWORD);
int	dpmi_get_protected_except(SELECTOR *, ULONG *, UWORD);
int	dpmi_set_protected_except(UWORD,SELECTOR,ULONG);
int	dpmi_get_protected_interrupt(SELECTOR *, ULONG *, UWORD);
int	dpmi_set_protected_interrupt(UWORD,SELECTOR,ULONG);

/* group 3 */
int	dpmi_simulate_real_interrupt(UWORD, DPMI_REGS *);
int	dpmi_simulate_proc_far_ret_frame(DPMI_REGS *);
int	dpmi_simulate_proc_int_frame(DPMI_REGS *);
int	dpmi_get_real_callback(void *, void *, UWORD *, UWORD *);
int	dpmi_free_real_callback(UWORD, UWORD);
int	dpmi_get_state_save_restore(SELECTOR *, void *, UWORD *, UWORD *, UWORD);
int	dpmi_call_state_save_restore(SELECTOR, void *, void *, UWORD);

/* group 4 */
int	dpmi_get_version(DPMI_VER *);

/* group 5 */
int	dpmi_get_memory_info( DPMI_FREEMEM_INFO *);
int	dpmi_get_memory( ULONG *, DPMI_MEM_HANDLE *, ULONG);		
int	dpmi_free_memory(DPMI_MEM_HANDLE);
int	dpmi_resize_memory( ULONG *, DPMI_MEM_HANDLE *, ULONG);		
int	dpmi_get_memory_params(ULONG *, ULONG *, DPMI_MEM_HANDLE);

/* group 9 */
int	dpmi_enable_virtual_flag(ULONG *);
int	dpmi_disable_virtual_flag(ULONG *);
int	dpmi_return_virtual_flag(ULONG *);

#ifdef __cplusplus
};
#endif

#endif /* __DPMI_H */