	SECTION _TEXT CLASS=CODE USE32
	SECTION _DATA CLASS=DATA USE32
	SECTION _BSS  CLASS=BSS USE32
	SECTION cstartup CLASS=INITDATA USE32
	SECTION crundown CLASS=EXITDATA USE32
	SECTION cppinit  CLASS=CPPDATA USE32
	GROUP DGROUP _DATA _BSS

SECTION _TEXT
;
; Line 9:	{
;
_ComputePhiHash:
	ENTER	08H,00H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
;
; Line 10:	  uint len = pstrlen(string), rv;
;
	PUSH	DWORD [EBP+08H]
	CALL	_pstrlen
	POP	ECX
	MOV	ESI,EAX
;
; Line 11:	  short *pe = len + string;
;
	MOV	EAX,ESI
	SHL	EAX,01H
	ADD	EAX,DWORD [EBP+08H]
	MOV	DWORD [EBP+0FFFFFFF8H],EAX
;
; Line 12:	  const short blank = 0x20;
;
	MOV	WORD [EBP+0FFFFFFFEH],020H
;
; Line 14:	  rv = len | blank;
;
	MOV	EAX,ESI
	MOVSX	ECX,WORD [EBP+0FFFFFFFEH]
	OR	EAX,ECX
	MOV	EBX,EAX
	JMP	L_0
L_2:
;
; Line 16:	    short cback = (*--pe) | blank;
;
	SUB	DWORD [EBP+0FFFFFFF8H],02H
	MOV	EAX,DWORD [EBP+0FFFFFFF8H]
	MOVSX	EAX,WORD [EAX+00H]
	OR	AX,WORD [EBP+0FFFFFFFEH]
	MOV	DI,AX
;
; Line 17:	    rv = (((rv << (16 - 2)) | (rv >> 2)) & 0xffff) ^ cback;
;
	MOV	EAX,EBX
	SHL	EAX,0EH
	MOV	ECX,EBX
	SHR	ECX,02H
	OR	EAX,ECX
	AND	EAX,0FFFFH
	MOVSX	EDI,DI
	XOR	EAX,EDI
	MOV	EBX,EAX
;
; Line 18:	  }
;
L_0:
;
; Line 15:	  while(len--) {
;
	MOV	EAX,ESI
	DEC	ESI
	TEST	EAX,EAX
	JNE	NEAR	L_2
L_1:
;
; Line 19:	  return(rv % size);
;
	MOV	EAX,EBX
	SUB	EDX,EDX
	DIV	DWORD [EBP+0CH]
	XCHG	EAX,EDX
L_3:
	POP	EDI
	POP	ESI
	POP	EBX
	LEAVE
	RET

[GLOBAL	_AddPhiHash]
;
; Line 25:	{
;
_AddPhiHash:
	ENTER	040H,00H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+0CH]
;
; Line 26:		int size = *(((uint *)table)-1);
;
	MOV	EAX,DWORD [EBP+08H]
	SUB	EAX,04H
	MOV	EAX,DWORD [EAX+00H]
	MOV	DWORD [EBP+0FFFFFFC0H],EAX
;
; Line 31:	  item->link = 0;
;
	MOV	DWORD [ESI+00H],00H
;
; Line 33:		pstrupr(item->key);
;
	PUSH	DWORD [ESI+04H]
	CALL	_pstrupr
	POP	ECX
;
; Line 34:		index = ComputePhiHash(item->key,size);
;
	PUSH	DWORD [EBP+0FFFFFFC0H]
	PUSH	DWORD [ESI+04H]
	CALL	_ComputePhiHash
	ADD	ESP,08H
	MOV	DWORD [EBP+0FFFFFFC4H],EAX
;
; Line 36:	  if (*(p = &table[index])) {
;
	MOV	EAX,DWORD [EBP+08H]
	MOV	ECX,DWORD [EBP+0FFFFFFC4H]
	SHL	ECX,02H
	ADD	EAX,ECX
	MOV	DWORD [EBP+0FFFFFFFCH],EAX
	TEST	DWORD [EAX+00H],0FFFFFFFFH
	JE	NEAR	L_4
;
; Line 37:	    HASHREC *q = *p,*r = *p;
;
	MOV	EAX,DWORD [EBP+0FFFFFFFCH]
	MOV	EAX,DWORD [EAX+00H]
	MOV	EBX,EAX
	MOV	EAX,DWORD [EBP+0FFFFFFFCH]
	MOV	EAX,DWORD [EAX+00H]
	MOV	EDI,EAX
	JMP	L_6
L_8:
;
; Line 39:				r = q;
;
	MOV	EDI,EBX
;
; Line 40:	      if (!pstrcmp(r->key,item->key))
;
	PUSH	DWORD [ESI+04H]
	PUSH	DWORD [EDI+04H]
	CALL	_pstrcmp
	ADD	ESP,08H
	TEST	EAX,EAX
	JNE	NEAR	L_9
;
; Line 41:					return(r);
;
	MOV	EAX,EDI
	JMP	L_11
L_9:
;
; Line 42:				q = q->link;
;
	MOV	EAX,DWORD [EBX+00H]
	MOV	EBX,EAX
;
; Line 43:			}
;
L_6:
;
; Line 38:	    while (q) {
;
	TEST	EBX,EBX
	JNE	NEAR	L_8
L_7:
;
; Line 44:			r->link = item;
;
	MOV	DWORD [EDI+00H],ESI
;
; Line 45:	  }
;
	JMP	L_5
L_4:
;
; Line 47:	    *p = item;
;
	MOV	EAX,DWORD [EBP+0FFFFFFFCH]
	MOV	DWORD [EAX+00H],ESI
L_5:
;
; Line 48:	  return(0);
;
	SUB	EAX,EAX
L_11:
	POP	EDI
	POP	ESI
	POP	EBX
	LEAVE
	RET

[GLOBAL	_LookupPhiHash]
;
; Line 54:	{
;
_LookupPhiHash:
	ENTER	03CH,00H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	EBX,DWORD [EBP+0CH]
;
; Line 55:		int size = *(((uint *)table)-1);
;
	MOV	EAX,DWORD [EBP+08H]
	SUB	EAX,04H
	MOV	EAX,DWORD [EAX+00H]
	MOV	DWORD [EBP+0FFFFFFC4H],EAX
;
; Line 59:		strcpy(buf,key);
;
	PUSH	EBX
	LEA	EAX,[EBP+0FFFFFFCEH]
	PUSH	EAX
	CALL	_strcpy
	ADD	ESP,08H
;
; Line 60:		pstrupr(key);
;
	PUSH	EBX
	CALL	_pstrupr
	POP	ECX
;
; Line 61:	  index = ComputePhiHash(key,size);
;
	PUSH	DWORD [EBP+0FFFFFFC4H]
	PUSH	EBX
	CALL	_ComputePhiHash
	ADD	ESP,08H
	MOV	DWORD [EBP+0FFFFFFC8H],EAX
;
; Line 63:	  if (*(p = &table[index])) {
;
	MOV	EAX,DWORD [EBP+08H]
	MOV	ECX,DWORD [EBP+0FFFFFFC8H]
	SHL	ECX,02H
	ADD	EAX,ECX
	MOV	EDI,EAX
	TEST	DWORD [EAX+00H],0FFFFFFFFH
	JE	NEAR	L_12
;
; Line 64:	    HASHREC *q= *p;
;
	MOV	EAX,DWORD [EDI+00H]
	MOV	ESI,EAX
	JMP	L_14
L_16:
;
; Line 66:	      if (!pstrcmp(q->key, key))
;
	PUSH	EBX
	PUSH	DWORD [ESI+04H]
	CALL	_pstrcmp
	ADD	ESP,08H
	TEST	EAX,EAX
	JNE	NEAR	L_17
;
; Line 67:					return(p);
;
	MOV	EAX,EDI
	JMP	L_19
L_17:
;
; Line 68:				p = *p;
;
	MOV	EAX,DWORD [EDI+00H]
	MOV	EDI,EAX
;
; Line 69:				q=q->link;
;
	MOV	EAX,DWORD [ESI+00H]
	MOV	ESI,EAX
;
; Line 70:			}
;
L_14:
;
; Line 65:	    while (q) {
;
	TEST	ESI,ESI
	JNE	NEAR	L_16
L_15:
;
; Line 71:		}
;
L_12:
;
; Line 72:		return(0);
;
	SUB	EAX,EAX
L_19:
	POP	EDI
	POP	ESI
	POP	EBX
	LEAVE
	RET

[GLOBAL	_CreateHashTable]
;
; Line 78:	{
;
_CreateHashTable:
	ENTER	00H,00H
	PUSH	EBX
	PUSH	ESI
	MOV	ESI,DWORD [EBP+08H]
;
; Line 79:	  uint * rv = (uint *)AllocateMemory(size * sizeof(HASHREC *) + sizeof(uint));
;
	MOV	EAX,ESI
	SAL	EAX,02H
	ADD	EAX,04H
	PUSH	EAX
	CALL	_AllocateMemory
	POP	ECX
	MOV	EBX,EAX
;
; Line 80:		*rv++ = size;
;
	MOV	EAX,EBX
	ADD	EBX,04H
	MOV	DWORD [EAX+00H],ESI
;
; Line 81:	  memset(rv,0,size * sizeof(HASHREC *));
;
	MOV	EAX,ESI
	SAL	EAX,02H
	PUSH	EAX
	PUSH	DWORD 00H
	PUSH	EBX
	CALL	_memset
	ADD	ESP,0CH
;
; Line 82:	  return((HASHREC **)rv);
;
	MOV	EAX,EBX
L_20:
	POP	ESI
	POP	EBX
	LEAVE
	RET

[GLOBAL	_RemoveHashTable]
;
; Line 88:	{
;
_RemoveHashTable:
	ENTER	00H,00H
;
; Line 89:	  DeallocateMemory(((uint *)t)-1);
;
	MOV	EAX,DWORD [EBP+08H]
	SUB	EAX,04H
	PUSH	EAX
	CALL	_DeallocateMemory
	POP	ECX
;
; Line 90:	}
;
	LEAVE
	RET



SECTION _TEXT
[EXTERN	_strcpy]
[EXTERN	_AllocateMemory]
[EXTERN	_DeallocateMemory]
[EXTERN	_pstrcmp]
[EXTERN	_pstrupr]
[EXTERN	_memset]
[EXTERN	_pstrlen]
