#include <stdio.h>
#include "utype.h"
#include "interp.h"
#include "allocate.h"
#include "umem.h"
#include "phash.h"

static uint ComputePhiHash(short *string,int size)
{
  uint len = pstrlen(string), rv;
  short *pe = len + string;
  const short blank = 0x20;

  rv = len | blank;
  while(len--) {
    short cback = (*--pe) | blank;
    rv = ROTR(rv,2) ^ cback;
  }
  return(rv % size);
}
/*
 * Add an entry to the hash table.  Return previous entry if it exists
 */
HASHREC *AddPhiHash(HASHREC **table, HASHREC *item)
{
	int size = *(((uint *)table)-1);
  int index ;
	char buf[50];
  HASHREC **p;

  item->link = 0;

	pstrupr(item->key);
	index = ComputePhiHash(item->key,size);

  if (*(p = &table[index])) {
    HASHREC *q = *p,*r = *p;
    while (q) {
			r = q;
      if (!pstrcmp(r->key,item->key))
				return(r);
			q = q->link;
		}
		r->link = item;
  }
  else
    *p = item;
  return(0);
}
/*
 * Find something in the hash table
 */
HASHREC **LookupPhiHash(HASHREC **table, char *key)
{
	int size = *(((uint *)table)-1);
  uint index;
  HASHREC **p;
	char buf[50];
	strcpy(buf,key);
	pstrupr(key);
  index = ComputePhiHash(key,size);

  if (*(p = &table[index])) {
    HASHREC *q= *p;
    while (q) {
      if (!pstrcmp(q->key, key))
				return(p);
			p = *p;
			q=q->link;
		}
	}
	return(0);
}
/*
 * Create a hash table
 */
HASHREC **CreateHashTable(int size)
{
  uint * rv = (uint *)AllocateMemory(size * sizeof(HASHREC *) + sizeof(uint));
	*rv++ = size;
  memset(rv,0,size * sizeof(HASHREC *));
  return((HASHREC **)rv);
}
/* 
 * Delete a hash table
 */
void RemoveHashTable(HASHREC ** t)
{
  DeallocateMemory(((uint *)t)-1);
}