
# Makefile for W. J. Cody's tests of elementary complex functions
# transliterated from Fortran to C language.
# Fixes comprised proper naming of functions under test (e.g. FSIN for SIN)
# and revision of the test for `-FSQRT' in tcsqrt.c.

CC = gcc
CFLAGS = -g -Wall

INCS = celefunt.h complex.h stubs.o

# libmc.a is the complex function library under test.
# stubs.o is compiled with the machine parameter settings in mconf.h
LIBS = stubs.o libmc.a -lm

all: tcabs tcexp tclog tcpow tcsin tcsqrt

check: all
	-tcabs > tcabs.log
	-tcexp > tcexp.log
	-tclog > tclog.log
	-tcpow > tcpow.log
	-tcsin > tcsin.log
	-tcsqrt > tcsqrt.log

tcsqrt: tcsqrt.o $(INCS)
	$(CC) -o tcsqrt tcsqrt.o $(LIBS)

tcsin: tcsin.o $(INCS)
	$(CC) -o tcsin tcsin.o $(LIBS)

tcpow: tcpow.o $(INCS)
	$(CC) -o tcpow tcpow.o $(LIBS)

tclog: tclog.o $(INCS)
	$(CC) -o tclog tclog.o $(LIBS)

tcexp: tcexp.o $(INCS)
	$(CC) -o tcexp tcexp.o $(LIBS)

tcabs: tcabs.o $(INCS)
	$(CC) -o tcabs tcabs.o $(LIBS)

stubs.o: stubs.c
	$(CC) $(CFLAGS) -I. -c stubs.c

tcabs.o: tcabs.c tablat.c $(INCS)
tcexp.o: tcexp.c tablat.c $(INCS)
tclog.o: tclog.c tablat.c $(INCS)
tcpow.o: tcpow.c tablat.c $(INCS)
tcsin.o: tcsin.c tablat.c $(INCS)
tcsqrt.o: tcsqrt.c tablat.c $(INCS)

clean:
	rm -f tcabs
	rm -f tcexp
	rm -f tclog
	rm -f tcpow
	rm -f tcsin
	rm -f tcsqrt
	rm -f *.o
	rm -f *.exe
	rm -f *.log
