/*	qellpk.c		*/

#include "qhead.h"
extern QELT qone[], qzero[], qpi[];

int qellpk(x,y)
QELT *x, *y;
{
QELT a[NQ], b[NQ], c[NQ], temp[NQ];

if( qcmp( x, qone ) > 0 || qcmp( x, qzero ) <= 0 )
	{
	mtherr( "qellpk", DOMAIN );
	return(0);
	}
qsub( x, qone, temp );
qsqrt( temp, c );		/* c = sqrt(x)		*/
/*qsub( temp, qone, b );*/	/* b = sqrt( 1 - x )	*/
qsqrt( x, b );
qmov( qone, a );	/* a = 1	*/

while( ((int) a[1] - (int) c[1]) < (NBITS/2) )
	{
	qsub( b, a, c );	/* c = (a - b)/2.0	*/
	c[1] -= 1;
	qmul( a, b, temp );	/* temp = sqrt( a * b )	*/
	qsqrt( temp, temp );
	qadd( a, b, a );	/* a = (a + b)/2.0	*/
	a[1] -= 1;
	qmov( temp, b );	/* b = temp		*/
	}

qmov( qpi, temp );	/* get pi/2	*/
temp[1] -= 1;
qdiv( a, temp, y );
return(0);
}
