/*							qi1.c		*/
/* modified Bessel function check routine */
#include "qhead.h"
extern QELT qone[];

int qi1( x, y )
QELT *x, *y;
{
QELT a[NQ], k[NQ], kp1[NQ], x2[NQ];

qmov( qone, y );
qmov( qone, k );
qmov( qone, a );
qmov( x, x2 );
x2[1] -= 1;
qmul( x2, x2, x2 );	/* (x/2)**2  */

/* test for convergence to 64 bits */

/* direct series summation */
while( ((int) y[1] - (int) a[1]) < (NBITS/2) )
	{
	qadd( qone, k, kp1 );	/*	kp1 = k + 1	*/
	qdiv( k, a, a );
	qdiv( kp1, a, a );
	qmul( x2, a, a );
	qadd( y, a, y );
	qmov( kp1, k );
	}

qmul( x, y, y );
y[1] -= 1;
return 0;
}
