/*							qincg.c	*/
/*	Check routine for incomplete gamma integral */
/*	SLM, 22 Jan 84	*/

#include "qhead.h"

/* incgam.c
 *
 * incomplete gamma integral
 *
 *
 *          inf.
 *           -
 *   -      |   -t  a-1
 *  | (a)   |  e   t   dt  =  incgam(a,x)
 *          |
 *         -
 *          x
 *
 *
 */

extern QELT qone[], qtwo[];
static QELT ans[NQ], c[NQ], yc[NQ], ax[NQ], z[NQ];
static QELT pk[NQ], pkm1[NQ], pkm2[NQ], qk[NQ], qkm1[NQ], qkm2[NQ];
static QELT r[NQ], t[NQ], stop[NQ];
int qlgam();

int qincg( a, x, y )
QELT *a, *x, *y;
{

if( (x[0] != 0) || ( a[0] != 0) || (x[1] == 0) || (a[1] == 0) )
	return( -1 );

/*  Summation stops when last term/sum < stop	*/
qmov( qone, stop );
stop[1] -= 80;	/* stop = 1e-24 */
/* 	ax = exp( a * log(x) - x - lgam(a) ); */
qlog( x, ax );
qmul( a, ax, ax );
qsub( x, ax, ax );
qlgam( a, c );
qsub( c, ax, c );
qexp( c, ax );

qsub( a, x, z);		/* z = x - a; */

/*							qincg.c 2	*/

if( (x[1] > (QELT) (EXPONE-1)) && (z[0] == 0 ) )

/* continued fraction */
	{
	qsub( a, qone, y); 	/* y = 1.0 - a; */
	qadd( x, y, z );
	qadd( qone, z, z);	/* z = x + y + 1.0; */
	qmov( qone, c );
	c[1] = 0;
	c[3] = 0;		/* c = 0.0; */
	qmov( qone, pkm2 );	/* pkm2 = 1.0; */
	qmov( x, qkm2 );	/* qkm2 = x; */
	qadd( x, qone, pkm1);	/* pkm1 = x + 1.0; */
	qmul( z, x, qkm1);	/* qkm1 = z * x; */
	qdiv( qkm1, pkm1, ans);	/* ans = pkm1/qkm1; */

	do
		{
		qadd( qone, c, c);		/* c += 1.0; */
		qadd( qone, y, y);		/* y += 1.0; */
		qadd( qtwo, z, z);		/* z += 2.0; */
		qmul( y, c, yc );		/* yc = y * c; */
		qmul( pkm2, yc, r);
		qmul( pkm1, z, pk);
		qsub( r, pk, pk );	/* pk = pkm1 * z  -  pkm2 * yc; */
		qmul( qkm2, yc, r );
		qmul( qkm1, z, qk );
		qsub( r, qk, qk );	/* qk = qkm1 * z  -  qkm2 * yc; */
		if( qk[1] > 0 )
			{
			qdiv( qk, pk, r );	/* r = pk/qk; */
			qsub( r, ans, t );
			qdiv( r, t, t );
			t[0] = 0;		/* t = abs( (ans - r)/r ); */
			qmov( r, ans );		/* ans = r; */
			}
		else
			qmov( qone, t );		/* t = 1.0; */

		qmov( pkm1, pkm2 );		/* pkm2 = pkm1; */
		qmov( pk, pkm1 );		/* pkm1 = pk; */
		qmov( qkm1, qkm2 );		/* qkm2 = qkm1; */
		qmov( qk, qkm1 );		/* qkm1 = qk; */
		qsub( stop, t, t );
		}
	while( t[0] == 0 );	/* while( t > stop ); */

	qmul( ax, ans, y );
	return( 0 );		/* return( ans * ax ); */
	}

/*							qincg.c 3	*/

/* power series */
else
	{
	qmov( a, r );		/* r = a; */
	qmov( qone, c );		/* c = 1.0; */
	qmov( qone, ans );	/* ans = 1.0; */

	do
		{
		qadd( qone, r, r );		/* r += 1.0; */
		qdiv( r, x, z );
		qmul( z, c, c );		/* c *= x/r; */
		qadd( c, ans, ans );		/* ans += c; */
		qdiv( ans, c, t );
		t[0] = 0;
		qsub( stop, t, t );
		}
	while( t[0] == 0);	/* while( c/ans > stop ); */

	qdiv( a, ax, z );
	qmul( z, ans, z );
	qsub( z, qone, y );
	return( 0 );		/* return( 1.0 - (ans * ax/a) ); */
	}
}
