/*						qlog1.c	*/
/* natural logarithm of 1 + x */

#include "qhead.h"

extern QELT qone[], qtwo[], qlog2[];
static QELT xx[NQ] = {0};
static QELT z[NQ] = {0};
static QELT a[NQ] = {0};
static QELT b[NQ] = {0};
static QELT qj[NQ] = {0};

int qlog1( x, y )
QELT *x, *y;
{
long i, j, nsq;

/* range reduction: log x = log( 2**ex * m ) = ex * log2 + log m */

qmov(x, xx );
qmov( qone, b );
b[1] += 1;
qadd( b, xx, b );
qdiv( b, xx, y );	/* store x/(x+2) in y */

qmul( y, y, z );

i = NBITS*5/18;		/* 40 for 144 bits */
j = 2 * i + 1;
ltoq( &j, b );		/* 2 * i + 1 */
qmov( b, qj );

while( j > 1 )
	{
	nsq = i * i;
	ltoq( &nsq, a );	/* i**2			*/
	qmuli( a, z, a );	/* i**2 * x**2		*/
	qdiv( b, a, b );	/* i**2 * x**2 / (2*i+1) */
	j -= 2;
	i -= 1;
/*	ltoq( &j, a );	*/
	qsub( qtwo, qj, qj );	/* 2 * i + 1		*/
	qsub( b, qj, b );
	}

qdiv( b, y, y );
*(y+1) += 1;
/* now add log of 2**ex */
/*
ltoq( &ex, b );
qmul( qlog2, b, b );
qadd( b, y, y );
*/
return 0;
}
