/*  qprob.c  */
/* various probability integrals
 * based on beta and gamma integral
 */

#include "qhead.h"
extern QELT qone[];
int qigam(), qigamc(), qigami(), qincbi(), qincb();

/* binomial distribution */

int qbdtr( k, n, p, y )
int k, n;
QELT p[], y[];
{
QELT dk[NQ], dn[NQ], dp[NQ];
long li;

if( k >= n )
	{
	qmov( qone, y );
	return 0;
	}

li = k + 1;
ltoq( &li, dk );	/* dk = k */

li = n - k;
ltoq( &li, dn );

qmov( p, dp );
qsub( dp, qone, dp );

qincb( dn, dk, dp, y );
return 0;
}


int qbdtrc( k, n, p, y )
int k, n;
QELT p[], y[];
{
QELT dk[NQ], dn[NQ];
long li;

if( k < 0 )
	{
	qmov( qone, y );
	return 0;
	}
if( k == n )
	{
	qclear( y );
	return 0;
	}
li = k + 1;
ltoq( &li, dk );	/* dk = k */

li = n - k;
ltoq( &li, dn );

qincb( dk, dn, p, y );
return 0;
}


/* Inverse binomial distribution */
int qbdtri( k, n, y, p )
int k, n;
QELT p[], y[];
{
QELT dk[NQ], dn[NQ];
long li;


if( (n <= k) || (k < 0) )
	{
	qclear( y );
	return 0;
	}
li = k + 1;
ltoq( &li, dk );	/* dk = k */

li = n - k;
ltoq( &li, dn );

qincbi( dn, dk, y, p );
qsub( p, qone, p );
return 0;
}




/* chi-square distribution */

int qchdtr( df, x, y )
QELT df[], x[], y[];
{
QELT a[NQ], b[NQ];

qmov( df, a );
qmov( x, b );
a[1] -= 1;
b[1] -= 1;
qigam( a, b, y );
return 0;
}

int qchdtc( df, x, y )
QELT df[], x[], y[];
{
QELT a[NQ], b[NQ];

qmov( df, a );
qmov( x, b );
a[1] -= 1;
b[1] -= 1;
qigamc( a, b, y );
return 0;
}



/* Inverse of complemented Chi-square distribution */
int qchdti( df, y, x )
QELT df[], x[], y[];
{
QELT a[NQ];

qmov( df, a );
a[1] -= 1;
qigami( a, y, x );
x[1] += 1;
return 0;
}




/*	F distribution */

int qfdtr( ia, ib, x, y )
int ia, ib;
QELT x[], y[];
{
QELT a[NQ], b[NQ], u[NQ], v[NQ], w[NQ];
long li;

li = ia;
ltoq( &li, a );
li = ib;
ltoq( &li, b );

qmov( a, w );		/* ax/(b+ax)  */
qmul( x, w, w );
qadd( b, w, u );
qdiv( u, w, w );
qmov( a, u );
u[1] -= 1;
qmov( b, v );
v[1] -= 1;
qincb( u, v, w, y ); /* incbet( a/2.0, b/2.0, (ax/(b+ax)) )  */
return 0;
}




int qfdtrc( ia, ib, x, y )
int ia, ib;
QELT x[], y[];
{
QELT a[NQ], b[NQ], u[NQ], v[NQ], w[NQ];
long li;

li = ia;
ltoq( &li, a );
li = ib;
ltoq( &li, b );

/* b/(b + ax)  */
qmov( a, u );
qmul( x, u, u );
qadd( b, u, u );
qdiv( u, b, w );

qmov( a, u );
u[1] -= 1;
qmov( b, v );
v[1] -= 1;
qincb( v, u, w, y ); /* incbet( b/2.0, a/2.0, (b/(b+ax)) )  */
return 0;
}


/* Inverse of complemented F distribution */
int qfdtri( ia, ib, y, x )
int ia, ib;
QELT x[], y[];
{
QELT a[NQ], b[NQ], u[NQ], v[NQ], w[NQ];
long li;

li = ia;
ltoq( &li, a );
li = ib;
ltoq( &li, b );

qmov( a, u );
u[1] -= 1;
qmov( b, v );
v[1] -= 1;
qincbi( v, u, y, w ); /* incbi( b/2.0, a/2.0, y )  */

/* x = (b - bw)/aw  */
qmul( b, w, u );
qsub( u, b, u );
qmul( a, w, v );
qdiv( v, u, x );
return 0;
}



/* gamma distribution */

int qgdtr( a, b, x, y )
QELT a[], b[], x[], y[];
{
QELT w[NQ];

qmul( a, x, w );
qigam( b, w, y );  /* igam( b, a * x )  */
return 0;
}

int qgdtrc( a, b, x, y )
QELT a[], b[], x[], y[];
{
QELT w[NQ];

qmul( a, x, w );
qigamc( b, w, y );  /* igamc( b, a * x )  */
return 0;
}




/* negative binomial distribution */

int qnbdtr( k, n, p, y )
int k, n;
QELT p[], y[];
{
QELT dk[NQ], dn[NQ];
long li;

if( k == 0 )
	{
	qmov( qone, y );
	return 0;
	}

li = k + 1;
ltoq( &li, dk );

li = n;
ltoq( &li, dn );

qincb( dn, dk, p, y );
return 0;
}

int qnbdtc( k, n, p, y )
int k, n;
QELT p[], y[];
{
QELT dk[NQ], dn[NQ], w[NQ];
long li;

if( k == 0 )
	{
	qmov( qone, y );
	return 0;
	}

li = k + 1;
ltoq( &li, dk );

li = n;
ltoq( &li, dn );

qsub( p, qone, w );
qincb( dk, dn, w, y );
return 0;
}



/* Poisson distribution */

int qpdtr( k, m, y )
int k;
QELT m[], y[];
{
QELT v[NQ];
long li;


li= k+1;
ltoq( &li, v );

qigamc( v, m, y );  /* igamc( k+1, m ) */
return 0;
}

int qpdtrc( k, m, y )
int k;
QELT m[], y[];
{
QELT v[NQ];
long li;


li= k+1;
ltoq( &li, v );

qigam( v, m, y );  /* igam( k+1, m ) */
return 0;
}


/* Inverse Poisson distribution */
int qpdtri( k, y, m )
int k;
QELT m[], y[];
{
QELT v[NQ];
long li;


li= k+1;
ltoq( &li, v );

qigami( v, y, m );
return 0;
}

