/*							qshici.c	*/
/* Hyperbolic Sine and cosine integrals */
#include "qhead.h"
extern QELT qeul[];
extern QELT qone[], qtwo[], qpi[];

int qshici( x, si, ci )
QELT x[], si[], ci[];
{
QELT k[NQ], z[NQ], t[NQ], a[NQ];
int sign;
double dx;

qtoe( x, (unsigned short *) &dx );
if( dx > 87.0 )
	goto asymp;

if( x[0] != 0 )
	{
	sign = -1;
	x[0] = 0;
	}
else
	sign = 0;

if( x[1] < 3 )
	{
	qclear( si );
	ci[0] = -1;
	qinfin(ci);
	return( 0 );
	}


qmul( x, x, z );	/* z = -x * x		*/
/*z[0] = -1;*/
qmov( qone, a );	/* a = 1.0		*/
qmov( qone, t );	/* t = 1.0		*/
qmov( qone, si );	/* si = 1.0		*/
qclear( ci );		/* ci = 0.0		*/
qmov( qtwo, k );	/* k = 2.0		*/

/*							qsici.c 2	*/

do
	{
	qdiv( k, z, t );	/* a *= z/k	*/
	qmul( t, a, a );
	qdiv( k, a, t );	/* ci += a/k	*/
	qadd( ci, t, ci );
	qadd( k, qone, k );	/* k += 1.0	*/

	qdiv( k, a, a );	/* a /= k	*/
	qdiv( k, a, t );	/* si += a/k	*/
	qadd( si, t, si );
	qadd( k, qone, k );	/* k += 1.0	*/
	}
while( ((int) si[1] - (int) a[1]) < NBITS/2 );

qmul( si, x, si );	/* si *= x		*/

if( sign )
	si[0] = -1;

/* ci = EUL + log(x) + ci */

/* comment out the following to leave with ci = Chin(x): */
qlog( x, t );
qadd( ci, t, ci );
qadd( qeul, ci, ci );
return 0;


asymp:

qdiv( x, qone, z );
qmov( qone, t );
qmov( qone, k );
qmov( qone, a );
do
	{
	qmul( z, a, a );
	qmul( k, a, a );
	qadd( a, t, t );
	qadd( k, qone, k );
	}
while( ((int) qone[1] - (int) a[1]) < 119 );

qexp( x, k );
qmul( t, k, si );
qdiv( x, si, si );
si[1] -= 1;
return 0;
}
