/********* Listing 1 ********************** ARRAY.H ******
 * ARRAY.H : Declarations for dynamic array system in C  
 * by Bruce Eckel. (c) C Gazette. Use freely but acknowledge
 * authorship and publication    
 ********************************************************/

#include <stdlib.h>

typedef struct s {
  int size;   /* remember how big it is */
  int* vec;  /* pointer to the actual data */
} dynamic_array;


/* Call to initialize a dynamic array on the stack: */
void create_array(dynamic_array* da, size_t sz);

/* call to clean up a dynamic array on the stack: */
void free_array(dynamic_array* da);

/* Special function to call when creating a dynamic array on the heap: */
dynamic_array* make_heap_array(size_t sz);

/* Special function to call when releasing a dynamic array from the heap: */
void release_heap_array(dynamic_array* da);

/* function to select a value in the array: */
int* value(dynamic_array* da, int index);