/****************************************************************************/
/*																																					*/
/* START.C   																																*/
/*																																					*/
/* This little program shows how easy it is to begin using EnCom!  If you   */
/* have ANSI.SYS loaded, this program becomes a nice ANSI terminal -- and   */
/* all in only a few lines of code!                                         */
/*																																					*/
/****************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include "encom.h"

PORT Port;

/*********/
/* ~main */
/*       *********************************************************************/
/*****************************************************************************/
main( int argc, char *argv[] )
{
	int port = COM1;
	long baud = 2400L;
	int c, end_flag = 0, echo = 0;

	if( argc >= 2 )
	{
		switch(argv[1][0])
		{
			case '1': port = COM1; break;
			case '2': port = COM2; break;
			case '3': port = COM3; break;
			case '4': port = COM4; break;
		}
	}
	if( argc >= 3 )
		baud = atol(argv[2]);
	if( com_port_create(port, baud,'N',8,1, 2048, 2048, &Port) < 0 )
	{
		printf("Cannot create COM port");
		return(0);
	}
	init_clock(0x3333);
	init_ctrlc_hdlr();
	printf("\r\nESC to quit - Ctrl-E to toggle Echo\r\n");
	printf("To use another port, type: start [1-4] [baud_rate]\r\n");
	printf("If ansi.sys is loaded, this will work as an ANSI terminal\r\n");
	com_232_ctrl(ON, DTR | RTS | OUT2, &Port);
	while( !end_flag )
	{
		if( (c = com_getc(&Port)) != -1 )								/* get any characters		*/
			putchar(c);
		if( kbhit() )
		{
			switch(c = getch())														/* get the character		*/
			{
				case 27: end_flag = 1; break;								/* esc to quit    			*/
				case  5: echo = !echo; break;								/* ctrl-e is echo 			*/
				case 30:																		/* translate ctrl-c			*/
					if ( echo )
						putchar(3);
					com_putc(3, &Port);
					break;
				default:
					if( echo )
						putchar(c);
					com_putc(c, &Port);
					break;
			}
		}
	}
	end_clock();
	end_ctrlc_hdlr();
	com_port_destroy(&Port);
	return(1);
}
/*** end of main ***/

/**** END OF FILE ****/
