
/* vga.c   EOUE Project, 1997 by Michael Mangelsdorf     */
/* THIS FILE IS PUBLIC DOMAIN.
   LEAVE THIS MESSAGE IN PLACE AS COURTESY TO THE AUTHOR */


#include <stdio.h>
#include <dos.h>

typedef unsigned char  byte;

byte *font8x8ptr, *font8x16ptr, /* Pointer to VGA-ROM font */
     *scrollbuf;  /* Base of region holding 20 pixel high, 320 wide
			   lines temporarily when they are scrolled off
			   the screen. Up to five such lines. */

unsigned scroll_ptr; /* Indexes one of 5 lines in scrollbuf. */

unsigned x,y,       /* Global for plot() etc. */
	 wpage;     /* working page */
byte c;             /* current colour value */
byte pal [256][3];  /* Keeps a copy of original palette. */
byte vpage;         /* visible page */



/* Call this before VGA register manipulations to avoid flicker.
   Operations take place during invisible electron beam flyback.
*/
void wait4VRetrace (void)
{
   while (inportb(0x3DA)&8);
   while (!inportb(0x3DA)&8);
}


/* Get and store pointer to VGA 8x8 pixel ASCII font.
*/
void get8x8ptr (void) {
 static unsigned font8x8seg, font8x8off;
  asm {
   push bp
   mov ax,0x1130
   mov bh,3
   int 0x10
   mov [font8x8seg],es
   mov [font8x8off],bp
   pop bp
  }
  font8x8ptr=MK_FP(font8x8seg,font8x8off);
}


/* Get and store pointer to VGA 8x16 pixel ASCII font.
*/
char* get8x16ptr (void) {
 static unsigned font8x16seg, font8x16off;
  asm {
   push bp
   mov ax,0x1130
   mov bh,6
   int 0x10
   mov [font8x16seg],es
   mov [font8x16off],bp
   pop bp
  }
  font8x16ptr=MK_FP(font8x16seg,font8x16off);
}


/* Returns true if VGA detected.
*/
byte hasvga (void) {
union REGS r;
  r.x.ax=0x1A00; int86(0x10,&r,&r);
  if (r.h.al==0x1A) return 1;
   else return 0;
}


/* Pack all palette register values, to be restored when program ends.
*/
void savepal (void) {
 byte p;
 union REGS r; struct SREGS s;
 s.es=FP_SEG(pal);
 r.h.ah=0x10; r.h.al=0x12; r.x.bx=0; r.x.cx=0xFF; r.x.dx=FP_OFF(pal);
 int86x(0x10,&r,&r,&s);
}


/* restore palette
*/
void loadpal (void) {
 union REGS r; struct SREGS s;
 s.es=FP_SEG(pal);
 r.h.ah=0x10; r.h.al=0x17; r.x.bx=0; r.x.cx=0xFF; r.x.dx=FP_OFF(pal);
 int86x(0x10,&r,&r,&s);
}


/* set one palette register, immediate effect on screen
*/
void modifypal (byte palreg, byte red, byte green, byte blue) {
 union REGS r;
 wait4VRetrace();
 r.h.ah=0x10; r.h.al=0x10; r.x.bx=palreg;
 r.h.dh=red; r.h.ch=green; r.h.cl=blue;
 int86(0x10,&r,&r);
}


/* Set screen border colour.
*/
void overscan (byte color) {
 union REGS r;
  wait4VRetrace();
  r.h.ah=0x10; r.h.al=0x01; r.h.bh=color;  /*bh is palette reg */
  int86(0x10,&r,&r);
}


/* Clears the WORKING PAGE (not the visible page) with colour
   in global c!
*/
void ClrScr (void)
{
  asm {
		mov dx,0x03C4
		mov ax,0x0F02
		out dx,ax
		mov ax,[wpage]
		mov cl,4
		shr ax,cl
		add ax,0xA000
		mov es,ax
		xor di,di
		mov al,[c]
		mov ah,[c]
		mov cx,0x7D00
		rep stosw
  }
}


/* Restores text mode.
*/
void set8025c (void) {
 union REGS r;
 loadpal();
  r.h.al=0x03;
  r.h.ah=0x00;
  int86(0x10,&r,&r);
}

/* Plot pixel.
*/
void plot (void)   /* must set global x,y,c, wpage=working page */
{
   asm {
		mov     si, word ptr [y]
		mov     dx,964
		mov     al,2
		out     dx,al
		mov     cl, byte ptr [x]
		and     cl,3
		mov     al,1
		shl     al,cl
		mov     dx,965
		out     dx,al
		mov     bx,si
		mov     cl,6
		shl     bx,cl
		mov     ax,si
		mov     cl,4
		shl     ax,cl
		add     bx,ax
		mov     ax, word ptr [x]
		mov     cl,2
		sar     ax,cl
		add     ax,[wpage]
		add     bx,ax
		mov     ax,0xA000
		mov     es,ax
		mov     al,byte ptr [c]
		mov     byte ptr es:[bx],al
       }
}


/* Read screen pixel
*/
void peekscr (void)   /* must set x,y, wpage=working page */
{                     /* result=c */
   asm {
	   mov   ax,80
	   mul   word ptr [y]
	   mov   si, word ptr [x]
	   mov   cx,si
	   shr   si,1
	   shr   si,1
	   add   si,ax
	   and   cl,3
	   mov   ah,cl
	   mov   al,0x04
	   mov   dx,0x3CE
	   out   dx,ax
	   mov   ax,0x7D00
	   sub   ax,[wpage]
	   mov   cl,4
	   shr   ax,cl
	   add   ax,0xA000
	   mov   es,ax
	   mov   al,es:[si]
	   mov   byte ptr [c], al
       }
}


/* Set the visual page.
*/
void setvpage (byte page)
{
      /* vpage 00h or 7Dh */
      if (page) page=0x7D;
      wait4VRetrace();
      vpage=page;
      asm {
	 mov dx,0x3D4 /*CRT Controller Index Register*/
	 mov al,0x0C   /*select Hi-Start Register */
	 mov ah,[vpage]
	 out dx,ax
      }
      wait4VRetrace();
}


/* Copies the VISUAL PAGE to the WORKING PAGE
*/
void copyscr (void) {
 asm {
   push ds
   mov bx,[wpage]
   mov ax,0x7D00
   sub ax,bx
   mov cl,4
   shr ax,cl
   add ax,0xA000
   mov ds,ax
   mov ax,bx; mov cl,4; shr ax,cl; add ax,0xA000
   mov es,ax

 mov dx,0x3C4
 mov ax,0x0F02
 out dx,ax

 mov dx,0x3CE
 mov al,0x05
 out dx,al
 inc dx
 in al,dx
 and al, 0xFD  /* clear bit 2 */
 or al, 0x01   /* set bit 1 */
 out dx,al

   mov si,0
   mov di,0
   mov cx, 0x7D00
   cld
   rep movsb
   pop ds

 and al,0xFE
 out dx,al
 }
}


/* Make working page visual page, from now on working
   on copy of previous working page, copied through.
*/
void flipscreen (void) {
    wpage=0x7D00-wpage;
    setvpage(0x7D-vpage);
    copyscr();
}


/* Set graphics mode.
*/
byte set320x400 (byte bordercolor, byte bgcolor)
{
  union REGS r;
  if (!hasvga()) return 1;
  savepal();
  wait4VRetrace();
  asm {
		mov ax,0x0013
		int 0x10
		mov dx,0x03C4
		mov ax,0x0604
		out dx,ax
		mov dx,0x03D4
		mov ax,0x0014
		out dx,ax
		mov ax,0x0E317
		out dx,ax
		mov ax,0x4009
		out dx,ax
  }
  overscan (bordercolor);
  c=bgcolor;
  setvpage(0); wpage=0x7D00;
  ClrScr(); flipscreen(); ClrScr();
  get8x8ptr(); get8x16ptr();
}


/* Delete 'count' 320 pixel lines  in working page
   by setting pixel values to colour c!
*/
void linedel (unsigned start, unsigned count) {
static unsigned startoffs, blockoffs;
startoffs=start*80;
blockoffs=count*80;
asm {
		mov dx,0x03C4
		mov ax,0x0F02
		out dx,ax
		mov ax,[wpage]
		mov cl,4
		shr ax,cl
		add ax,0xA000
		mov es,ax
		mov di,[startoffs]
		mov al,[c]
		mov ah,0
		mov cx,[blockoffs]
		cld
		rep stosb
  }
}


/* Copy 'count' 320 pixel lines  from visual page
   into working page.
*/
void copyline (unsigned start, unsigned count) {
static unsigned startoffs, blockoffs;
 startoffs=80*start;
 blockoffs=80*count;
 asm {
   mov bx,[startoffs]
   mov dx,[wpage]
   mov cx,[blockoffs]
   push ds
   push cx
   mov ax,dx
   mov cl,4; shr ax,cl; add ax,0xA000
   mov es,ax
    mov ax,0x7D00
    sub ax,dx
    mov cl,4
    shr ax,cl
    add ax,0xA000
   mov ds,ax

 mov dx,0x3C4
 mov ax,0x0F02
 out dx,ax

  mov dx,0x3CE
  mov al,0x05
  out dx,al
  inc dx
  in al,dx
  and al, 0xFD
  or al, 0x01
  out dx,al

   mov si,bx
   mov di,bx
   pop cx
   cld
   rep movsb
   pop ds

 and al,0xFE
 out dx,al
 }
}


/* Scroll up contents of visual page, resulting screen in working page.
*/
void chunkscroll_up (byte lines) {
 byte i;
 static unsigned blocksize;
  blocksize=80*20*lines;
  asm {
   mov bx, [blocksize];
   mov ax,[wpage]; mov cl,4; shr ax,cl; add ax,0xA000; mov es,ax;
   mov ax,0x7D00; sub ax,[wpage]; mov cl,4; shr ax,cl;
   add ax,0xA000; push ds; mov ds,ax;
   mov cx,0x7D00; sub cx,bx; sub cx,80*20
   mov dx,0x3C4; mov ax,0x0F02; out dx,ax; mov dx,0x3CE; mov al,0x05;
   out dx,al; inc dx; in al,dx; and al, 0xFD; or al, 0x01; out dx,al;
   mov si,bx; mov di,0; cld; rep movsb; pop ds
   and al,0xFE; out dx,al
  }
  linedel (380-lines*20,lines*20);
}


/* Scrolls up lines+discard, keeps 'lines' in buffer.
*/
void chunkscroll_up_keep (byte lines, byte discard) {
 static unsigned j;
 if (!lines++) return;
 if (scroll_ptr+lines>4) return;
 j=0;
    banksw(12);
     for (y=discard*20;y<20*(discard+lines);y++)
      for (x=0;x<320;x++) {
	   peekscr();
	  *(scrollbuf+scroll_ptr*20*320+j++)=c;
      }
  scroll_ptr+=lines;
 chunkscroll_up (lines+discard-1);
}


/* Scrolls down visual page, result in working page.
   Restores lines on top of page from scroll buffer.
*/
void chunkscroll_down_kept (byte lines) {
byte i;
 static unsigned blocksize,j;
  if (!lines++) return;
  blocksize=80*20*lines;
  asm {
   mov bx,[blocksize]; mov dx,[wpage]
   mov ax,0x7D00; sub ax,dx; mov cl,4; shr ax,cl;
   add ax,0xA000; push ds; mov ds,ax;
   mov ax,dx; mov cl,4; shr ax,cl; add ax,0xA000; mov es,ax;
   mov cx,bx
   mov dx,0x3C4; mov ax,0x0F02; out dx,ax; mov dx,0x3CE
   mov al,0x05; out dx,al; inc dx; in al,dx; and al, 0xFD; or al, 0x01
   out dx,al;
   mov si,0x7D00; sub si,cx; mov di,0x7D00; sub di,80*20; mov cx,0x7D00;
   sub cx,bx; sub cx,80*20; std; rep movsb; pop ds; and al,0xFE; out dx,al
  }
    j=0;
    scroll_ptr-=lines;
    for (y=0;y<20*lines;y++)
      for (x=0;x<320;x++) {
	  c= *(scrollbuf+scroll_ptr*20*320+j++);
	  plot();
      }
}



