/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <dos.h>
#include <i86.h>
#include <jlib.h>

#define M_HEIGHT 16
#define M_WIDTH  10

void getbox(int x, int y, int h_len, int v_len,UBYTE *src);
void mouse_setposition(int x,int y);
void draw_mouse (void);
void save_mouse (void);
void restore_mouse (void);
void mouse_handle (int button, int dx, int dy);

static UBYTE __jlib_mouse_data[] =
{
   255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   
   255, 15,  255, 0,   0,   0,   0,   0,   0,   0,    
   255, 15,  15,  255, 0,   0,   0,   0,   0,   0,   
   255, 15,  15,  15,  255, 0,   0,   0,   0,   0,  
   255, 15,  15,  15,  15,  255, 0,   0,   0,   0, 
   255, 15,  15,  15,  15,  15,  255, 0,   0,   0,   
   255, 15,  15,  15,  15,  15,  15,  255, 0,   0,   
   255, 15,  15,  15,  15,  15,  15,  15,  255, 0,   
   255, 15,  15,  15,  15,  15,  15,  15,  15,  255, 
   255, 15,  15,  15,  15,  15,  255, 255, 255, 0,  
   255, 15,  15,  255, 15,  15,  255, 0,   0,   0,  
   255, 15,  255, 0,   255, 15,  15,  255, 0,   0, 
   0,   255, 0,   0,   255, 15,  15,  255, 0,   0, 
   0,   0,   0,   0,   0,   255, 15,  15,  255, 0, 
   0,   0,   0,   0,   0,   255, 15,  15,  255, 0, 
   0,   0,   0,   0,   0,   0,   255, 255, 0,   0, 
};
static int __jlib_mouse_initted= 0;
static int __jlib_mouse_x;
static int __jlib_mouse_y;
static int __jlib_mouse_button;
buffer_rec *__jlib_ms_sv;
buffer_rec *__jlib_ms_blit;
buffer_rec  __jlib_ptr;
static UBYTE __jlib_mouse_showing;


/*+--------------------------------------------------------------------------+ */
/*|check for the presence of a mouse.                                        | */
/*+--------------------------------------------------------------------------+ */
int mouse_present (void)
{
   union REGS r;
      
   if(!__jlib_mouse_initted){
      __jlib_mouse_initted = 1;

      r.x.eax = 0x0000;
      int386 (0x33, &r, &r);

      if(r.x.eax == 0xffff){
         r.x.eax = 7;
         r.x.ecx = 0;
         r.x.edx = (SCREEN_WIDTH-1)*8;
         int386 (0x33, &r, &r);

         r.x.eax = 8;
         r.x.ecx = 0;
         r.x.edx = (SCREEN_HEIGHT-1)*8;
         int386 (0x33, &r, &r);

         r.x.eax = 2;
         int386 (0x33, &r, &r);

         r.x.eax = 15;
         r.x.ecx=r.x.edx=2;
         int386 (0x33, &r, &r);

         __jlib_ms_sv=buff_init(M_WIDTH,M_HEIGHT);
         __jlib_ms_blit=buff_init(M_WIDTH,M_HEIGHT);
         B_X_SIZE(&__jlib_ptr)=M_WIDTH;
         B_Y_SIZE(&__jlib_ptr)=M_HEIGHT;
         B_BUFF_PTR(&__jlib_ptr)=__jlib_mouse_data;

         mouse_setposition(100, 100);

         __jlib_mouse_x = 100;
         __jlib_mouse_y = 100;
         __jlib_mouse_showing = 0;       /* off */
         save_mouse();
         mouse_show_pointer();

         return MOUSE_PRESENT;
      }
   }

   return MOUSE_ABSENT;
}


/*+--------------------------------------------------------------------------+ */
/*|show the pointer                                                          | */
/*+--------------------------------------------------------------------------+ */
void mouse_show_pointer (void)
{
 if((!__jlib_mouse_showing)&&__jlib_mouse_initted){
     mouse_update();
     __jlib_mouse_showing=1;
     save_mouse();
     draw_mouse();
 }
 else{
     mouse_update();
 }
}


/*+--------------------------------------------------------------------------+ */
/*|hide the pointer                                                          | */
/*+--------------------------------------------------------------------------+ */
void mouse_hide_pointer (void)
{
 if(__jlib_mouse_showing&&__jlib_mouse_initted){
     __jlib_mouse_showing=0;
     restore_mouse();
 }
}


/*+--------------------------------------------------------------------------+ */
/*|read pointer coordinates                                                  | */
/*+--------------------------------------------------------------------------+ */
void mouse_get_status (int *x_pos, int *y_pos, int *b_status)
{
   if(__jlib_mouse_initted){
      mouse_update();

      *x_pos = __jlib_mouse_x;
      *y_pos = __jlib_mouse_y;
      *b_status = __jlib_mouse_button;
   }
}


/*+--------------------------------------------------------------------------+ */
/*|change pointer coordinates                                                | */
/*+--------------------------------------------------------------------------+ */
void mouse_set_status (int x, int y)
{
 if(!__jlib_mouse_initted){
    return; /* do nothing */
 }

 if (__jlib_mouse_showing){
     restore_mouse ();
     mouse_setposition (x, y);
     __jlib_mouse_x = x;
     __jlib_mouse_y = y;
     save_mouse ();
     draw_mouse ();
  }
  else{
     mouse_setposition (x, y);
     __jlib_mouse_x = x;
     __jlib_mouse_y = y;
  }
}


/*+--------------------------------------------------------------------------+ */
/*|shut down the mouse                                                       | */
/*+--------------------------------------------------------------------------+ */
void mouse_closedown (void)
{
   if(__jlib_mouse_initted == 0){
      return; /* do nothing */
   }
   mouse_hide_pointer ();
   __jlib_mouse_initted=0;
}


void mouse_update(void)
{
   union REGS r;
   int nx,ny,b_state;

   if(__jlib_mouse_initted){
      r.x.eax = 3;

      int386 (0x33, &r, &r);
      nx = r.w.cx>>3;
      ny = r.w.dx>>3;
      __jlib_mouse_button=r.w.bx;

     if((nx!=__jlib_mouse_x) || (ny!=__jlib_mouse_y)){
        if(__jlib_mouse_showing){
           restore_mouse();
        }
        /* update coords, ensuring they don't get off the screen */
        if(nx > SCREEN_MAX_X){
           __jlib_mouse_x = SCREEN_MAX_X;
        }
        else{
           if(nx < 0){
              __jlib_mouse_x = 0;
           }
           else{
              __jlib_mouse_x = nx;
           }
        }
    
        if(ny > SCREEN_MAX_Y){
          __jlib_mouse_y = SCREEN_MAX_Y;
        }
        else{
          if(ny < 0){
             __jlib_mouse_y = 0;
          }
          else{
            __jlib_mouse_y = ny;
          }
        }
        if(__jlib_mouse_showing){
           save_mouse();
           draw_mouse();
        }

     }
   }
}


void mouse_setposition(int x,int y)
{
 union REGS r;

 r.x.eax = 4;
 r.x.ecx = x*8;
 r.x.edx = y*8;
 int386(0x33, &r, &r);
}

#define X_LEFT   (__jlib_mouse_x)
#define X_RIGHT  (__jlib_mouse_x+M_WIDTH)
#define Y_TOP    (__jlib_mouse_y)
#define Y_BOTTOM (__jlib_mouse_y+M_HEIGHT)


void draw_mouse (void)
{
 buff_stencil_buff_toNC(__jlib_ms_blit,0,0,&__jlib_ptr,0,0,M_WIDTH-1,M_HEIGHT-1);
 screen_blit_buff_to(__jlib_mouse_x,__jlib_mouse_y,__jlib_ms_blit,0,0,M_WIDTH-1,M_HEIGHT-1);
}


void save_mouse (void)
{
   int xlen,ylen;
   
   if (X_RIGHT > SCREEN_MAX_X){
	/* some portion of the right is obscured */
        xlen=SCREEN_MAX_X-__jlib_mouse_x+1;
     }
     else{
          xlen=M_WIDTH;
     }
   if (Y_BOTTOM > SCREEN_MAX_Y){
	/* some portion of the bottom is obscured */
        ylen=SCREEN_MAX_Y-__jlib_mouse_y+1;
     }
    else{
          ylen=M_HEIGHT;
     }
 
   getbox(__jlib_mouse_x,__jlib_mouse_y,xlen,ylen,B_BUFF_PTR(__jlib_ms_sv));

   FAST_SHORT_COPY(B_BUFF_PTR(__jlib_ms_sv),B_BUFF_PTR(__jlib_ms_blit),M_WIDTH*M_HEIGHT);
}


void restore_mouse (void)
{
 screen_blit_buff_to(__jlib_mouse_x,__jlib_mouse_y,__jlib_ms_sv,0,0,M_WIDTH-1,M_HEIGHT-1);
}


void getbox(int x, int y, int h_len, int v_len,UBYTE *src)
{
   UBYTE *dest = (UBYTE *)VIDEO_START;
   int offset,page;

    __cld();

   offset=y*vesa_width+x;
   if(offset==0){
      page=0;
   }
   else{
      page=offset/(vesa_gran1024);
      offset=offset%(vesa_gran1024);
   }
   vesa_set_page(page*vesa_gran_mul);

   for (; v_len != 0; v_len--){
                if (offset + h_len > (vesa_gran1024))
                        if (offset >= (vesa_gran1024)) {
                                page++;
                                vesa_set_page(page*vesa_gran_mul);
                                offset=offset%(vesa_gran1024);
			}
                        else { 
                                FAST_LONG_COPY(dest+offset,src,vesa_gran1024-offset);
                                page++;
                                vesa_set_page(page*vesa_gran_mul);
                                FAST_LONG_COPY(dest,src+vesa_gran1024-offset,
                                        (offset+h_len)%vesa_gran1024);
                                offset = (offset + vesa_width)%vesa_gran1024;
                                src += M_WIDTH;
				continue;
                        }      
                FAST_LONG_COPY((UBYTE *)(VIDEO_START+offset),src, h_len);
                src+=M_WIDTH;
                offset = ((int)offset+vesa_width);
         }
}
     
