/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

/* grabs sprites from a 256 color PCX file */

#include <stdio.h>
#include <jlib.h>

#define QUIT  0
#define GRAB  1
#define OUTLINE 3
#define SCREEN_CLICK 4

/* stuff for menu buttons */
 typedef struct{
	  int x;
	  int y;
	  int width;
	  int height;
	  char   *text;
 }menu_button;

/* some defines to make the buttons friendly in other modes than 320x200 */
#define B_W (SCREEN_WIDTH / 10)
#define B_H (SCREEN_HEIGHT / 10)
#define B_G (SCREEN_HEIGHT / 40)
#define B_ROW (SCREEN_HEIGHT - B_H - 1)

 /* global menu buttons: bad style,  good sense! */
 menu_button B_outline = { SCREEN_WIDTH-(B_W*4)-(3*B_G),B_ROW,B_W*2,B_H,"Outline" };
 menu_button B_grab = {  SCREEN_WIDTH-(B_W*2)-(2*B_G),B_ROW,B_W,B_H,"Grab" };
 menu_button B_quit = { SCREEN_WIDTH-B_W-1,B_ROW,B_W,B_H,"Quit" };

 static int glob_x,glob_y;
 USHORT numspr;
 int firstpt;
 int global_color = 15;
 
void save_sprite(FILE *fp,int x1,int y1,int x2,int y2,buffer_rec *bf);
void draw_button(menu_button *m,buffer_rec *offscreen);
void do_quit(FILE *new);
int get_event(void);


int main(int argc, char *argv[])
{
  int stx=0,sty=0,edx=0,edy=0;
  FILE *new;
  image *pcx_pic;
  buffer_rec *offscreen;
 
#if (MOUSE_AVAILABLE == 0)
     printf("ERROR: No mouse support.\n");
     exit(0);
  }
#else

  if(argc!=3){
	      printf("sprgrab - grab  sprites from a .pcx into a spr file.\n");
	      printf("Usage: sprgrab <infile> <outfile> \n");
	      printf("Where: <infile>  = .pcx file to get sprites from.\n");
	      printf("Where: <outfile> = file to put sprites into.\n");
	      exit(-1);
  }

  offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);

  if(offscreen == NULL){
     printf("ERROR: Out of memory.\n");
     exit(-1);
  }
  
  firstpt=0;
  numspr=0;
  
  pcx_pic = image_load_pcx(argv[1]);

  if(pcx_pic == NULL){
     printf("ERROR: Could not load .pcx image.\n");
     exit(-1);
  }

  if((new=fopen(argv[2],"wb"))==NULL){
     printf(" ERROR: Could not open file %s for writing.",argv[2]);
     exit(-1);
  }

  /* write dummy value into start of .spr file */
  jio_write_elementary_type(new,&numspr,sizeof(USHORT));

 
  /* copy image to buffer */
  buff_blit_img_to(offscreen,0,0,pcx_pic,0,0,IMG_WIDTH(pcx_pic),IMG_HEIGHT(pcx_pic));
  draw_button(&B_quit,offscreen);
  draw_button(&B_grab,offscreen);
  draw_button(&B_outline,offscreen);
  
  screen_set_video_mode();
  screen_set_page(1);
  screen_show_page(1);

  if(!mouse_present()){
     screen_restore_video_mode();
     printf("ERROR: No mouse installed.\n");
     exit(0);
  }

  screen_block_set_pal(IMG_PALETTE(pcx_pic));
  screen_put_pal(global_color,255,255,255);
  
  popup_info("Dont forget -\nOnly the area INSIDE the\nrectangle is saved.",0,global_color);
  
  mouse_hide_pointer();
  
  /* display pcx */
  screen_blit_fs_buffer(offscreen);

  mouse_show_pointer();

  do{
   
   switch(get_event()){
   
   case QUIT:
        do_quit(new);
   
   case GRAB:             
        if(firstpt == 2){
           mouse_hide_pointer();
           global_color+=5;
           draw_button(&B_grab,offscreen);
           screen_blit_fs_buffer(offscreen);
           save_sprite(new,stx,sty,edx,edy,offscreen);
	   numspr++;
	   global_color-=5;
	   draw_button(&B_grab,offscreen);
           screen_blit_fs_buffer(offscreen);
	   mouse_show_pointer();
           
	}
	break;
   	
   case OUTLINE:
       if(firstpt != 0){
          mouse_hide_pointer();
          buff_blit_img_to(offscreen,0,0,pcx_pic,0,0,IMG_WIDTH(pcx_pic),IMG_HEIGHT(pcx_pic));
          draw_button(&B_quit,offscreen);
          draw_button(&B_grab,offscreen);
          draw_button(&B_outline,offscreen);
          screen_blit_fs_buffer(offscreen);
          mouse_show_pointer();
          firstpt=0;
        }
        break;
   
   case SCREEN_CLICK:       
	  if(firstpt == 0){
             stx  = glob_x;
             sty = glob_y;
             mouse_hide_pointer();
             buff_draw_pointNC(offscreen,stx,sty,global_color);
             screen_blit_fs_buffer(offscreen);
             mouse_show_pointer();
             firstpt=1;
             break;
             
          }
          if(firstpt == 1){
             edx  = glob_x;
             edy = glob_y;
             mouse_hide_pointer();
             buff_draw_boxNC(offscreen,stx,sty,edx,edy,global_color);
             screen_blit_fs_buffer(offscreen);
             mouse_show_pointer();
             firstpt=2;
             break;
             
          }
          break;
     
     default:
          break;
   }       
       
  }while(1);

 return 1;
}

void save_sprite(FILE *fp,int x1,int y1,int x2,int y2,buffer_rec *bf)
{
 int i,j;
 UBYTE *start=B_BUFF_PTR(bf);

 if(x1 > x2){
    x2^=x1;
    x1^=x2;      /* swap ends around */
    x2^=x1;
 }

 if(y1 > y2){
    y2^=y1;
    y1^=y2;      /* swap ends around */
    y2^=y1;
 }

 /* skip the lines of the bounding box */
 x1++;
 y1++;
 x2--;
 y2--;

 /* write out and width & height */
 fputc(x2-x1+1,fp);
 fputc(y2-y1+1,fp);

 /* write out data */
 for(i=y1;i<=y2;i++){
     for(j=x1;j<=x2;j++){
	 fputc(start[i*B_X_SIZE(bf)+j],fp);
     }
 }

 /* assume a bounding rectangle of the whole sprite */
 fputc(1,fp); /* one rect */

 fputc(0,fp);
 fputc(0,fp);      /* 0,0 to w,h */
 fputc(x2-x1+1,fp);
 putc(y2-y1+1,fp);

}

/****************************************************************************/
void draw_button(menu_button *m,buffer_rec *offscreen)
{
 buff_draw_boxNC(offscreen,m->x,m->y,m->x+m->width,m->y+m->height,global_color);
 buff_draw_stringNC(offscreen,m->text,m->x+2,m->y+2,global_color);
}

/****************************************************************************/
int is_in_button(int x,int y, menu_button *m)
{
 if((x>m->x)&&(y > m->y)&&(x<(m->x+m->width))&&(y<(m->y+m->height))){
    return 1;
 }
 else{
    return 0;
 }
}


/****************************************************************************/
/* return an event code corresponding to an event */
int get_event(void)
{
 int xpos,ypos,buttons;

 /* this loop waits until a button is pressed */
 do{
   mouse_get_status(&xpos,&ypos,&buttons);
 }while(!(BUTTON_DOWN(buttons)));

 /* this loop waits until the button is released */
 do{
   mouse_get_status(&xpos,&ypos,&buttons);
 }while(BUTTON_DOWN(buttons));

 glob_x = xpos;  
 glob_y = ypos;

 
 /* check the buttons */
 if(is_in_button(xpos,ypos,&B_quit)){
    return QUIT;
 }
 if(is_in_button(xpos,ypos,&B_outline)){
    return OUTLINE;
 }
 if(is_in_button(xpos,ypos,&B_grab)){
    return GRAB;
 }
 

 return SCREEN_CLICK;
}

/****************************************************************************/
/* handle the quit button */
void do_quit(FILE *new)
{
  /* finish up */
  mouse_hide_pointer();
  screen_restore_video_mode();

  fseek(new,0L,SEEK_SET);
  jio_write_elementary_type(new,&numspr,sizeof(USHORT));

  fclose(new);
  exit(0);
}

#endif /* mouse available */
