
 #include "date.h"

 /* ----------------------------------------------------------------------- */

 class timeduration
  {
   private:
     unsigned short days,hours,mins,secs;

     timeduration(unsigned short days, unsigned short hours, unsigned short mins, unsigned short secs);

   public:
     timeduration(float jd);
     timeduration(double jd);
     timeduration(unsigned short hours=0, unsigned short mins=0, unsigned short secs=0);

     bool operator==(const timeduration &td) const;
     bool operator!=(const timeduration &td) const;
     bool operator< (const timeduration &td) const;
     bool operator> (const timeduration &td) const;
     bool operator<=(const timeduration &td) const;
     bool operator>=(const timeduration &td) const;

     timeduration operator+(const timeduration &td) const;
     timeduration operator-(const timeduration &td) const;

     const timeduration &operator+=(const timeduration &td);
     const timeduration &operator-=(const timeduration &td);

     timeduration operator*(const unsigned short tdm) const;
     timeduration operator*(const unsigned int   tdm) const;
     timeduration operator*(const unsigned long  tdm) const;
     timeduration operator/(const unsigned short tdd) const;
     timeduration operator/(const unsigned int   tdd) const;
     timeduration operator/(const unsigned long  tdd) const;

     const timeduration &operator*=(const unsigned short tdm);
     const timeduration &operator*=(const unsigned int   tdm);
     const timeduration &operator*=(const unsigned long  tdm);
     const timeduration &operator/=(const unsigned short tdd);
     const timeduration &operator/=(const unsigned int   tdd);
     const timeduration &operator/=(const unsigned long  tdd);

     unsigned long operator/(const timeduration &td) const;

     unsigned long operator%(const timeduration &td) const;

     unsigned short gethours(void) const;
     unsigned short getmins(void) const;
     unsigned short getsecs(void) const;
     unsigned long getinsecs(void) const;

     // strings
  };


 class dateduration
  {
   // weeks ???

   private:
     unsigned long days;
     unsigned short months,years;

   public:
     dateduration(unsigned long days=0, unsigned short months=0, unsigned short years=0);

     bool operator==(const dateduration &dd) const;
     bool operator!=(const dateduration &dd) const;
     bool operator< (const dateduration &dd) const;
     bool operator> (const dateduration &dd) const;
     bool operator<=(const dateduration &dd) const;
     bool operator>=(const dateduration &dd) const;

     dateduration operator++();
     dateduration operator++(int);
     dateduration operator--();
     dateduration operator--(int);

     dateduration operator+(const dateduration &dd) const;
     dateduration operator-(const dateduration &dd) const;

     const dateduration &operator+=(const dateduration &dd);
     const dateduration &operator-=(const dateduration &dd);

     dateduration operator*(const unsigned short ddm) const;
     dateduration operator*(const unsigned int   ddm) const;
     dateduration operator*(const unsigned long  ddm) const;
     dateduration operator/(const unsigned short ddd) const;
     dateduration operator/(const unsigned int   ddd) const;
     dateduration operator/(const unsigned long  ddd) const;

     const dateduration &operator*=(const unsigned short ddm);
     const dateduration &operator*=(const unsigned int   ddm);
     const dateduration &operator*=(const unsigned long  ddm);
     const dateduration &operator/=(const unsigned short ddd);
     const dateduration &operator/=(const unsigned int   ddd);
     const dateduration &operator/=(const unsigned long  ddd);

     unsigned long operator/(const dateduration &dd) const;

     unsigned long operator%(const dateduration &dd) const;

     unsigned long getdays(void) const;
     unsigned short getmonths(void) const;
     unsigned short getyears(void) const;
     unsigned long getindays(void) const;

     // strings
  };


 class time
  {
   private:
     unsigned short hour,min,sec;
     short zone;

   public:
     time(float jd, short zone = 0);
     time(double jd, short zone = 0);
     time(unsigned short hour=0, unsigned short min=0, unsigned short sec=0, short zone=0);

     bool operator==(time t) const;
     bool operator!=(time t) const;
     bool operator< (time t) const;
     bool operator> (time t) const;
     bool operator<=(time t) const;
     bool operator>=(time t) const;

     timeduration operator-(time t) const;

     time operator+(const timeduration &td) const;
     time operator-(const timeduration &td) const;

     const time &operator+=(const timeduration &td);
     const time &operator-=(const timeduration &td);

     time operator<<(const unsigned short subzone) const;
     time operator>>(const unsigned short addzone) const;

     const time &operator<<=(const unsigned short subzone);
     const time &operator>>=(const unsigned short addzone);

     const time &operator[](const short zone); // t1[-5] = time(18,0,0,+3);

     time operator()(const short zone) const;

     unsigned short gethour(void) const;
     unsigned short getmin(void) const;
     unsigned short getsec(void) const;
     short getzone(void) const;
     float getjd(void) const;

     // country dependend
     // meridian,pos
     // strings
    };


 class date
  {
   private:
     unsigned short day,month;
     int year;

   public:

     // typedef enum{dayerr,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday} Weekdays;

     date(unsigned long jd);
     date(unsigned short day, unsigned short month, int year);

     bool operator==(const date &d) const;
     bool operator!=(const date &d) const;
     bool operator< (const date &d) const;
     bool operator> (const date &d) const;
     bool operator<=(const date &d) const;
     bool operator>=(const date &d) const;

     bool operator==(const Weekdays wd) const;
     bool operator!=(const Weekdays wd) const;
     bool operator< (const Weekdays wd) const;
     bool operator> (const Weekdays wd) const;
     bool operator<=(const Weekdays wd) const;
     bool operator>=(const Weekdays wd) const;

     bool operator!() const;

     dateduration operator-(const date &d) const;

     date operator+(const dateduration &dd) const;
     date operator-(const dateduration &dd) const;

     const date &operator+=(const dateduration &dd);
     const date &operator-=(const dateduration &dd);

     date operator+(const Weekdays wd) const;
     date operator-(const Weekdays wd) const;

     const date &operator+=(const Weekdays wd);
     const date &operator-=(const Weekdays wd);

     date operator++();
     date operator++(int);
     date operator--();
     date operator--(int);

     unsigned short getday(void) const;
     unsigned short getmonth(void) const;
     int getyear(void) const;
     unsigned short getweek(void) const;
     Weekdays getweekday(void) const;
     unsigned long getjd(void) const;
     unsigned long getmjd(void) const;
     unsigned int getscaliger(void) const;
     unsigned short getmoonage(void) const;
     date getmoonphase(const MoonPhases phase) const;

     // days of month
     // days of year
     // (next/last) easter
     // strings
     // country dependend
  };

 /* ----------------------------------------------------------------------- */

 date Easter(const int year);

 /* ----------------------------------------------------------------------- */
