/* Example of use of 3D routines to translate a cube on X and Y axes */
/* Make using 
   make make3dex.mak */
/* Written by Nigel Salt */

#include <3d.h>
#include <graph.h>

double dmatA[4][4];
matrix matA={4,4,&dmatA[0][0]};

double dmatB[4][4];
matrix matB={4,4,&dmatB[0][0]};

double dmatC[4][4];
matrix matC={4,4,&dmatC[0][0]};

double dmatD[4][4];
matrix matD={4,4,&dmatD[0][0]};

double dmatE[4][4];
matrix matE={4,4,&dmatE[0][0]};

double dmatF[4][4];
matrix matF={4,4,&dmatF[0][0]};

double dmatG[4][4];
matrix matG={4,4,&dmatG[0][0]};

double dmatH[4][4];
matrix matH={4,4,&dmatH[0][0]};

double dmatI[4][4];
matrix matI={4,4,&dmatI[0][0]};

double dmatJ[4][4];
matrix matJ={4,4,&dmatJ[0][0]};

double cubep[8][3]=
{
  1,1,1,
  1,1,-1,
  1,-1,-1,
  1,-1,1,
  -1,1,1,
  -1,1,-1,
  -1,-1,-1,
  -1,-1,1
};
int cubel[12][2]=
{
  0,1,
  1,2,
  2,3,
  3,0,
  4,5,
  5,6,
  6,7,
  7,4,
  0,4,
  1,5,
  2,6,
  3,7
};
object cube=
{
  8.0,12.0,&cubep[0][0],&cubel[0][0]
};

double cubep2[8][3];
int cubel2[12][2];
object cube2=
{
  8.0,12.0,&cubep2[0][0],&cubel2[0][0]
};

main()
{
  int i,j,axis;
  double inc;
  char buff[80];
  init3d();
  scale3(&matA,25,25,25);
  objtran(&cube,&matA);
  rot3(&matA,pi/8,2);
  objtran(&cube,&matA);
  rot3(&matA,pi/8,1);
  objtran(&cube,&matA);

  for (j=0;j<4;j++)
    {
    axis=j%2;
    inc=(j<2?1.0:-1.0);
    tran3(&matA,(axis==0?inc:0),(axis==1?inc:0),0);
    _settextposition(30,0);
    sprintf(buff,"%c TRAN",'X'+axis);
    _outtext(buff);
    for (i=0;i<100;i++)
      {
      _setcolor(15);
      objdraw(&cube);
      objcop(&cube,&cube2);
      objtran(&cube,&matA);
      _setcolor(0);
      objdraw(&cube2);
      }
    }
  _setvideomode(_DEFAULTMODE);
}

wait()
{
 _settextposition(30,0);
 _outtext("PRESS KEY");
 getch();
 _clearscreen(_GCLEARSCREEN);
}
