/*
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#if defined __TURBOC__ || defined _MSC_VER || defined __WATCOMC__
#include <io.h>
#ifndef R_OK
#define R_OK    04
#endif
#else
#include <unistd.h>
#endif

#include "mguipp.h"
#include "medit.hpp"

Cmain_shell *Cmain_shell::first;
int Cmain_shell::n_windows;

/*
 *  This is the application class. It must be defined to
 *  provide the pure virtual method start().
 */
class CaMEdit : public CmAppl {
public:
	void start(int, char **);
};

/*
 *  The application instance. Must be defined once to ensure
 *  the CmAppl constructor runs.
 */
CaMEdit appInstance;

/**************************************************
* Access point to the MGUI application
**************************************************/

void CaMEdit::
start(int, char **argv)
{
    enableCustomizing();
    LoadPrefs();
    Cmain_shell *shell = new Cmain_shell(0, argv[1]);
    shell->realize(0, 0);
    mainLoop();
}

/*
 * Convert the name supplied by the user in the command line
 * in the complete pathname and the filename
 */
void 
FilePathName(char *name, char *fname, char *pname)
{
#ifdef UNIX
    if (*name == DIR_SEP)
#else
    if (*name == DIR_SEP || *name == '.' || name[1] == ':')
#endif
	strcpy(pname, name);
    else
	sprintf(pname, "%s%s", MGetCurrentDirectory(), name);
    strcpy(fname, strrchr(pname, DIR_SEP) + 1);
}

Cmain_shell::~Cmain_shell(void)
{
    if (prev)
	prev->next = next;
    if (this == first)
	first = next;
    n_windows--;
}

void Cmain_shell::addAccelerators(void)
{
    new_mi->setAcceleratorKey(C_N, "Ctrl+N");
    open_mi->setAcceleratorKey(C_O, "Ctrl+O");
    load_mi->setAcceleratorKey(C_L, "Ctrl+L");
    insert_file_mi->setAcceleratorKey(C_I, "Ctrl+I");
    save_mi->setAcceleratorKey(C_S, "Ctrl+S");
    write_sel_mi->setAcceleratorKey(C_W, "Ctrl+W");
    print_mi->setAcceleratorKey(C_P, "Ctrl+P");
    goto_mi->setAcceleratorKey(F1, "F1");
    search_mi->setAcceleratorKey(F2, "F2");
    search_next_mi->setAcceleratorKey(F3, "F3");
    search_prev_mi->setAcceleratorKey(F4, "F4");
    replace_mi->setAcceleratorKey(F5, "F5");
    undo_mi->setAcceleratorKey(C_U, "Ctrl+U");
    redo_mi->setAcceleratorKey(C_R, "Ctrl+R");
}

Cmain_shell::Cmain_shell(int, char *fname)
	: CmShell(MEDIT_TITLE, 0)
{
    main_shell = this;
    n_windows++;
    setBackgroundRGB(56, 112, 112);
    createLayout();
    addAccelerators();
    setWMCloseCallback(this, (VOID_CB)&Cmain_shell::quit);
    setWindowOptions();
    filename_l->setText(MEDIT_COPY);
    filename_l->setEventCallback(this, (EVENT_CB)&Cmain_shell::statusLineChangeCB, EM_RESIZE | EM_SET_COLOR);
    if (first)
	first->prev = this;
    next = first;
    first = this;
    prev = 0;
    select_font = 0;
    filename[0] = 0;
    pathname[0] = 0;
    search_text = 0;
    replace_text = 0;
    first_undo = 0;
    curr_undo = 0;
    undo_level = 0;
    read_only = False;
    modified = False;
    ignore_case = False;
    if (fname)
	loadFile(fname);
}

char *Cmain_shell::readFile(char *fname, int *ro)
{
    FILE *fp;
    char str[256];
    char *buff;
    struct stat sb;
    int nread;

    if (stat(fname, &sb) == -1)
    {
	sprintf(str, "Error accessing file:\n%s", fname);
	MMessageDialog("Error", str, " Ok ", NULL);
	return 0;
    }
    if (sb.st_size > (long) INT_MAX)
    {
	MMessageDialog("Sorry", "File is too large !", " Ok ", NULL);
	return 0;
    }
    if ((fp = fopen(fname, "r+")) == NULL)
    {
	if ((fp = fopen(fname, "r")) == NULL)
	{
	    sprintf(str, "Failed to open file:\n%s", fname);
	    MMessageDialog("Error", str, " Ok ", NULL);
	    return 0;
	}
	if (ro)
	    *ro = True;
    }
    else if (ro)
    {
	*ro = False;
    }
    if ((buff = (char *)malloc((int) sb.st_size + 1)) == NULL)
    {
	MMessageDialog("ERROR", "Not Enough Memory,\nSorry", " Ok ", NULL);
    }
    else
    {
	nread = fread(buff, 1, (int) sb.st_size, fp);
	buff[nread] = '\0';
    }
    fclose(fp);
    return buff;
}

void Cmain_shell::loadFile(char *fname)
{
    char *buff;

    buff = readFile(fname, &read_only);
    if (buff == 0)
	return;
    text_mle->setText(buff);
    free(buff);
    FreeUndoList();
    modified = False;
    FilePathName(fname, filename, pathname);
    text_mle->setSensitivity(!read_only);
    modified_l->setText(read_only ? "R" : " ");
    filename_l->setText(pathname);
    setText(filename);
}

