/*
 * This file is part of the M-Edit program (Copyright 1996 by Vincenzo Morello)
 * Permission to use is hereby granted for any purpose.
 */

#if !defined UNIX
#include <sys\stat.h>
#if defined _MSC_VER || defined __WATCOMC__
#include <stdlib.h>
#define MAXPATHLEN	_MAX_PATH
#define MAXFNAMELEN	_MAX_FNAME
#else
#include <dir.h>
#include <values.h>
#ifdef __GO32__
#define MAXPATHLEN	260
#define MAXFNAMELEN	64
#else
#define MAXPATHLEN	MAXPATH
#define MAXFNAMELEN	(MAXFILE+MAXEXT)
#endif
#endif
#define EXT		"*.*"
#else
#include <sys/stat.h>
#define MAXPATHLEN	128
#define MAXFNAMELEN	64
#define EXT		"*"
#endif

#define MEDIT_TITLE	"MEdit 1.9.0"
#define MEDIT_COPY	"Copyright (C) 1996-1998 V. Morello"
#define UNDO_DEPTH	10

// How Many occurences to replace
#define HM_ONE	0
#define HM_SEL	1
#define HM_SOME 2
#define HM_ALL	3

typedef struct _undo_data
{
    char *oldtext;
    char *newtext;
    int start;
    int oldlen;
    int newlen;
    struct _undo_data *next;
    struct _undo_data *prev;
}
UNDO_DATA;

typedef struct
{
    unsigned char font;
    unsigned char bg_r;
    unsigned char bg_g;
    unsigned char bg_b;
    unsigned char fg_r;
    unsigned char fg_g;
    unsigned char fg_b;
}
OBJECT_PREFS;

typedef struct
{
    OBJECT_PREFS menu;
    OBJECT_PREFS sbar;
    OBJECT_PREFS edit;
    unsigned char auto_indent;
    unsigned char initial_width;
    unsigned char initial_height;
    unsigned char tab_size;
}
PREFERENCES;

void LoadPrefs(void);

