/*
 * Template file generated by MGUI Designer
 * Fill functions' application code here
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#if defined __TURBOC__ || defined _MSC_VER || defined __WATCOMC__
#include <io.h>
#ifndef R_OK
#define R_OK    04
#endif
#else
#include <unistd.h>
#endif

#include "mguipp.h"
#include "medit.hpp"

void Creplace_shell::ReplaceOneCB(void)
{
    execReplace(HM_ONE);
}

void Creplace_shell::ReplaceSomeCB(void)
{
    execReplace(HM_SOME);
}

void Creplace_shell::ReplaceAllCB(void)
{
    execReplace(HM_ALL);
}

void Creplace_shell::ReplaceSelectionCB(void)
{
    execReplace(HM_SEL);
}

void Creplace_shell::execReplace(int hm)
{
    char search[50], replace[50];

    replace_r_e->getText(search);
    replace_w_e->getText(replace);
    Cmain_shell *ms = owner;
    delete this;
    ms->replaceOneAllSomeSelExec(search, replace, hm);
}

void Creplace_shell::CancelCB(void)
{
    delete this;
}

void Cgotoline_shell::GotolineEditActCB(char *buff)
{
    int line;

    line = atoi(buff);
    owner->getEdit()->setCursorXY(0, line - 1);
    delete this;
}

void Cgotoline_shell::GotolineOkCB(void)
{
    int line;
    char buff[16];

    gotoline_e->getText(buff);
    line = atoi(buff);
    owner->getEdit()->setCursorXY(0, line - 1);
    delete this;
}

void Cgotoline_shell::CancelCB(void)
{
    delete this;
}

void Csearch_shell::IgnoreCaseCB(int status)
{
    owner->ignore_case = (unsigned char)status;
}

void Csearch_shell::SearchForwardCB(void)
{
    char buff[50];

    search_e->getText(buff);
    owner->searchForward(buff);
    delete this;
}

void Csearch_shell::SearchBackwardCB(void)
{
    char buff[50];

    search_e->getText(buff);
    owner->searchBackward(buff);
    delete this;
}

void Csearch_shell::CancelCB(void)
{
    delete this;
}

void Cmain_shell::NewCB(int)
{
    Cmain_shell *neww = new Cmain_shell(0, 0);
    neww->realize(30*n_windows, 30*n_windows);
}

void Cmain_shell::OpenNewCB(int)
{
    char fname[MAXFNAMELEN];
    char pname[MAXPATHLEN];
    char buff[MAXPATHLEN+MAXFNAMELEN];
    Cmain_shell *neww;

    fname[0] = '\0';
    pname[0] = '\0';
    if (!MFileSelection("Open New File", EXT, fname, pname, True))
	return;
    strcpy(buff, pname);
    strcat(buff, fname);
    neww = new Cmain_shell(0, buff);
    neww->realize(30*n_windows, 30*n_windows);
}

void Cmain_shell::LoadFileCB(int)
{
    char fname[MAXFNAMELEN];
    char pname[MAXPATHLEN];
    char buff[MAXPATHLEN+MAXFNAMELEN];

    if (!checkClose())
	return;
    fname[0] = '\0';
    pname[0] = '\0';
    if (!MFileSelection("Open New File", EXT, fname, pname, True))
	return;
    strcpy(buff, pname);
    strcat(buff, fname);
    loadFile(buff);
}

void Cmain_shell::InsertFileCB(int)
{
    char fname[MAXFNAMELEN];
    char pname[MAXPATHLEN];
    char *buff;
    int len;
    int curs_pos;

    fname[0] = '\0';
    pname[0] = '\0';
    if (!MFileSelection("Insert File", EXT, fname, pname, True))
	return;
    strcat(pname, fname);
    buff = readFile(pname, 0);
    curs_pos = text_mle->getCursorPos();
    len = strlen(buff);
    text_mle->changeText(curs_pos, 0, buff, len);
    AddUndoData(NULL, curs_pos, 0, buff, len);
}

void Cmain_shell::RevertCB(int)
{
    char str[256];

    if (pathname[0] == '\0')
    {
	MMessageDialog("Warning", "No file open !", " Ok ", NULL);
	return;
    }
    sprintf(str, "Are you sure you want to reload:\n\n%s ?\n", pathname);
    if (MMessageDialog("", str, " Yes ", " Abort ", NULL) != 0)
	return;
    strcpy(str, pathname);
    loadFile(str);
}

void Cmain_shell::SaveCB(int)
{
    FILE *fp;
    char str[256];
    char *buff;
    int len;

    if (pathname[0] == '\0')
    {
	if (modified)
	    SaveAsCB(0);
	else
	    MMessageDialog("Warning", "No file open !", " Ok ", NULL);
	return;
    }
    if (read_only)
    {
	sprintf(str, "File: %s\nis read only!", pathname);
	MMessageDialog("Warning", str, " Ok ", NULL);
	return;
    }
    if (!modified)
    {
	sprintf(str, "File:\n%s\nhas not been modified.\nSave anyway ?", pathname);
	if (MMessageDialog("Warning", str, " Yes ", " Abort", NULL) != 0)
	    return;
    }
    if ((fp = fopen(pathname, "w")) == NULL)
    {
	sprintf(str, "Cannot open file:\n%s\nfor writing!", pathname);
	MMessageDialog("Warning", str, " Ok ", NULL);
	return;
    }
    buff = text_mle->getAllocatedText();
    if (buff)
    {
	len = strlen(buff);
	if (fwrite(buff, 1, len, fp) != len)
	    MMessageDialog("Error", "Write failed !!!", "Ok", NULL);
	free(buff);
    }
    fclose(fp);
    modified = False;
    modified_l->setText(" ");
}

void Cmain_shell::SaveAsCB(int)
{
    char pname[MAXPATHLEN];
    char fname[MAXFNAMELEN];
    FILE *fp;
    char str[256];
    char *buff;
    int len;

    strcpy(fname, filename);
    pname[0] = '\0';
    if (!MFileSelection("Save File As ...", EXT, fname, pname, True))
	return;
    strcat(pname, fname);
    if ((fp = fopen(pname, "w")) == NULL)
    {
	sprintf(str, "Cannot open file:\n%s\nfor writing!", pname);
	MMessageDialog("Warning", str, " Ok ", NULL);
	return;
    }
    buff = text_mle->getAllocatedText();
    if (buff)
    {
	len = strlen(buff);
	if (fwrite(buff, 1, len, fp) != len)
	    MMessageDialog("Error", "Write failed !!!", "Ok", NULL);
	free(buff);
    }
    fclose(fp);
    modified = False;
    modified_l->setText(" ");
    if (read_only)
    {
	read_only = False;
	text_mle->setSensitive();
    }
    strcpy(pathname, pname);
    strcpy(filename, fname);
    filename_l->setText(pathname);
    setText(filename);
}

void Cmain_shell::WriteSelCB(int)
{
    FILE *fp;
    int start, end;
    char *buff;
    char str[256];
    char fname[MAXFNAMELEN];
    char pname[MAXPATHLEN];

    text_mle->getSelection(&start, &end);
    if (start >= end)
    {
	MMessageDialog("Warning", "No text selected!", "Ok", NULL);
	return;
    }
    if ((buff = (char *)malloc(end - start + 1)) == NULL)
    {
	MBeep();
	return;
    }
    text_mle->getSubString(start, end, buff);
    fname[0] = '\0';
    pname[0] = '\0';
    if (MFileSelection("Write Selection", EXT, fname, pname, True))
    {
	strcat(pname, fname);
	if (access(pname, R_OK) == 0 &&
	    MMessageDialog("Warning", "File exists!\nOverwrite ?",
			   " Yes ", " No ", NULL) != 0)
	{
	    free(buff);
	    return;
	}
	if ((fp = fopen(pname, "w")) != NULL)
	{
	    if (fwrite(buff, 1, end - start, fp) != end - start)
		MMessageDialog("Error", "Writing file", "Ok", NULL);
	    fclose(fp);
	}
	else
	{
	    sprintf(str, "Cannot open file:\n%s\nfor writing!", pname);
	    MMessageDialog("Warning", str, " Ok ", NULL);
	}
    }
    free(buff);
}

void Cmain_shell::PrintCB(int)
{
    FILE *fp;
    int start, end, ret;
    char *buff;
    char str[256];
    char fname[MAXFNAMELEN];

    switch (MMessageDialog("", "Print...", "File", "Selection", "Cancel", NULL))
    {
    case 2:
	return;
    case 1:
	text_mle->getSelection(&start, &end);
	if (start >= end)
	{
	    MMessageDialog("Warning", "No text selected!", "Ok", NULL);
	    return;
	}
	if ((buff = (char *)malloc(end - start + 1)) == NULL)
	{
	    MBeep();
	    return;
	}
	text_mle->getSubString(start, end, buff);
	break;
    default:
	buff = text_mle->getAllocatedText();
	if (buff == NULL)
	{
	    MBeep();
	    return;
	}
	start = 0;
	end = strlen(buff);
    }
    strcpy(fname, "meXXXXXX");
    mktemp(fname);
    if ((fp = fopen(fname, "w")) != NULL)
    {
	fwrite(buff, 1, end - start, fp);
	fclose(fp);
	free(buff);
    }
    else
    {
	sprintf(str, "Cannot open file:\n%s\nfor writing!", fname);
	MMessageDialog("Warning", str, " Ok ", NULL);
	free(buff);
	return;
    }
    for (;;)
    {
	switch (MSpoolTempFile(fname))
	{
	case MSPOOL_NOT_READY:
	    ret = MMessageDialog("Error", "Printer NOT READY", "Retry", "Cancel", NULL);
	    if (ret == 0)
		continue;
	    break;
	default:
	    MMessageDialog("Error", "Print failed!", "Ok", NULL);
	    break;
	case MSPOOL_OK:
	    return;
	}
	::unlink(fname);
	return;
    }
}

void Cmain_shell::AddUndoData(
	    char *oldtext, int start, int oldlen,
	    char *newtext, int newlen)
{
    UNDO_DATA *pud, *tmp;

    if (curr_undo || first_undo)
    {
/*
 * Cut any Undo-ed data (it cannot be Redo-ed)
 */
	if (curr_undo)
	{
	    pud = curr_undo->next;
	    curr_undo->next = NULL;
	}
	else
	{
	    pud = first_undo;
	    first_undo = NULL;
	}
	while (pud)
	{
	    tmp = pud;
	    pud = pud->next;
	    FreeUndo(tmp);
	    undo_level--;
	}
    }

    if (undo_level == UNDO_DEPTH)
    {
/*
 * Cut the oldest undo data when maximum depth is reached
 */
	tmp = first_undo;
	first_undo = first_undo->next;
	if (first_undo)
	    first_undo->prev = NULL;
	FreeUndo(tmp);
	undo_level--;
    }

    pud = (UNDO_DATA *) calloc(1, sizeof(UNDO_DATA));
    if (pud == NULL)
    {
	if (oldtext)
	    free(oldtext);
	if (newtext)
	    free(newtext);
	return;
    }

    pud->start = start;
    pud->oldlen = oldlen;
    pud->newlen = newlen;
    pud->oldtext = oldtext;
    pud->newtext = newtext;

    if (curr_undo)
	curr_undo->next = pud;
    pud->prev = curr_undo;
    curr_undo = pud;
    if (first_undo == NULL)
	first_undo = pud;

    undo_level++;
}

void Cmain_shell::FreeUndo(UNDO_DATA * pud)
{
    if (pud->oldtext)
	free(pud->oldtext);
    if (pud->newtext)
	free(pud->newtext);
    free(pud);
}

/*
 * Free all queued undo items for a window
 */
void Cmain_shell::FreeUndoList(void)
{
    UNDO_DATA *pud, *tmp;

    pud = first_undo;
    while (pud)
    {
	tmp = pud;
	pud = pud->next;
	FreeUndo(tmp);
    }
    first_undo = NULL;
    curr_undo = NULL;
    undo_level = 0;
}

int Cmain_shell::checkClose(void)
{
    char str[256];
    int  ret;

    if (!modified)
	return True;
    if (pathname[0] == '\0')
    {
	if (MMessageDialog("Warning", "This window content\nwill be lost !",
			   " Save ", " Don't save ", NULL) == 0)
	{
	    SaveAsCB(0);
	}
	else
    	    return True;
    }
    else
    {
	sprintf(str, "Save\n%s\nbefore closing ?", pathname);
	ret = MMessageDialog("Warning",
			     str, " Yes ", " No ", " Cancel ", NULL);
	if (ret == 0)
	    SaveCB(0);
	else if (ret == 2)
	    return False;
	else
	    return True;
    }
    return !modified;
}

void Cmain_shell::CloseCB(int)
{
    if (!checkClose())
	return;
    FreeUndoList();
    delete this;
    if (first == 0)
	CmAppl::end(0);
}

void Cmain_shell::quit(void)
{
    Cmain_shell *ms = first;

    while (ms)
    {
	ms->CloseCB(0);
	ms = ms->next;
    }
}

void Cmain_shell::QuitCB(int)
{
    quit();
}

void Cmain_shell::UndoCB(int)
{
    UNDO_DATA *pud;

    pud = curr_undo;
    if (pud == NULL)
    {
	MBeep();
	return;
    }
    text_mle->changeText(pud->start, pud->newlen,
		    (pud->oldtext ? pud->oldtext : ""),
		    pud->oldlen);
    curr_undo = pud->prev;
    if (!modified)
    {
/*
 * Set file modified status to True
 */
	MObjectSetText(modified_l, "*");
	modified = True;
    }
}

void Cmain_shell::RedoCB(int)
{
    UNDO_DATA *pud;

    pud = (curr_undo ? curr_undo->next : first_undo);
    if (pud == NULL)
    {
	MBeep();
	return;
    }
    text_mle->changeText(pud->start, pud->oldlen,
		    (pud->newtext ? pud->newtext : ""),
		    pud->newlen);
    curr_undo = pud;
    if (!modified)
    {
/*
 * Set file modified status to True
 */
	modified_l->setText("*");
	modified = True;
    }
}

void Cmain_shell::GoToLineCB(int)
{
    Cgotoline_shell *shell = new Cgotoline_shell(this);
    shell->realize();
}

void Cmain_shell::SearchCB(int)
{
    Csearch_shell *shell = new Csearch_shell(this);
    ignore_case = False;
    shell->realize();
}

void Cmain_shell::SearchNextCB(int)
{
    searchForward(search_text);
}

void Cmain_shell::searchForward(char *ss)
{
    int curs_pos, len;
    char str[128];

    curs_pos = text_mle->getCursorPos();
    if ((curs_pos = text_mle->findSubStringForward(
			 curs_pos, ss, ignore_case)) >= 0)
    {
	len = strlen(ss);
	if (ss != search_text)
	{
	    if (search_text)
		free(search_text);
	    search_text = (char *)malloc(len + 1);
	    strcpy(search_text, ss);
	}
	text_mle->setCursorPos(curs_pos + len);
	text_mle->setSelection(curs_pos, curs_pos + len);
    }
    else
    {
	sprintf(str, "String:\n%s\nnot found", ss);
	MMessageDialog("Warning", str, " Ok ", NULL);
    }
}

void Cmain_shell::SearchPrevCB(int)
{
    searchBackward(search_text);
}

void Cmain_shell::searchBackward(char *ss)
{
    int curs_pos, len;
    char str[128];

    curs_pos = text_mle->getCursorPos();
    if ((curs_pos = text_mle->findSubStringBackward(
			 curs_pos, ss, ignore_case)) >= 0)
    {
	len = strlen(ss);
	if (ss != search_text)
	{
	    if (search_text)
		free(search_text);
	    search_text = (char *)malloc(len + 1);
	    strcpy(search_text, ss);
	}
	text_mle->setCursorPos(curs_pos);
	text_mle->setSelection(curs_pos, curs_pos + len);
    }
    else
    {
	sprintf(str, "String:\n%s\nnot found", ss);
	MMessageDialog("Warning", str, " Ok ", NULL);
    }
}

void Cmain_shell::ReplaceCB(int)
{
    Creplace_shell *shell = new Creplace_shell(this);
    shell->realize();
}

void Cmain_shell::LargeFontSelectCB(int)
{
    text_mle->setFont(FIXED_LARGE, True);
}

void Cmain_shell::MediumFontSelectCB(int)
{
    text_mle->setFont(FIXED_MEDIUM, True);
}

void Cmain_shell::SmallFontSelectCB(int)
{
    text_mle->setFont(FIXED_SMALL, True);
}

void Cmain_shell::AutoIndentCB(int)
{
    text_mle->setAutoIndent(auto_indent_mi->getCheckStatus());
}

void Cmain_shell::TextChangedCB(EDIT_CHANGE *ped)
{

    char *oldtext = NULL;
    char *newtext = NULL;

    if (!modified)
    {
/*
 * Set file modified status to True
 */
	modified_l->setText("*");
	modified = True;
    }
    if (ped->len > 0 && (oldtext = (char *)malloc(ped->len + 1)) == NULL)
    {
	return;
    }
    if (ped->change_len > 0 && (newtext = (char *)malloc(ped->change_len + 1)) == NULL)
    {
	if (oldtext)
	    free(oldtext);
	return;
    }
    if (ped->len > 0)
    {
	strncpy(oldtext, ped->current_text + ped->pos, ped->len);
	oldtext[ped->len] = '\0';
    }
    if (ped->change_len > 0)
    {
	strncpy(newtext, ped->change, ped->change_len);
	newtext[ped->change_len] = '\0';
    }
    AddUndoData(oldtext, ped->pos, ped->len, newtext, ped->change_len);
}

void Cmain_shell::CursorPosCB(EDIT_CURS *pc)
{
    char buff[64];

    sprintf(buff, "%4d", pc->pos_x + 1);
    curs_x_l->setText(buff);
    sprintf(buff, "%4d", pc->pos_y + 1);
    curs_y_l->setText(buff);
}

void Cmain_shell::replaceOneAllSomeSelExec(char *search, char *replace, int how_many)
{
    int curs_pos, oldlen, newlen, sel_end;
    int changed, ret;
    char str[128];
    char *oldtext, *newtext;

    oldlen = strlen(search);
    newlen = strlen(replace);
    if (search_text)
	free(search_text);
    search_text = (char *)malloc(oldlen + 1);
    strcpy(search_text, search);
    if (replace_text)
	free(replace_text);
    replace_text = (char *)malloc(newlen + 1);
    strcpy(replace_text, replace);

    oldtext = text_mle->getAllocatedText();

    changed = False;
    if (how_many == HM_SEL)
	text_mle->getSelection(&curs_pos, &sel_end);
    else
	curs_pos = text_mle->getCursorPos();
    while ((curs_pos = text_mle->findSubStringForward(curs_pos, search, False)) >= 0)
    {
	ret = 0;
	if (how_many == HM_SEL)
	{
	    if (curs_pos + oldlen > sel_end)
		break;
	    sel_end += newlen - oldlen;
	}
	else if (how_many == HM_SOME)
	{
	    text_mle->setCursorPos(curs_pos);
	    text_mle->setSelection(curs_pos, curs_pos + oldlen);
	    ret = MMessageDialog("", "Replace Current Selection ?",
				 "Yes", "No", "Stop", NULL);
	    if (ret == 2)
		break;
	}
	if (ret != 1)
	{
	    text_mle->changeText(curs_pos, oldlen, replace, newlen);
	    curs_pos += newlen;
	}
	else
	    curs_pos++;
	changed = True;
	if (how_many == HM_ONE)
            break;
    }
    if (!changed)
    {
	sprintf(str, "String:\n%s\nnot found", search);
	MMessageDialog("Warning", str, " Ok ", NULL);
	if (oldtext)
	    free(oldtext);
    }
    else
    {
	modified = True;
	modified_l->setText("*");
	if (oldtext)
	{
	    newtext = text_mle->getAllocatedText();
	    if (newtext)
		AddUndoData(oldtext, 0, strlen(oldtext),
			    newtext, strlen(newtext));
	    else
		free(oldtext);
	}
    }
}
