
/*
 *    File editlist.c
 */
#include <stdio.h>
#include <string.h>

#include "mgui.h"

extern void CloseDialogCB(MOBJECT p, void *s, void *v);

extern MTColor black, white, darkblue, cadetblue, seagreen;

static EL_TEMPLATE elt[] =
{
    {"Nome", 10, 10, True, NULL, NULL},
    {"Cognome", 20, 10, True, NULL, NULL},
    {"Indirizzo\nsu due righe", 10, 10, False, NULL, NULL},
    {"Numero civico", 3, 10, False, NULL, NULL},
    {"Citta'", 10, 10, True, NULL, NULL}
};

#define N_FIELDS	(int)(sizeof(elt)/sizeof(EL_TEMPLATE))

/******************************************************************
 *	This Callback is invoked by the EDITLIST Object
 *	when the user double-clicks on an item or presses the
 *	'Enter' key on a highlighted item.
 *******************************************************************/
static void 
ELSelectCB(MOBJECT obj, LIST_ACT * pla, void *adata)
{
    MOBJECT elist = (MOBJECT) adata;
    char str[256], s1[32], s2[32], s3[32], s4[32], s5[32];
/*
 * Get the fields of the selected item
 */
    MEditListGetItemField(elist, pla->item, 0, s1);
    MEditListGetItemField(elist, pla->item, 1, s2);
    MEditListGetItemField(elist, pla->item, 2, s3);
    MEditListGetItemField(elist, pla->item, 3, s4);
    MEditListGetItemField(elist, pla->item, 4, s5);
/*
 * Format and show the selected item one field per line
 */
    sprintf(str, "Item <%s>\n\n<%s>\n<%s>\n<%s>\n<%s>\n<%s>\n",
	    pla->item, s1, s2, s3, s4, s5);
    MObjectSetUserData(elist, (void *) pla->pos);
    MMessageDialog("MEditListGetItemField()", str, " Ok ", NULL);
}

/******************************************************************
 *	This Callback is invoked by a PUSH BUTTON
 *	to add a new item in the EDITLIST.
 *******************************************************************/
static void 
ELAddCB(MOBJECT obj, void *a, void *adata)
{
    MEditListAddItemFromEdits((MOBJECT) adata, 0L);
}

/******************************************************************
 *	This Callback is invoked by a PUSH BUTTON
 *	to delete the item currently loaded in the EDITs of the
 *	EDITLIST.
 *******************************************************************/
static void
ELDelCB(MOBJECT obj, void *a, void *adata)
{
    MOBJECT list = (MOBJECT) adata;
    char *pl[3];
    char strs[2][32];
    long pos;
    void *u_data;
/*
 * Use only the first two fields as a key to find
 * the item to delete
 */
    MEditListGetEditText(list, 0, strs[0]);
    MEditListGetEditText(list, 1, strs[1]);
    pl[0] = strs[0];
    pl[1] = strs[1];
    pl[2] = NULL;
    MEditListSeekItem(list, pl, &pos, &u_data);
/*
 * Delete the item (if found)
 */
    if (pos != -1)
	MEditListDelElement(list, pos);
    else
	MBeep();
}

/******************************************************************
 *	This Callback is invoked by a PUSH BUTTON
 *	to change the item currently loaded in the EDITs of the
 *	EDITLIST.
 *******************************************************************/
static void 
ELChangeCB(MOBJECT obj, void *a, void *adata)
{
    MOBJECT list = (MOBJECT) adata;
    char *pl[N_FIELDS];
    char strs[N_FIELDS][32];
    long pos;
    void *u_data;
    int i;
/*
 * Use only the first two fields as a key to find
 * the item to delete
 */
    MEditListGetEditText(list, 0, strs[0]);
    MEditListGetEditText(list, 1, strs[1]);
    pl[0] = strs[0];
    pl[1] = strs[1];
    pl[2] = NULL;
    MEditListSeekItem(list, pl, &pos, &u_data);
    if (pos != -1)
    {
/*
 * Get the field values from the EDITs and replace the item
 * at position 'pos'
 */ for (i = 2; i < N_FIELDS; i++)
	{
	    MEditListGetEditText(list, i, strs[i]);
	    pl[i] = strs[i];
	}
	MEditListChangeElement(list, pos, pl, 0L);
    }
    else
	MBeep();
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void 
EditListCB(MOBJECT o, void *o_data, void *a_data)
{
    MOBJECT pbutton, shell, form0, form;
    MOBJECT elist, sfile;
    int i;
    char s1[32];
    char s2[32];
    char s3[32];
    char s4[32];
    char s5[32];
    char *argl[6];

    shell = MCreateShell("Edit List", SF_MODAL);

    form0 = MCreateColForm(shell);

    form = MCreateRowForm(form0);

    elist = MCreateEditList(form, FIXED_MEDIUM, elt, N_FIELDS, 10, 28);
/*
 * Change the font of the field headers
 */
    for (i = 0; i < N_FIELDS; i++)
	MObjectSetFont(elt[i].label, HELV_N_FONT, False);

    MObjectSetColor(elist, cadetblue, black);
    MSBLHeadSetColor(elist, darkblue, white);
    MSListSetCallback(elist, ELSelectCB, elist);
    MSListSetSortCallback(elist, strcmp);

/*
 * Create Push buttons and set the callbacks to add, delete and change
 * item values
 */
    form = MCreateColForm(form);
    pbutton = MCreatePButton(form, "Add", TIMES_N_FONT);
    MPButtonSetCallback(pbutton, ELAddCB, elist);
    pbutton = MCreatePButton(form, "Del", TIMES_N_FONT);
    MPButtonSetCallback(pbutton, ELDelCB, elist);
    pbutton = MCreatePButton(form, "Change", TIMES_N_FONT);
    MPButtonSetCallback(pbutton, ELChangeCB, elist);

/*
 * Insert 50 items in the EDITLIST
 */
    argl[0] = s1;
    argl[1] = s2;
    argl[2] = s3;
    argl[3] = s4;
    argl[4] = s5;
    argl[5] = NULL;
    for (i = 0; i < 50; i++)
    {
	sprintf(s1, "Nome_%d___", i);
	sprintf(s2, "Cognome_%d___", i);
	sprintf(s3, "Indirizzo_%d___", i);
	sprintf(s4, "%03d", i);
	sprintf(s5, "citta'_%d___", i);
	MEditListAddItem(elist, argl, (void *) i);
    }
/*
 * Create a SFile to view this source file
 */
    sfile = MCreateSFile(form0, __FILE__, FIXED_MEDIUM, 15, 46);
    MObjectSetColor(sfile, darkblue, white);

    pbutton = MCreatePButton(shell, "Close", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, CloseDialogCB, 0L);

    MShellRealize(shell);
}
