/*
 *      File sform.c
 *      Demonstrates the use of the SCROLLEDFORM Object
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mgui.h"

extern MTColor black, white, darkblue, cadetblue, seagreen;
extern int LowRes;

/**********************************************************
 *      This callback destroys the dialog
 **********************************************************/
void 
CloseSFormCB(MOBJECT p, void *s, void *adata)
{
    p = MObjectShell(p);
    MShellUnrealize(p);
    MShellDestroy(p);
}

/**********************************************************
 *      This callback is called when the pixmap is destroyed
 *  so the application can free the image loaded
 **********************************************************/
void 
PixmapDestroyCB(MOBJECT p, void *s, void *adata)
{
    MOBJECT pixmap = (MOBJECT) adata;
    void *udata;

    udata = MObjectGetUserData(pixmap);
    if (udata != NULL)
	MFreeImage((MIMAGE) udata);
}

#if defined WIN_MGUI
void 
SetupPrinterCB(MOBJECT p, void *s, void *adata)
{
    int MPrintSetup(int po, int *xres, int *yres, int *pwidth, int *pheight, int *nplanes);
    int xres, yres, pwidth, plength, nplanes;

    if (MPrintSetup(PO_DEFAULT, &xres, &yres, &pwidth, &plength, &nplanes))
    {
	char buf[128];

	sprintf(buf,
		"Setup options:\n\
Paper width: %d (mm)\n\
Paper length: %d (mm)\n\
X res: %d (pixels)\n\
Y res: %d (pixels)\n\
Planes: %d",
		pwidth, plength, xres, yres, nplanes);
	MMessageDialog("", buf, "Ok", NULL);
    }
}

void 
PrintWindowCB(MOBJECT p, void *s, void *adata)
{
    MPRINT_OPTIONS po;
    DOC_ID did;
    MPAGE_OPTIONS pages;

    pages.startPage = pages.minPage = 1;
    pages.endPage = pages.maxPage = 1;
    did = MOpenPrintDoc("Print Test", False, PO_PORTRAIT, &pages);
    if (did == NULL)
    {
	MMessageDialog("", "Print aborted", "Ok", NULL);
	return;
    }
/*
    po.mode = PM_PERC;
    po.x = -1;
    po.y = -1;
    po.w = 50;
    po.h = -1;
*/
    po.mode = PM_FULL;
    po.x = -1;
    po.y = -1;

    MPrintObject(adata, did, &po);
    MClosePrintDoc(did);
}

void 
PrintImageCB(MOBJECT p, void *s, void *adata)
{
    MPrintImage(MPixmapGetImage(adata), True);
}
#endif

/**********************************************************
 *      This callback changes the image viewed
 **********************************************************/
void 
ChangeImageCB(MOBJECT p, void *s, void *adata)
{
    char fname[128], dirname[128];
    MIMAGE mpd, old_image;
    MOBJECT pixmap = (MOBJECT) adata;

#if defined UNIX || defined __CYGWIN32__
#define stricmp strcasecmp
#endif

    strcpy(dirname, MGetSysDir());
    fname[0] = '\0';
    if (MFileSelection("Select New Image", "", fname, dirname, False))
    {
	strcat(dirname, fname);
#if defined JPEG_SUPPORTED
	if (!stricmp(fname + strlen(fname) - 3, "jpg"))
	    mpd = MReadJPEGFile(dirname);
	else
#endif
#if defined TIFF_SUPPORTED
	if (!stricmp(fname + strlen(fname) - 3, "tif"))
	    mpd = MReadTIFFFile(dirname);
	else
#endif
	if (!stricmp(fname + strlen(fname) - 3, "gif"))
	    mpd = MReadGIFFile(dirname);
	else
	    mpd = MReadBMPFile(dirname);

	if (mpd != NULL)
	{
	    old_image = (MIMAGE) MObjectGetUserData(pixmap);
	    if (old_image != NULL)
		MFreeImage(old_image);
	    MObjectSetUserData(pixmap, (void *) mpd);
	    MInstallImage(mpd);
	    MPixmapSetImage(pixmap, mpd);
	}
    }
}

/**********************************************************
 *      This callback saves the image viewed
 **********************************************************/
void 
SaveImageCB(MOBJECT p, void *s, void *pixmap)
{
    char fname[128], dirname[128];
    MIMAGE img;

    img = MObjectGetUserData(pixmap);
    strcpy(dirname, MGetSysDir());
    fname[0] = '\0';
    if (MFileSelection("Select Image name", "", fname, dirname, False))
    {
	strcat(dirname, fname);
	if (!stricmp(fname + strlen(fname) - 3, "bmp"))
	{
	    if (!MWriteBMPFile(img, dirname))
		MMessageDialog(dirname, "Error saving image file", "Ok", NULL);
	}
#if defined JPEG_SUPPORTED
	else if (!stricmp(fname + strlen(fname) - 3, "jpg"))
	{
	    if (!MWriteJPEGFile(img, dirname, 100))
		MMessageDialog(dirname, "Error saving image file", "Ok", NULL);
	}
#endif
#if defined TIFF_SUPPORTED
	else if (!stricmp(fname + strlen(fname) - 3, "tif"))
	{
	    if (!MWriteTIFFFile(img, dirname, 5))
		MMessageDialog(dirname, "Error saving image file", "Ok", NULL);
	}
#endif
    }
}

/*****************************************************
 *      This callback opens the dialog when the
 *      corresponding menu item is selected
 *****************************************************/
void 
ScrolledFormCB(MOBJECT o, void *o_data, void *a_data)
{
    MOBJECT shell, form, form1, sform, pixmap;
    MOBJECT pbutton, sfile;
    MIMAGE image;

    shell = MCreateShell("Test Scrolled Form", SF_NO_CLOSE | SF_NO_MAXIMIZE);

    form1 = MCreateColForm(shell);

    sform = MCreateScrolledForm(form1, 200, 250);
    MScrolledFormSetIncr(sform, 10, 1);

    MCreateLabel(sform, "Label inside the scrolled form", TIMES_MEDIUM);
    image = MReadBMPFile("paulina1.bmp");
    if (image != NULL)
	MInstallImage(image);
    pixmap = MCreatePixmapFromData(sform, image);

    MObjectSetUserData(pixmap, image);
    MObjectAddDestroyCallback(pixmap, PixmapDestroyCB, pixmap);

    sfile = MCreateSFile(form1, __FILE__, FIXED_MEDIUM, 15, 54);
    MObjectSetColor(sfile, darkblue, white);

    form = MCreateColForm(shell);

    pbutton = MCreatePButton(form, "New Image", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, ChangeImageCB, pixmap);
    pbutton = MCreatePButton(form, "Save Image", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, SaveImageCB, pixmap);
#if defined WIN_MGUI
    pbutton = MCreatePButton(form, "Print Image", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, PrintImageCB, pixmap);
    pbutton = MCreatePButton(form, "Print Window", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, PrintWindowCB, form1);
    pbutton = MCreatePButton(form, "Setup Printer", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, SetupPrinterCB, NULL);
#endif
    pbutton = MCreatePButton(form, "Close", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, CloseSFormCB, pixmap);

    MShellRealize(shell);
}
