/*
 *    File statbar.c
 *      Demonstrates the use of the STATUSBAR Object
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mgui.h"

#define END_VALUE	100
#define TIME_OUT	(500L)

/*
 *    Callback for closing and destroying a generic dialog
 */
extern void CloseDialogCB(MOBJECT p, void *s, void *v);

extern MTColor black, white, darkblue, cadetblue, seagreen;

/*****************************************************
 *	Timer Callback that simulates the progress
 *	of an operation using a STATUSBAR Object.
 *****************************************************/
void 
AppTimeoutCB(TIMEOUT_ID id, void *sbar)
{
    MOBJECT shell;
    char str[128];
    int perc;

/*
 * The Object itself contains in its user data
 * the current progress percentage
 */
    perc = (int) MObjectGetUserData((MOBJECT) sbar) + 2;
    shell = MObjectShell((MOBJECT) sbar);
    sprintf(str, "%d %%", perc);
/*
 * Update the STATUSBAR text and position
 */
    MObjectSetText((MOBJECT) sbar, str);
    MStatusBarSetPos((MOBJECT) sbar, perc);
/*
 * If not at the end, set again this Timer Callback
 */
    MObjectSetUserData(shell, (perc < END_VALUE) ?
		 (void *) MAddTimeout(TIME_OUT, AppTimeoutCB, sbar) : NULL);

/*
 * Update the Object user data to the new position
 */
    MObjectSetUserData((MOBJECT) sbar, (void *) perc);
}

/*****************************************************
 *	This callback resets the timer if the SHELL
 *	is destroyed before the STATUSBAR reaches
 *	the end position
 *****************************************************/
static void 
ShellDestroyCB(MOBJECT shell, void *dummy, void *sbar)
{
    TIMEOUT_ID id = (TIMEOUT_ID) MObjectGetUserData(shell);

    if (id != 0)
	MRemoveTimeout(id);
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void 
StatusBarCB(MOBJECT obj, void *a, void *b)
{
    MOBJECT shell, pb, statusbar, sfile;

    shell = MCreateShell("Status Bar", 0);
/*
 * Create a STATUSBAR Object with the initial text '0 %' and
 * a maximum value of 'END_VALUE'
 */
    statusbar = MCreateStatusBar(shell, "0 %", END_VALUE, HELV_MEDIUM);
/*
 * Create a SFILE Object to view this source file in the dialog
 */
    sfile = MCreateSFile(shell, __FILE__, FIXED_MEDIUM, 10, 48);
    MObjectSetColor(sfile, darkblue, white);
/*
 * This PUSH BUTTON closes the dialog
 */
    pb = MCreatePButton(shell, "Close", TIMES_MEDIUM);
    MPButtonSetCallback(pb, CloseDialogCB, 0L);
/*
 * The user data of the STATUSBAR is used to store
 * the current percentage
 */
    MObjectSetUserData(statusbar, NULL);
/*
 * Set the Timer Callback to start updating the STATUSBAR
 */
    MObjectSetUserData(shell, (void *) MAddTimeout(TIME_OUT, AppTimeoutCB, statusbar));

/*
 * Catch the DESTROY event for the SHELL, so we can reset the timer
 */
    MObjectAddDestroyCallback(shell, ShellDestroyCB, (void *) statusbar);

    MShellRealize(shell);
}
