/*
 *      File table.c
 *      Demonstrates the use of the TABLE Container Object
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mgui.h"

extern MTColor black, white, darkblue, cadetblue, seagreen;
extern int LowRes;

/**********************************************************
 *      This callback destroys the dialog
 **********************************************************/
void 
CloseTableCB(MOBJECT p, void *s, void *adata)
{
    p = MObjectShell(p);
    MShellUnrealize(p);
    MShellDestroy(p);
}

/*****************************************************
 *      This callback opens the dialog when the
 *      corresponding menu item is selected
 *****************************************************/
void
TableCB(MOBJECT o, void *o_data, void *a_data)
{
    MOBJECT shell, form, table;
    MOBJECT pbutton, sfile, lbl;
    int ii, nc;
    char buff[64];

    shell = MCreateShell("Test Table", SF_NO_CLOSE | SF_NO_MAXIMIZE);

    nc = 5;
    table = MCreateTableForm(shell, nc);
    MFormSetSpacing(table, 6);
    MObjectSetShadow(table, WS_NONE, 0, 0);
    MObjectSetBackgroundRGB(table, 128, 128, 64);

    for (ii=0; ii < 5*nc-1; ii++)
    {
	sprintf(buff, "Cell %d - %d", ii/nc, ii%nc);
	lbl = MCreateLabel(table, buff, (ii%3) ? FIXED_MEDIUM : FIXED_LARGE);
	MObjectSetShadow(lbl, WS_SHADOW_IN, 1, 0);
	MObjectSetResize(lbl, 0, 0);
    }

    MTableFormShowGrid(table);
    MTableFormSetColAlign(table, 0, LEFT_ALIGN);
    MTableFormSetColAlign(table, 1, RIGHT_ALIGN);
    MTableFormSetRowAlign(table, 0, TOP_ALIGN);
    MTableFormSetRowAlign(table, 1, BOTTOM_ALIGN);
    MTableFormSetColFont(table, 2, TIMES_LARGE);
    MTableFormSetColForegroundRGB(table, 2, 255, 255, 255);

    sfile = MCreateSFile(shell, __FILE__, FIXED_MEDIUM, 12, 54);
    MObjectSetColor(sfile, darkblue, white);

    form = MCreateColForm(shell);

    pbutton = MCreatePButton(form, "Close", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, CloseTableCB, 0);

    MShellRealize(shell);
}
