/*
 *    File clipform.cpp
 */

#include <stdio.h>

#include "mguipp.h"

#include "mguitest.hpp"

class CaClipForm : public CmCallback {
	CmClippedForm *cform;
	CmShell *shell;
public:
	CaClipForm();
	void incX(void) {cform->setClipX(cform->getClipX() + 50); };
	void incY(void) {cform->setClipY(cform->getClipY() + 50); };
	void decX(void) {cform->setClipX(cform->getClipX() - 50); };
	void decY(void) {cform->setClipY(cform->getClipY() - 50); };
	void closeDialog(void) { delete shell; delete this; };
};

CaClipForm::CaClipForm(void)
{
    CmForm *form, *form0, *form1;
    CmSFile *sfile;
    CmPushButton *pb;

    shell = new CmShell("Clipped Form", 0);

    form0 = new CmColForm(shell);
    form1 = new CmRowForm(form0);

    sfile = new CmSFile(form0, __FILE__, FIXED_MEDIUM, 15, 52);
    sfile->setColor(darkblue, white);

    cform = new CmClippedForm(form1, 100, 200);

    new CmLabel(cform, "Label inside the clipped form", TIMES_MEDIUM);
    new CmPixmap(cform, "paulina1.bmp");

    form = new CmColForm(form1);

    pb = new CmPushButton(form, "Clip_X +", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&CaClipForm::incX);
    pb = new CmPushButton(form, "Clip_X -", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&CaClipForm::decX);

    form = new CmColForm(form1);

    pb = new CmPushButton(form, "Clip_Y +", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&CaClipForm::incY);
    pb = new CmPushButton(form, "Clip_Y -", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&CaClipForm::decY);

    pb = new CmPushButton(shell, "Close", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&CaClipForm::closeDialog);

    shell->realize();
}

/*****************************************************
 *	This function opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void ClippedFormDemo(void)
{
	new CaClipForm;
}

