/*
 *    File fontview.cpp
 *      Demonstrates the Font loading technique
 */

#include <stdio.h>
#include <stdlib.h>

#include "mguipp.h"

#include "mguitest.hpp"

class CaFontView : public CmCallback {
	CmShell *shell;
	CmDrawArea *drawa;
	CmOptionEdit *e_fname;
	CmEditField *e_fsize;

	CmFont *font;
	int bold;
	int italic;
public:
	CaFontView(void);
	virtual ~CaFontView(void);
	void setBold(int on_off) { bold = on_off; }
	void setItalic(int on_off) { italic = on_off; }
	void showFont(void);
	MTFont getFont(void) { return *font; }
	void closeDialog(void) { delete shell; delete this; };
};

class CaShowFont : public CmDrawArea {
	CaFontView *owner;
public:
	CaShowFont(CaFontView *o, CmContainer *parent, int w, int h)
		: owner(o), CmDrawArea(parent, w, h) {};

	void onExpose(MEvent *pe);
};

/***************************************************************
 *	This callback tries to load the specified font
 ***************************************************************/
void CaFontView::
showFont(void)
{
    int size;
    char family[32];
    char buff[8];
/*
 * Get user preferences from the EDIT Objects
 */
    e_fname->getText(family);
    e_fsize->getText(buff);
    size = atoi(buff);
    delete font;
    font = new CmFont(family, size, bold, italic);
/*
 * The FIXED_MEDIUM font is returned on failure
 */
    if (MTFont(*font) != FIXED_MEDIUM)
	drawa->redraw();
    else
	MBeep();
}

/***************************************************************
 *	This callback draws strings using the selected font
 ***************************************************************/
void CaShowFont::
onExpose(MEvent *)
{
    drawText(0, 0, getWidth(), getHeight() / 2,
	      "AaBbCcDdEeFfGgHhIiJjKkLlMm",
	      owner->getFont(), black, CENTER_ALIGN);
    drawText(0, getHeight() / 2, getWidth(), getHeight() / 2,
	      "NnOoPpQqRrSsTtUuWwYyXxZz",
	      owner->getFont(), black, CENTER_ALIGN);
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
CaFontView::
CaFontView(void)
{
    CmForm *form, *form0, *form1, *form2;
    CmSFile *sfile;
    CmAbsList *list;
    CmToggleButton *tb;
    CmPushButton *pb;

    font = new CmFont(DEFAULT_FONT);
    bold = 0;
    italic = 0;

    shell = new CmShell("Font Browser", SF_MODAL);

    form = new CmColForm(shell);
    drawa = new CaShowFont(this, form, 400, 120);
    drawa->setExposeCallback(drawa, (EVENT_CB)&CaShowFont::onExpose);

    form0 = new CmRowForm(form);
    form1 = new CmColForm(form0);

    tb = new CmToggleButton(form0, "Bold", HELV_MEDIUM);
    tb->setCallback(this, (INT_CB)&CaFontView::setBold);

    tb = new CmToggleButton(form0, "Italic", HELV_MEDIUM);
    tb->setCallback(this, (INT_CB)&CaFontView::setItalic);

    pb = new CmPushButton(form0, "Test", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&CaFontView::showFont);

    form2 = new CmRowForm(form1);
    new CmLabel(form2, "Name:", HELV_N_FONT);
    new CmLabel(form2, "Dim:", HELV_N_FONT);

    form2 = new CmRowForm(form1);
/*
 * The Option Edit contains the known font families
 */
    e_fname = new CmOptionEdit(form2, "Times", 32, 10, 5, FIXED_MEDIUM);
    list = e_fname->getSList();
    list->addItem("Times", 0L);
    list->addItem("Helvetica", 0L);
    list->addItem("Courier", 0L);

    e_fsize = new CmEditField(form2, "34", 2, 2, FIXED_MEDIUM);
    e_fsize->setAttachment(True, True, True, False);

    sfile = new CmSFile(shell, __FILE__, FIXED_MEDIUM, 12, 60);
    sfile->setColor(darkblue, white);

    pb = new CmPushButton(shell, "Close", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&CaFontView::closeDialog);

    shell->realize();
}

CaFontView::
~CaFontView(void)
{
	delete font;
	delete shell;
}

void FontViewDemo(void)
{
	new CaFontView;
}
