/*
 *    File mledit.cpp
 *      Demonstrates the use of the MULTI LINE EDIT Object
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mguipp.h"

#include "mguitest.hpp"

#define IsEven(a)	(!((a)&1))

class CaEditWindow : public CmCallback {
	CmShell *shell;
public:
	CaEditWindow(void);
	void closeDialog(void) { delete shell; delete this; };
};

class CaScrolledEditWindow:public CmScrolledEditWindow
{
    int modified;
public:
      CmLabel * curs_label, *mod_label;
      CaScrolledEditWindow(CmContainer * par, char *text, int w, int h, MTFont font = DEFAULT_FONT)
    : CmScrolledEditWindow(par, text, w, h, font)
    {
	modified = False;
    };
    void onChange(char *);
    void onCursorMotion(EDIT_CURS *);
};

/*****************************************************
 *	This function is called by the EDIT
 *	when its cursor position changes.
 *****************************************************/
void CaScrolledEditWindow::
onCursorMotion(EDIT_CURS * ec)
{
    char str[128];

    sprintf(str, "Pos: %4d X: %3d Y: %3d", ec->pos, ec->pos_x, ec->pos_y);
    curs_label->setText(str);
}

/*****************************************************
 *	This Callback is called by the EDIT when its
 *	text value has changed.
 *****************************************************/
void CaScrolledEditWindow::
onChange(char *)
{
/*
 * The EDIT Text has been modified!
 */
    if (modified)
	return;
    mod_label->setText("Modified");
    modified = True;
}

CaEditWindow::CaEditWindow(void)
{
    CaScrolledEditWindow *edit;
    CmForm *cform;
    CmLabel *mod_label, *curs_label;
    CmPushButton *pb;
    FILE *fp;
    char *buff;
    int flen, nr;

    shell = new CmShell("Multi Line Edit", 0);

    cform = new CmColForm(shell);
    mod_label = new CmLabel(cform, "Unmodified", HELV_MEDIUM);
    mod_label->setResize(False, False);
    curs_label = new CmLabel(cform, "", FIXED_MEDIUM);
    buff = NULL;
    if ((fp = fopen(__FILE__, "r")) != NULL)
    {
	flen = 32000;
	if ((buff = (char *) malloc(flen)) != NULL)
	{
	    nr = fread(buff, 1, flen - 1, fp);
	    buff[nr] = '\0';
	}
	fclose(fp);
    }

    edit = new CaScrolledEditWindow(shell,
			  (buff != NULL ? buff : ""), 50, 10, FIXED_MEDIUM);
    edit->setColor(seagreen, black);
    edit->curs_label = curs_label;
    edit->mod_label = mod_label;
    edit->setNewValueCallback(edit, (STRING_CB)&CaScrolledEditWindow::onChange);
    edit->setCursorCallback(edit, (EDITCURS_CB)&CaScrolledEditWindow::onCursorMotion);

    new CmEditWindow(shell,
		       (buff != NULL ? buff : ""), 50, 10, FIXED_MEDIUM);

    if (buff != NULL)
	free(buff);

/*
 * This PUSH BUTTON closes the dialog
 */
    pb = new CmPushButton(shell, "Close", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&CaEditWindow::closeDialog);

    shell->realize();
}

/*****************************************************
 *	This function opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void
EditWindowDemo(void)
{
	new CaEditWindow;
}
