/*
 *    File pageform.cpp
 */
#include <stdio.h>

#include "mguipp.h"

#include "mguitest.hpp"

CmLabel *lab1, *lab2, *lab3, *lab4;

class CaPixmap:public CmPixmap
{
    public:
    CmImage * image;

    CaPixmap(CmContainer * parent, CmImage * img)
    :image(img), CmPixmap(parent, img)
    {
    };
    ~CaPixmap()
    {
	delete image;
    };
};

class CaPagedForm : public CmCallback {
    CmShell *shell;
    CmForm *form, *rb1form, *rb2form, *form0, *form1;
    CmPagedRowFormExt *pform;
    CmEditField *edit;
    CmSFile *sfile;
    CaPixmap *pixm;
    CmImage *mpm;

public:
    CaPagedForm();
    void closeDialog(void) { delete shell; delete this; };
    void installImage(int a) { if (a) { mpm->install(); pixm->redraw();} };
    void uninstallImage(int a) { if (a) { mpm->uninstall(); pixm->redraw();} };
};

class CaSelectObjectRB:public CmRadioButton
{
    public:
    CmObject * ob;
    void onActivate(int armed);
      public:
      CaSelectObjectRB(CmObject * pp, CmContainer * p, char *text, MTFont f = DEFAULT_FONT)
    : ob(pp), CmRadioButton(p, text, f)
    {
	setCallback(this, (INT_CB)&CaSelectObjectRB::onActivate);
    };
};

class CaSelectPageRB:public CmRadioButton
{
    public:
    CmPagedRowFormExt * pform;
    int index;
    int n;
    void onActivate(int armed);
      public:
      CaSelectPageRB(CmPagedRowFormExt * pf, int i, CmContainer * p, char *text, MTFont f = DEFAULT_FONT)
    : pform(pf), index(i), n(0), CmRadioButton(p, text, f)
    {
	setCallback(this, (INT_CB)&CaSelectPageRB::onActivate);
    };
};

/****************************************************
*	Changes the active page in the Paged Form
****************************************************/
void CaSelectPageRB::
onActivate(int armed)
{
    char str[128];

    if (armed)
    {
	pform->setActivePage(index);
/*
 * Set new text in the labels belonging to each page
 */
	sprintf(str, "Page 1 - %d", n);
	lab1->setText(str);
	sprintf(str, "Page 2 - %d", n);
	lab2->setText(str);
	sprintf(str, "Page 3 - %d", n);
	lab3->setText(str);
	sprintf(str, "Page 4 - %d", n);
	lab4->setText(str);
	n++;
    }
}

/**********************************************************
*	Selects an Object in a given page of the Paged Form
***********************************************************/
void CaSelectObjectRB::
onActivate(int armed)
{
    if (armed)
	ob->select();
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
CaPagedForm::CaPagedForm(void)
{
    int npages;
    CmPushButton *close_pb;
    CmRadioButton *rb;

    shell = new CmShell("Paged Form", 0);

    form1 = new CmColForm(shell);

    sfile = new CmSFile(form1, __FILE__, FIXED_MEDIUM, 15, 45);
    sfile->setColor(darkblue, white);

    form0 = new CmRowForm(form1);
    npages = 4;
    pform = new CmPagedRowFormExt(form0, npages);

    form = new CmColForm(form0);
    form->setSpacing(0);
    form->setShadow(WS_NONE, 0, 0);
    rb1form = new CmRowForm(form);
    rb1form->setSpacing(0);
    new CmLabel(rb1form, "Selection", FIXED_MEDIUM);
    rb2form = new CmRowForm(form);
    rb2form->setSpacing(0);
    new CmLabel(rb2form, "Selection", FIXED_MEDIUM);
/*
 * Add Objects to the first page
 */
    pform->setActivePage(0);
    lab1 = new CmLabel(pform, "Page 1", HELV_N_FONT);
    edit = new CmEditField(pform, "", 12, -1, FIXED_MEDIUM);
    mpm = new CmImage("paulina.bmp");
    if (mpm)
    {
	pixm = new CaPixmap(pform, mpm);
	form = new CmColForm(pform);
	form->setSpacing(0);
	form->setShadow(WS_NONE, 0, 0);
	rb = new CmRadioButton(form, "Install", TIMES_N_FONT);
	rb->setCallback(this, (INT_CB)&CaPagedForm::installImage);
	rb = new CmRadioButton(form, "Uninstall", TIMES_N_FONT);
	rb->setCallback(this, (INT_CB)&CaPagedForm::uninstallImage);
    }

    new CaSelectPageRB(pform, 0, rb1form, "Page 1", TIMES_N_FONT);
    new CaSelectObjectRB(edit, rb2form, "Object 1", TIMES_N_FONT);
/*
 * Add Objects to the second page
 */
    pform->setActivePage(1);
    new CmEditField(pform, "", 12, -1, FIXED_MEDIUM);
    lab2 = new CmLabel(pform, "Page 2", HELV_N_FONT);
    edit = new CmEditField(pform, "", 12, -1, FIXED_MEDIUM);

    new CaSelectPageRB(pform, 1, rb1form, "Page 2", TIMES_N_FONT);
    new CaSelectObjectRB(edit, rb2form, "Object 2", TIMES_N_FONT);
/*
 * Add Objects to the third page
 */
    pform->setActivePage(2);
    new CmEditField(pform, "", 12, -1, FIXED_MEDIUM);
    lab3 = new CmLabel(pform, "Page 3", HELV_N_FONT);
    edit = new CmEditField(pform, "", 12, -1, FIXED_MEDIUM);

    new CaSelectPageRB(pform, 2, rb1form, "Page 3", TIMES_N_FONT);
    new CaSelectObjectRB(edit, rb2form, "Object 3", TIMES_N_FONT);
/*
 * Add Objects to the fourth page
 */
    pform->setActivePage(3);
    new CmEditField(pform, "", 12, -1, FIXED_MEDIUM);
    lab4 = new CmLabel(pform, "Page 4", HELV_N_FONT);
    edit = new CmEditField(pform, "", 12, -1, FIXED_MEDIUM);

    new CaSelectPageRB(pform, 3, rb1form, "Page 4", TIMES_N_FONT);
    new CaSelectObjectRB(edit, rb2form, "Object 4", TIMES_N_FONT);

    close_pb = new CmPushButton(shell, "Close", TIMES_MEDIUM);
    close_pb->setCallback(this, (VOID_CB)&CaPagedForm::closeDialog);

    shell->realize();
}

void PagedFormDemo(void)
{
	new CaPagedForm;
}
