/*
 *    File table.cpp
 *      Demonstrates the use of the STATUSBAR Object
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mguipp.h"

#include "mguitest.hpp"

class TableFormDialog : public CmCallback
{
    CmShell *shell;
public:
    TableFormDialog();
    void closeDialog(void) { delete shell; delete this; };
};

TableFormDialog::TableFormDialog(void)
{
    CmSFile *sfile;
    CmPushButton *pb;
    CmTableForm *table;
    CmLabel *lbl;
    int ii, nc;
    char buff[64];

    shell = new CmShell("Table Form", 0);
/*
 * Let's create a TableForm with 'nc' columns
 */
    nc = 4;
    table = new CmTableForm(shell, nc);

//    table->setSpacing(3);
    table->setShadow(WS_NONE, 0, 0);
//    table->setBackgroundRGB(255, 0, 0);
 /*
  * Now let's add 5 rows of Label objects
  */
    for (ii=0; ii < 5*nc; ii++)
    {
	sprintf(buff, "Cell %d - %d", ii/nc, ii%nc);
	lbl = new CmLabel(table, buff, (ii%3) ? FIXED_MEDIUM : FIXED_LARGE);
	lbl->setResize(False, False);
    }

    table->showGrid();
    table->setColAlign(0, LEFT_ALIGN);
    table->setColAlign(3, RIGHT_ALIGN);
    table->setColFont(1, TIMES_LARGE);
    table->setColBackgroundRGB(3, 0, 255, 255);
    table->setColForegroundRGB(2, 255, 255, 255);

/*
 * Create a SFILE Object to view this source file in the dialog
 */
    sfile = new CmSFile(shell, __FILE__, FIXED_MEDIUM, 10, 48);
    sfile->setColor(darkblue, white);
/*
 * This PUSH BUTTON closes the dialog
 */
    pb = new CmPushButton(shell, "Close", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&TableFormDialog::closeDialog);

    shell->realize();
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void
TableFormDemo(void)
{
	new TableFormDialog;
}
